/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import net.sf.mpxj.mpp.FixedMeta;
import net.sf.mpxj.mpp.MPPComponent;
import net.sf.mpxj.mpp.MPPUtility;

final class FixedData
extends MPPComponent {
    private Object[] m_array;
    private int[] m_offset;

    FixedData(FixedMeta fixedMeta, InputStream inputStream) throws IOException {
        this(fixedMeta, inputStream, 0);
    }

    FixedData(FixedMeta fixedMeta, InputStream inputStream, int n) throws IOException {
        this(fixedMeta, inputStream, n, 0);
    }

    FixedData(FixedMeta fixedMeta, InputStream inputStream, int n, int n2) throws IOException {
        byte[] byArray = new byte[inputStream.available()];
        inputStream.read(byArray);
        int n3 = fixedMeta.getAdjustedItemCount();
        this.m_array = new Object[n3];
        this.m_offset = new int[n3];
        for (int i = 0; i < n3; ++i) {
            int n4;
            byte[] byArray2 = fixedMeta.getByteArrayValue(i);
            int n5 = MPPUtility.getInt(byArray2, 4);
            if (n5 < 0 || n5 > byArray.length) continue;
            if (i + 1 == n3) {
                n4 = byArray.length - n5;
            } else {
                byte[] byArray3 = fixedMeta.getByteArrayValue(i + 1);
                int n6 = MPPUtility.getInt(byArray3, 4);
                n4 = n6 - n5;
            }
            if (n4 == 0) {
                n4 = n2;
            }
            int n7 = byArray.length - n5;
            if (n4 < 0 || n4 > n7) {
                n4 = n == 0 ? n7 : (n < n7 ? n : n7);
            }
            if (n != 0 && n4 > n) {
                n4 = n;
            }
            if (n4 <= 0) continue;
            this.m_array[i] = MPPUtility.cloneSubArray(byArray, n5, n4);
            this.m_offset[i] = n5;
        }
    }

    FixedData(FixedMeta fixedMeta, int n, InputStream inputStream) throws IOException {
        byte[] byArray = new byte[inputStream.available()];
        inputStream.read(byArray);
        int n2 = fixedMeta.getAdjustedItemCount();
        this.m_array = new Object[n2];
        this.m_offset = new int[n2];
        for (int i = 0; i < n2; ++i) {
            byte[] byArray2 = fixedMeta.getByteArrayValue(i);
            int n3 = MPPUtility.getInt(byArray2, 4);
            if (n3 > byArray.length) continue;
            int n4 = byArray.length - n3;
            if (n < 0) {
                n = n4;
            } else if (n > n4) {
                n = n4;
            }
            this.m_array[i] = MPPUtility.cloneSubArray(byArray, n3, n);
            this.m_offset[i] = n3;
        }
    }

    FixedData(int n, InputStream inputStream) throws IOException {
        this(n, inputStream, false);
    }

    FixedData(int n, InputStream inputStream, boolean bl) throws IOException {
        int n2 = 0;
        int n3 = inputStream.available() / n;
        if (bl && inputStream.available() % n != 0) {
            ++n3;
        }
        this.m_array = new Object[n3];
        this.m_offset = new int[n3];
        for (int i = 0; i < n3; ++i) {
            this.m_offset[i] = n2;
            int n4 = n;
            if (bl && inputStream.available() < n) {
                n4 = inputStream.available();
            }
            this.m_array[i] = this.readByteArray(inputStream, n4);
            n2 += n;
        }
    }

    public byte[] getByteArrayValue(int n) {
        byte[] byArray = null;
        if (n >= 0 && n < this.m_array.length && this.m_array[n] != null) {
            byArray = (byte[])this.m_array[n];
        }
        return byArray;
    }

    public int getItemCount() {
        return this.m_array.length;
    }

    public boolean isValidOffset(Integer n) {
        return n == null ? false : this.isValidOffset((int)n);
    }

    public boolean isValidOffset(int n) {
        return n >= 0 && n < this.m_array.length;
    }

    public int getIndexFromOffset(int n) {
        int n2 = -1;
        for (int i = 0; i < this.m_offset.length; ++i) {
            if (this.m_offset[i] != n) continue;
            n2 = i;
            break;
        }
        return n2;
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("BEGIN FixedData");
        for (int i = 0; i < this.m_array.length; ++i) {
            printWriter.println("   Data at index: " + i + " offset: " + this.m_offset[i]);
            printWriter.println("  " + MPPUtility.hexdump((byte[])this.m_array[i], true));
        }
        printWriter.println("END FixedData");
        printWriter.println();
        printWriter.close();
        return stringWriter.toString();
    }
}

