/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.armedbear.lisp.AbstractString;
import org.armedbear.lisp.ControlTransfer;
import org.armedbear.lisp.DocString;
import org.armedbear.lisp.Fixnum;
import org.armedbear.lisp.Function;
import org.armedbear.lisp.JavaClassLoader;
import org.armedbear.lisp.JavaException;
import org.armedbear.lisp.JavaObject;
import org.armedbear.lisp.Keyword;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispClass;
import org.armedbear.lisp.LispError;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.LispThread;
import org.armedbear.lisp.Operator;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.SimpleString;
import org.armedbear.lisp.StorageCondition;
import org.armedbear.lisp.Symbol;
import org.armedbear.lisp.WrongNumberOfArgumentsException;

public final class Java {
    static final Map<Class, Symbol> registeredExceptions = new HashMap<Class, Symbol>();
    private static final LispClass java_exception = LispClass.findClass(Symbol.JAVA_EXCEPTION);
    private static final Primitive ENSURE_JAVA_OBJECT = new pf_ensure_java_object();
    private static final Primitive REGISTER_JAVA_EXCEPTION = new pf_register_java_exception();
    private static final Primitive UNREGISTER_JAVA_EXCEPTION = new pf_unregister_java_exception();
    private static final Primitive JCLASS = new pf_jclass();
    private static final Primitive JFIELD = new pf_jfield();
    private static final Primitive JFIELD_RAW = new pf_jfield_raw();
    private static final Primitive JCONSTRUCTOR = new pf_jconstructor();
    private static final Primitive JMETHOD = new pf_jmethod();
    private static final Primitive JSTATIC = new pf_jstatic();
    private static final Primitive JSTATIC_RAW = new pf_jstatic_raw();
    private static final Primitive JNEW = new pf_jnew();
    private static final Primitive JNEW_ARRAY = new pf_jnew_array();
    private static final Primitive JARRAY_REF = new pf_jarray_ref();
    private static final Primitive JARRAY_REF_RAW = new pf_jarray_ref_raw();
    private static final Primitive JARRAY_SET = new pf_jarray_set();
    private static final Primitive JCALL = new pf_jcall();
    private static final Primitive JCALL_RAW = new pf_jcall_raw();
    private static final Primitive JRESOLVE_METHOD = new pf_jresolve_method();
    private static final Primitive MAKE_IMMEDIATE_OBJECT = new pf_make_immediate_object();
    private static final Primitive JNULL_REF_P = new pf_jnull_ref_p();
    private static final Primitive JAVA_OBJECT_P = new pf_java_object_p();
    private static final Primitive JOBJECT_LISP_VALUE = new pf_jobject_lisp_value();
    private static final Primitive JCOERCE = new pf_jcoerce();
    private static final Primitive JRUN_EXCEPTION_PROTECTED = new pf_jrun_exception_protected();

    static boolean isJavaException(LispClass lc) {
        return lc.subclassp(java_exception);
    }

    static Symbol getCondition(Class cl) {
        Class o = Java.classForName("java.lang.Object");
        for (Class c = cl; c != o; c = c.getSuperclass()) {
            LispClass lispClass;
            Symbol object = registeredExceptions.get(c);
            if (!(object instanceof Symbol) || !Java.isJavaException(lispClass = (LispClass)LispClass.findClass(object, true))) continue;
            return object;
        }
        return null;
    }

    static final LispObject jfield(Primitive fun, LispObject[] args, boolean translate) {
        if (args.length < 2 || args.length > 4) {
            Lisp.error(new WrongNumberOfArgumentsException((Operator)fun, 2, 4));
        }
        String fieldName = null;
        Object instance = null;
        try {
            Class<?> c;
            if (args[1] instanceof AbstractString) {
                fieldName = args[1].getStringValue();
                c = Java.javaClass(args[0]);
            } else {
                fieldName = args[0].getStringValue();
                instance = JavaObject.getObject(args[1]);
                c = instance.getClass();
            }
            Field f = c.getField(fieldName);
            Class<?> fieldType = f.getType();
            switch (args.length) {
                case 2: {
                    break;
                }
                case 3: {
                    if (instance == null) {
                        if (args[2] instanceof JavaObject) {
                            instance = JavaObject.getObject(args[2]);
                            break;
                        }
                        f.set(null, args[2].javaInstance(fieldType));
                        return args[2];
                    }
                    f.set(instance, args[2].javaInstance(fieldType));
                    return args[2];
                }
                case 4: {
                    if (args[2] != Lisp.NIL) {
                        instance = JavaObject.getObject(args[2]);
                    }
                    f.set(instance, args[3].javaInstance(fieldType));
                    return args[3];
                }
            }
            return JavaObject.getInstance(f.get(instance), translate, f.getType());
        }
        catch (NoSuchFieldException e) {
            Lisp.error(new LispError("no such field"));
        }
        catch (SecurityException e) {
            Lisp.error(new LispError("inaccessible field"));
        }
        catch (IllegalAccessException e) {
            Lisp.error(new LispError("illegal access"));
        }
        catch (IllegalArgumentException e) {
            Lisp.error(new LispError("illegal argument"));
        }
        return Lisp.NIL;
    }

    static final LispObject jstatic(Primitive fun, LispObject[] args, boolean translate) {
        if (args.length < 2) {
            Lisp.error(new WrongNumberOfArgumentsException((Operator)fun, 2, -1));
        }
        try {
            Method m = null;
            Class c = null;
            LispObject methodRef = args[0];
            ArrayList<Method> staticMethods = new ArrayList<Method>();
            String methodName = null;
            if (methodRef instanceof JavaObject) {
                Object obj = ((JavaObject)methodRef).getObject();
                if (obj instanceof Method) {
                    staticMethods.add((Method)obj);
                    methodName = ((Method)obj).getName();
                } else {
                    Lisp.error(new LispError(methodRef + "is not a valid reference to a Method"));
                }
            } else if (methodRef instanceof AbstractString) {
                c = Java.javaClass(args[1]);
                if (c != null) {
                    methodName = methodRef.getStringValue();
                    Method[] methods = c.getMethods();
                    int argCount = args.length - 2;
                    for (Method m1 : methods) {
                        if (!Modifier.isStatic(m1.getModifiers())) continue;
                        staticMethods.add(m1);
                    }
                }
            } else {
                Lisp.type_error(methodRef, Symbol.STRING);
            }
            if (staticMethods.size() > 0) {
                m = Java.findMethod(staticMethods.toArray(new Method[staticMethods.size()]), methodName, args, 2);
            }
            if (m == null) {
                StringBuilder sb = new StringBuilder("No such static method: ");
                String className = "<unknown>";
                if (c != null) {
                    className = c.getName();
                }
                sb.append(className);
                sb.append('.');
                sb.append(methodName);
                sb.append('(');
                for (int i = 2; i < args.length; ++i) {
                    LispObject argClass = Symbol.JCLASS_OF.execute(args[i]);
                    sb.append(argClass.princToString());
                    if (i >= args.length - 1) continue;
                    sb.append(',');
                }
                sb.append(')');
                Lisp.error(new LispError(sb.toString()));
            }
            Object[] methodArgs = new Object[args.length - 2];
            Class<?>[] argTypes = m.getParameterTypes();
            for (int i = 2; i < args.length; ++i) {
                LispObject arg = args[i];
                methodArgs[i - 2] = arg.equals(Lisp.NIL) ? Boolean.valueOf(false) : (arg.equals(Lisp.T) ? Boolean.valueOf(true) : arg.javaInstance(argTypes[i - 2]));
            }
            m.setAccessible(true);
            Object result = null;
            if (!m.isVarArgs()) {
                result = m.invoke(null, methodArgs);
            } else if (argTypes.length == 1) {
                result = m.invoke(null, new Object[]{methodArgs});
            } else {
                Object[] objectArgs = new Object[methodArgs.length];
                for (int i = 0; i < methodArgs.length; ++i) {
                    objectArgs[i] = methodArgs[i];
                }
                result = m.invoke(null, objectArgs);
            }
            return JavaObject.getInstance(result, translate, m.getReturnType());
        }
        catch (ControlTransfer c) {
            throw c;
        }
        catch (Throwable t) {
            Symbol condition;
            if (t instanceof InvocationTargetException) {
                t = t.getCause();
            }
            if ((condition = Java.getCondition(t.getClass())) == null) {
                Lisp.error(new JavaException(t));
            } else {
                Symbol.SIGNAL.execute(condition, Keyword.CAUSE, JavaObject.getInstance(t), Keyword.FORMAT_CONTROL, new SimpleString(Java.getMessage(t)));
            }
            return Lisp.NIL;
        }
    }

    static final LispObject jarray_ref(Primitive fun, LispObject[] args, boolean translate) {
        if (args.length < 2) {
            Lisp.error(new WrongNumberOfArgumentsException((Operator)fun, 2, -1));
        }
        try {
            Object a = args[0].javaInstance();
            for (int i = 1; i < args.length - 1; ++i) {
                a = Array.get(a, (Integer)args[i].javaInstance());
            }
            return JavaObject.getInstance(Array.get(a, (Integer)args[args.length - 1].javaInstance()), translate);
        }
        catch (Throwable t) {
            Symbol condition = Java.getCondition(t.getClass());
            if (condition == null) {
                Lisp.error(new JavaException(t));
            } else {
                Symbol.SIGNAL.execute(condition, Keyword.CAUSE, JavaObject.getInstance(t), Keyword.FORMAT_CONTROL, new SimpleString(Java.getMessage(t)));
            }
            return Lisp.NIL;
        }
    }

    static LispObject jcall(Primitive fun, LispObject[] args, boolean translate) {
        if (args.length < 2) {
            Lisp.error(new WrongNumberOfArgumentsException((Operator)fun, 2, -1));
        }
        try {
            Class<?>[] argTypes;
            Method method;
            Object[] methodArgs;
            Object instance;
            LispObject methodArg = args[0];
            LispObject instanceArg = args[1];
            Class<?> intendedClass = null;
            if (instanceArg instanceof AbstractString) {
                instance = instanceArg.getStringValue();
            } else if (instanceArg instanceof JavaObject) {
                JavaObject jobj = (JavaObject)instanceArg;
                instance = jobj.getObject();
                intendedClass = jobj.getIntendedClass();
            } else {
                instance = instanceArg.javaInstance();
            }
            if (instance == null) {
                throw new NullPointerException();
            }
            if (methodArg instanceof AbstractString) {
                String methodName = methodArg.getStringValue();
                method = Java.findMethod(instance, intendedClass, methodName, methodArgs = Java.translateMethodArguments(args, 2));
                if (method == null) {
                    if (intendedClass == null) {
                        String msg = MessageFormat.format("No instance method named {0} found for type {1}", methodName, instance.getClass().getName());
                        throw new NoSuchMethodException(msg);
                    }
                    String classes = intendedClass.getName();
                    Class<?> actualClass = instance.getClass();
                    if (actualClass != intendedClass) {
                        classes = classes + " or " + actualClass.getName();
                    }
                    throw new NoSuchMethodException("No applicable method named " + methodName + " found in " + classes);
                }
            } else {
                method = (Method)JavaObject.getObject(methodArg);
            }
            if ((argTypes = method.getParameterTypes()).length != args.length - 2) {
                return Lisp.error(new WrongNumberOfArgumentsException("Wrong number of arguments for " + method + ": expected " + argTypes.length + ", got " + (args.length - 2)));
            }
            methodArgs = new Object[argTypes.length];
            for (int i = 2; i < args.length; ++i) {
                LispObject arg = args[i];
                methodArgs[i - 2] = arg.equals(Lisp.NIL) ? Boolean.valueOf(false) : (arg.equals(Lisp.T) ? Boolean.valueOf(true) : arg.javaInstance(argTypes[i - 2]));
            }
            if (!method.isAccessible() && Modifier.isPublic(method.getModifiers())) {
                method.setAccessible(true);
            }
            return JavaObject.getInstance(method.invoke(instance, methodArgs), translate, method.getReturnType());
        }
        catch (ControlTransfer t) {
            throw t;
        }
        catch (Throwable t) {
            Symbol condition;
            if (t instanceof InvocationTargetException) {
                t = t.getCause();
            }
            if ((condition = Java.getCondition(t.getClass())) == null) {
                Lisp.error(new JavaException(t));
            } else {
                Symbol.SIGNAL.execute(condition, Keyword.CAUSE, JavaObject.getInstance(t), Keyword.FORMAT_CONTROL, new SimpleString(Java.getMessage(t)));
            }
            return null;
        }
    }

    private static Object[] translateMethodArguments(LispObject[] args) {
        return Java.translateMethodArguments(args, 0);
    }

    private static Object[] translateMethodArguments(LispObject[] args, int offs) {
        int argCount = args.length - offs;
        Object[] javaArgs = new Object[argCount];
        for (int i = 0; i < argCount; ++i) {
            LispObject x = args[i + offs];
            javaArgs[i] = x.equals(Lisp.NIL) ? Boolean.valueOf(false) : (x.equals(Lisp.T) ? Boolean.valueOf(true) : x.javaInstance());
        }
        return javaArgs;
    }

    private static Method findMethod(Method[] methods, String methodName, Object[] javaArgs) {
        int argCount = javaArgs.length;
        Method result = null;
        int i = methods.length;
        while (i-- > 0) {
            Class<?>[] methodTypes;
            Method method = methods[i];
            if (!method.getName().equals(methodName) || method.getParameterTypes().length != argCount || !Java.isApplicableMethod(methodTypes = method.getParameterTypes(), javaArgs) || result != null && !Java.isMoreSpecialized(methodTypes, result.getParameterTypes())) continue;
            result = method;
        }
        return result;
    }

    private static Method findMethod(Object instance, Class<?> intendedClass, String methodName, Object[] methodArgs) {
        if (intendedClass == null) {
            intendedClass = instance.getClass();
        }
        Method method = Java.findMethod(intendedClass, methodName, methodArgs);
        Class<?> actualClass = null;
        if (method == null && intendedClass != (actualClass = instance.getClass()) && (method = Java.findMethod(actualClass, methodName, methodArgs)) != null && Java.isMethodCallableOnInstance(actualClass, method)) {
            return method;
        }
        return method;
    }

    private static boolean isMethodCallableOnInstance(Class instance, Method method) {
        if (Modifier.isPublic(method.getModifiers())) {
            return true;
        }
        if (instance.isMemberClass()) {
            return Java.isMethodCallableOnInstance(instance.getEnclosingClass(), method);
        }
        return false;
    }

    private static Method findMethod(Class<?> c, String methodName, Object[] javaArgs) {
        Method[] methods = c.getMethods();
        return Java.findMethod(methods, methodName, javaArgs);
    }

    private static Method findMethod(Class<?> c, String methodName, LispObject[] args, int offset) {
        Object[] javaArgs = Java.translateMethodArguments(args, offset);
        return Java.findMethod(c, methodName, javaArgs);
    }

    private static Method findMethod(Method[] methods, String methodName, LispObject[] args, int offset) {
        Object[] javaArgs = Java.translateMethodArguments(args, offset);
        return Java.findMethod(methods, methodName, javaArgs);
    }

    static Constructor findConstructor(Class<?> c, LispObject[] args) throws NoSuchMethodException {
        int argCount = args.length - 1;
        Object[] javaArgs = Java.translateMethodArguments(args, 1);
        Constructor<?>[] ctors = c.getConstructors();
        Constructor<?> result = null;
        int i = ctors.length;
        while (i-- > 0) {
            Class<?>[] methodTypes;
            Constructor<?> ctor = ctors[i];
            if (ctor.getParameterTypes().length != argCount || !Java.isApplicableMethod(methodTypes = ctor.getParameterTypes(), javaArgs) || result != null && !Java.isMoreSpecialized(methodTypes, result.getParameterTypes())) continue;
            result = ctor;
        }
        if (result == null) {
            StringBuilder sb = new StringBuilder(c.getSimpleName());
            sb.append('(');
            boolean first = true;
            for (Object o : javaArgs) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                if (o != null) {
                    sb.append(o.getClass().getName());
                    continue;
                }
                sb.append("<null>");
            }
            sb.append(')');
            throw new NoSuchMethodException(sb.toString());
        }
        return result;
    }

    private static boolean isAssignable(Class<?> from, Class<?> to) {
        from = Java.maybeBoxClass(from);
        if ((to = Java.maybeBoxClass(to)).isAssignableFrom(from)) {
            return true;
        }
        if (Byte.class.equals(from)) {
            return Short.class.equals(to) || Integer.class.equals(to) || Long.class.equals(to) || Float.class.equals(to) || Double.class.equals(to);
        }
        if (Short.class.equals(from) || Character.class.equals(from)) {
            return Integer.class.equals(to) || Long.class.equals(to) || Float.class.equals(to) || Double.class.equals(to);
        }
        if (Integer.class.equals(from)) {
            return Long.class.equals(to) || Float.class.equals(to) || Double.class.equals(to);
        }
        if (Long.class.equals(from)) {
            return Float.class.equals(to) || Double.class.equals(to);
        }
        if (Float.class.equals(from)) {
            return Double.class.equals(to);
        }
        return from.isArray() && to.isArray() && to.getComponentType().equals(Object.class);
    }

    private static boolean isApplicableMethod(Class<?>[] methodTypes, Object[] args) {
        for (int i = 0; i < methodTypes.length; ++i) {
            Class<?> methodType = methodTypes[i];
            Object arg = args[i];
            if (arg == null) {
                return !methodType.isPrimitive();
            }
            if (Java.isAssignableWithValue(arg.getClass(), methodType, arg)) continue;
            return false;
        }
        return true;
    }

    private static boolean isAssignableWithValue(Class<?> from, Class<?> to, Object value) {
        if (Java.isAssignable(from, to)) {
            return true;
        }
        if (!(value instanceof Number)) {
            return false;
        }
        from = Java.maybeBoxClass(from);
        to = Java.maybeBoxClass(to);
        if (Integer.class.equals(from)) {
            int v = ((Number)value).intValue();
            if (Short.class.equals(to) && Short.MAX_VALUE >= v && v >= Short.MIN_VALUE) {
                return true;
            }
            if (Byte.class.equals(to) && 255 >= v && v >= 0) {
                return true;
            }
        } else if (BigInteger.class.equals(from)) {
            BigInteger v = (BigInteger)value;
            BigInteger maxLong = BigInteger.valueOf(Long.MAX_VALUE);
            BigInteger minLong = BigInteger.valueOf(Long.MIN_VALUE);
            if (!(!Long.class.equals(to) || v.compareTo(maxLong) != -1 && v.compareTo(maxLong) != 0 || v.compareTo(minLong) != 1 && v.compareTo(minLong) != 0)) {
                return true;
            }
        }
        return false;
    }

    private static boolean isMoreSpecialized(Class<?>[] xtypes, Class<?>[] ytypes) {
        for (int i = 0; i < xtypes.length; ++i) {
            Class<?> ytype;
            Class<?> xtype = Java.maybeBoxClass(xtypes[i]);
            if (xtype.equals(ytype = Java.maybeBoxClass(ytypes[i])) || !Java.isAssignable(xtype, ytype)) continue;
            return true;
        }
        return false;
    }

    public static Class<?> maybeBoxClass(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            return Java.getBoxedClass(clazz);
        }
        return clazz;
    }

    private static Class<?> getBoxedClass(Class<?> clazz) {
        if (clazz.equals(Integer.TYPE)) {
            return Integer.class;
        }
        if (clazz.equals(Boolean.TYPE)) {
            return Boolean.class;
        }
        if (clazz.equals(Byte.TYPE)) {
            return Byte.class;
        }
        if (clazz.equals(Character.TYPE)) {
            return Character.class;
        }
        if (clazz.equals(Long.TYPE)) {
            return Long.class;
        }
        if (clazz.equals(Float.TYPE)) {
            return Float.class;
        }
        if (clazz.equals(Double.TYPE)) {
            return Double.class;
        }
        if (clazz.equals(Short.TYPE)) {
            return Short.class;
        }
        return Void.class;
    }

    private static Class classForName(String className) {
        return Java.classForName(className, JavaClassLoader.getPersistentInstance());
    }

    private static Class classForName(String className, ClassLoader classLoader) {
        try {
            if (!className.endsWith("[]")) {
                return Class.forName(className, true, classLoader);
            }
            if (className.startsWith("byte")) {
                return Class.forName("[B");
            }
            if (className.startsWith("char")) {
                return Class.forName("[C");
            }
            if (className.startsWith("double")) {
                return Class.forName("[D");
            }
            if (className.startsWith("float")) {
                return Class.forName("[F");
            }
            if (className.startsWith("int")) {
                return Class.forName("[I");
            }
            if (className.startsWith("long")) {
                return Class.forName("[J");
            }
            if (className.startsWith("short")) {
                return Class.forName("[S");
            }
            if (className.startsWith("boolean")) {
                return Class.forName("[Z");
            }
            String arrayTypeName = "[L" + className.substring(0, className.length() - 2) + ";";
            return Class.forName(arrayTypeName);
        }
        catch (ClassNotFoundException e) {
            Lisp.error(new LispError("Class not found: " + className));
            return null;
        }
    }

    private static Class javaClass(LispObject obj) {
        return Java.javaClass(obj, JavaClassLoader.getCurrentClassLoader());
    }

    static Class javaClass(LispObject obj, ClassLoader classLoader) {
        if (obj instanceof AbstractString || obj instanceof Symbol) {
            String s = Lisp.javaString(obj);
            if (s.equals("boolean")) {
                return Boolean.TYPE;
            }
            if (s.equals("byte")) {
                return Byte.TYPE;
            }
            if (s.equals("char")) {
                return Character.TYPE;
            }
            if (s.equals("short")) {
                return Short.TYPE;
            }
            if (s.equals("int")) {
                return Integer.TYPE;
            }
            if (s.equals("long")) {
                return Long.TYPE;
            }
            if (s.equals("float")) {
                return Float.TYPE;
            }
            if (s.equals("double")) {
                return Double.TYPE;
            }
            Class c = Java.classForName(s, classLoader);
            if (c == null) {
                Lisp.error(new LispError(s + " does not designate a Java class."));
            }
            return c;
        }
        if (!(obj instanceof JavaObject)) {
            Lisp.type_error(obj, Lisp.list(Symbol.OR, Symbol.STRING, Symbol.JAVA_OBJECT));
            return null;
        }
        JavaObject javaObject = (JavaObject)obj;
        Object javaObjectgetObject = javaObject.getObject();
        if (javaObjectgetObject instanceof Class) {
            return (Class)javaObjectgetObject;
        }
        Lisp.error(new LispError(obj.princToString() + " does not designate a Java class."));
        return null;
    }

    static final String getMessage(Throwable t) {
        String message = t.getMessage();
        if (message == null || message.length() == 0) {
            message = t.getClass().getName();
        }
        return message;
    }

    public static class Buffers {
        public static AllocationPolicy active = AllocationPolicy.NIO;

        public static enum AllocationPolicy {
            PRIMITIVE_ARRAY,
            NIO;

        }
    }

    @DocString(name="jrun-exception-protected", args="closure", doc="Invokes the function CLOSURE and returns the result.  Signals an error if stack or heap exhaustion occurs.")
    private static final class pf_jrun_exception_protected
    extends Primitive {
        pf_jrun_exception_protected() {
            super("jrun-exception-protected", Lisp.PACKAGE_JAVA, true);
        }

        @Override
        public LispObject execute(LispObject closure) {
            Function fun = Lisp.checkFunction(closure);
            try {
                return LispThread.currentThread().execute(closure);
            }
            catch (OutOfMemoryError oom) {
                return Lisp.error(new StorageCondition("Out of memory " + oom.getMessage()));
            }
            catch (StackOverflowError oos) {
                oos.printStackTrace();
                return Lisp.error(new StorageCondition("Stack overflow."));
            }
        }
    }

    @DocString(name="jcoerce", args="object intended-class", doc="Attempts to coerce OBJECT into a JavaObject of class INTENDED-CLASS.  Raises a TYPE-ERROR if no conversion is possible.")
    private static final class pf_jcoerce
    extends Primitive {
        pf_jcoerce() {
            super("jcoerce", Lisp.PACKAGE_JAVA, true);
        }

        @Override
        public LispObject execute(LispObject javaObject, LispObject intendedClass) {
            Object o = javaObject.javaInstance();
            Class c = Java.javaClass(intendedClass);
            try {
                return JavaObject.getInstance(o, c);
            }
            catch (ClassCastException e) {
                return Lisp.type_error(javaObject, new SimpleString(c.getName()));
            }
        }
    }

    @DocString(name="jobject-lisp-value", args="java-object", doc="Attempts to coerce JAVA-OBJECT into a Lisp object.")
    private static final class pf_jobject_lisp_value
    extends Primitive {
        pf_jobject_lisp_value() {
            super("jobject-lisp-value", Lisp.PACKAGE_JAVA, true, "java-object");
        }

        @Override
        public LispObject execute(LispObject arg) {
            return JavaObject.getInstance(arg.javaInstance(), true);
        }
    }

    @DocString(name="java-object-p", args="object", doc="Returns T if OBJECT is a JAVA-OBJECT.")
    private static final class pf_java_object_p
    extends Primitive {
        pf_java_object_p() {
            super("java-object-p", Lisp.PACKAGE_JAVA, true);
        }

        @Override
        public LispObject execute(LispObject arg) {
            return arg instanceof JavaObject ? Lisp.T : Lisp.NIL;
        }
    }

    @DocString(name="jnull-ref-p", args="object", doc="Returns a non-NIL value when the JAVA-OBJECT `object` is `null`,\nor signals a TYPE-ERROR condition if the object isn't of\nthe right type.")
    private static final class pf_jnull_ref_p
    extends Primitive {
        pf_jnull_ref_p() {
            super("jnull-ref-p", Lisp.PACKAGE_JAVA, true);
        }

        @Override
        public LispObject execute(LispObject ref) {
            if (ref instanceof JavaObject) {
                JavaObject jref = (JavaObject)ref;
                return jref.javaInstance() == null ? Lisp.T : Lisp.NIL;
            }
            return Lisp.type_error(ref, Symbol.JAVA_OBJECT);
        }
    }

    @DocString(name="make-immediate-object", args="object &optional type", doc="Attempts to coerce a given Lisp object into a java-object of the\ngiven type.  If type is not provided, works as jobject-lisp-value.\nCurrently, type may be :BOOLEAN, treating the object as a truth value,\nor :REF, which returns Java null if NIL is provided.\n\nDeprecated.  Please use JAVA:+NULL+, JAVA:+TRUE+, and JAVA:+FALSE+ for\nconstructing wrapped primitive types, JAVA:JOBJECT-LISP-VALUE for converting a\nJAVA:JAVA-OBJECT to a Lisp value, or JAVA:JNULL-REF-P to distinguish a wrapped\nnull JAVA-OBJECT from NIL.")
    private static final class pf_make_immediate_object
    extends Primitive {
        pf_make_immediate_object() {
            super("make-immediate-object", Lisp.PACKAGE_JAVA, true);
        }

        @Override
        public LispObject execute(LispObject[] args) {
            Symbol.WARN.getSymbolFunction().execute(new SimpleString("JAVA:MAKE-IMMEDIATE-OBJECT is deprecated."));
            if (args.length < 1) {
                Lisp.error(new WrongNumberOfArgumentsException((Operator)this, 1, -1));
            }
            LispObject object = args[0];
            if (args.length > 1) {
                LispObject type = args[1];
                if (type == Keyword.BOOLEAN) {
                    if (object == Lisp.NIL) {
                        return JavaObject.getInstance(Boolean.FALSE);
                    }
                    return JavaObject.getInstance(Boolean.TRUE);
                }
                if (type == Keyword.REF) {
                    if (object == Lisp.NIL) {
                        return JavaObject.getInstance(null);
                    }
                    Lisp.error(new LispError("MAKE-IMMEDIATE-OBJECT: not implemented"));
                }
            }
            return JavaObject.getInstance(object.javaInstance());
        }
    }

    @DocString(name="jresolve-method", args="method-name instance &rest args", doc="Finds the most specific Java method METHOD-NAME on INSTANCE applicable to arguments ARGS. Returns NIL if no suitable method is found. The algorithm used for resolution is the same used by JCALL when it is called with a string as the first parameter (METHOD-REF).")
    private static final class pf_jresolve_method
    extends Primitive {
        pf_jresolve_method() {
            super(Symbol.JRESOLVE_METHOD);
        }

        @Override
        public LispObject execute(LispObject[] args) {
            Object[] methodArgs;
            Object instance;
            if (args.length < 2) {
                Lisp.error(new WrongNumberOfArgumentsException((Operator)this, 2, -1));
            }
            LispObject methodArg = args[0];
            LispObject instanceArg = args[1];
            Class<?> intendedClass = null;
            if (instanceArg instanceof AbstractString) {
                instance = instanceArg.getStringValue();
            } else if (instanceArg instanceof JavaObject) {
                JavaObject jobj = (JavaObject)instanceArg;
                instance = jobj.getObject();
                intendedClass = jobj.getIntendedClass();
            } else {
                instance = instanceArg.javaInstance();
            }
            if (instance == null) {
                return Lisp.program_error("JRESOLVE-METHOD: instance must not be null.");
            }
            String methodName = methodArg.getStringValue();
            Method method = Java.findMethod(instance, intendedClass, methodName, methodArgs = Java.translateMethodArguments(args, 2));
            if (method != null) {
                return JavaObject.getInstance(method);
            }
            if (!(instanceArg instanceof JavaObject)) {
                return Lisp.NIL;
            }
            intendedClass = ((JavaObject)instanceArg).getObject().getClass();
            method = Java.findMethod(instance, intendedClass, methodName, methodArgs);
            if (method != null) {
                return JavaObject.getInstance(method);
            }
            return Lisp.NIL;
        }
    }

    @DocString(name="jcall-raw", args="method-ref instance &rest args", doc="Invokes the Java method METHOD-REF on INSTANCE with arguments ARGS. Does not attempt to coerce the result into a Lisp object.")
    private static final class pf_jcall_raw
    extends Primitive {
        pf_jcall_raw() {
            super(Symbol.JCALL_RAW);
        }

        @Override
        public LispObject execute(LispObject[] args) {
            return Java.jcall(this, args, false);
        }
    }

    @DocString(name="jcall", args="method-ref instance &rest args", doc="Invokes the Java method METHOD-REF on INSTANCE with arguments ARGS, coercing the result into a Lisp object, if possible.")
    private static final class pf_jcall
    extends Primitive {
        pf_jcall() {
            super(Symbol.JCALL);
        }

        @Override
        public LispObject execute(LispObject[] args) {
            return Java.jcall(this, args, true);
        }
    }

    @DocString(name="jarray-set", args="java-array new-value &rest indices", doc="Stores NEW-VALUE at the given INDICES in JAVA-ARRAY.")
    private static final class pf_jarray_set
    extends Primitive {
        pf_jarray_set() {
            super("jarray-set", Lisp.PACKAGE_JAVA, true);
        }

        @Override
        public LispObject execute(LispObject[] args) {
            if (args.length < 3) {
                Lisp.error(new WrongNumberOfArgumentsException((Operator)this, 3, -1));
            }
            try {
                Object a = args[0].javaInstance();
                LispObject v = args[1];
                for (int i = 2; i < args.length - 1; ++i) {
                    a = Array.get(a, (Integer)args[i].javaInstance());
                }
                Object value = v.javaInstance();
                int index = (Integer)args[args.length - 1].javaInstance();
                if (value instanceof Number) {
                    Class<?> type = a.getClass().getComponentType();
                    Number number = (Number)value;
                    if (type.equals(Byte.TYPE)) {
                        Array.setByte(a, index, number.byteValue());
                    } else if (type.equals(Short.TYPE)) {
                        Array.setShort(a, index, number.shortValue());
                    } else if (type.equals(Character.TYPE)) {
                        Array.setChar(a, index, (char)number.intValue());
                    } else if (type.equals(Integer.TYPE)) {
                        Array.setInt(a, index, number.intValue());
                    } else if (type.equals(Long.TYPE)) {
                        Array.setLong(a, index, number.longValue());
                    } else if (type.equals(Float.TYPE)) {
                        Array.setFloat(a, index, number.floatValue());
                    } else if (type.equals(Double.TYPE)) {
                        Array.setDouble(a, index, number.doubleValue());
                    } else if (type.equals(Boolean.TYPE)) {
                        Array.setBoolean(a, index, !number.equals(0));
                    } else {
                        Array.set(a, index, value);
                    }
                } else {
                    Array.set(a, index, value);
                }
                return v;
            }
            catch (Throwable t) {
                Symbol condition = Java.getCondition(t.getClass());
                if (condition == null) {
                    Lisp.error(new JavaException(t));
                } else {
                    Symbol.SIGNAL.execute(condition, Keyword.CAUSE, JavaObject.getInstance(t), Keyword.FORMAT_CONTROL, new SimpleString(Java.getMessage(t)));
                }
                return Lisp.NIL;
            }
        }
    }

    @DocString(name="jarray-ref-raw", args="java-array &rest indices", doc="Dereference the Java array JAVA-ARRAY using the given INDICES. Does not attempt to coerce the result into a Lisp object.")
    private static final class pf_jarray_ref_raw
    extends Primitive {
        pf_jarray_ref_raw() {
            super("jarray-ref-raw", Lisp.PACKAGE_JAVA, true);
        }

        @Override
        public LispObject execute(LispObject[] args) {
            return Java.jarray_ref(this, args, false);
        }
    }

    @DocString(name="jarray-ref", args="java-array &rest indices", doc="Dereferences the Java array JAVA-ARRAY using the given INDICES, coercing the result into a Lisp object, if possible.")
    private static final class pf_jarray_ref
    extends Primitive {
        pf_jarray_ref() {
            super("jarray-ref", Lisp.PACKAGE_JAVA, true);
        }

        @Override
        public LispObject execute(LispObject[] args) {
            return Java.jarray_ref(this, args, true);
        }
    }

    @DocString(name="jnew-array", args="element-type &rest dimensions", doc="Creates a new Java array of type ELEMENT-TYPE, with the given DIMENSIONS.")
    private static final class pf_jnew_array
    extends Primitive {
        pf_jnew_array() {
            super("jnew-array", Lisp.PACKAGE_JAVA, true);
        }

        @Override
        public LispObject execute(LispObject[] args) {
            if (args.length < 2) {
                Lisp.error(new WrongNumberOfArgumentsException((Operator)this, 2, -1));
            }
            try {
                Class c = Java.javaClass(args[0]);
                int[] dimensions = new int[args.length - 1];
                for (int i = 1; i < args.length; ++i) {
                    dimensions[i - 1] = (Integer)args[i].javaInstance();
                }
                return JavaObject.getInstance(Array.newInstance(c, dimensions));
            }
            catch (Throwable t) {
                Lisp.error(new JavaException(t));
                return Lisp.NIL;
            }
        }
    }

    @DocString(name="jnew", args="constructor &rest args", doc="Invokes the Java constructor CONSTRUCTOR with the arguments ARGS.")
    private static final class pf_jnew
    extends Primitive {
        pf_jnew() {
            super("jnew", Lisp.PACKAGE_JAVA, true);
        }

        @Override
        public LispObject execute(LispObject[] args) {
            if (args.length < 1) {
                Lisp.error(new WrongNumberOfArgumentsException((Operator)this, 1, -1));
            }
            LispObject classRef = args[0];
            try {
                Constructor constructor;
                if (classRef instanceof AbstractString) {
                    constructor = Java.findConstructor(Java.javaClass(classRef), args);
                } else {
                    Object object = JavaObject.getObject(classRef);
                    if (object instanceof Constructor) {
                        constructor = (Constructor)object;
                    } else if (object instanceof Class) {
                        constructor = Java.findConstructor((Class)object, args);
                    } else {
                        return Lisp.error(new LispError(classRef.princToString() + " is neither a Constructor nor a Class"));
                    }
                }
                Class<?>[] argTypes = constructor.getParameterTypes();
                Object[] initargs = new Object[args.length - 1];
                for (int i = 1; i < args.length; ++i) {
                    LispObject arg = args[i];
                    initargs[i - 1] = arg.equals(Lisp.NIL) ? Boolean.valueOf(false) : (arg.equals(Lisp.T) ? Boolean.valueOf(true) : arg.javaInstance(argTypes[i - 1]));
                }
                return JavaObject.getInstance(constructor.newInstance(initargs));
            }
            catch (ControlTransfer c) {
                throw c;
            }
            catch (Throwable t) {
                Symbol condition;
                if (t instanceof InvocationTargetException) {
                    t = t.getCause();
                }
                if ((condition = Java.getCondition(t.getClass())) == null) {
                    Lisp.error(new JavaException(t));
                } else {
                    Symbol.SIGNAL.execute(condition, Keyword.CAUSE, JavaObject.getInstance(t), Keyword.FORMAT_CONTROL, new SimpleString(Java.getMessage(t)));
                }
                return Lisp.NIL;
            }
        }
    }

    @DocString(name="jstatic-raw", args="method class &rest args", doc="Invokes the static method METHOD on class CLASS with ARGS. Does not attempt to coerce the arguments or result into a Lisp object.")
    private static final class pf_jstatic_raw
    extends Primitive {
        pf_jstatic_raw() {
            super("jstatic-raw", Lisp.PACKAGE_JAVA, true);
        }

        @Override
        public LispObject execute(LispObject[] args) {
            return Java.jstatic(this, args, false);
        }
    }

    @DocString(name="jstatic", args="method class &rest args", doc="Invokes the static method METHOD on class CLASS with ARGS.")
    private static final class pf_jstatic
    extends Primitive {
        pf_jstatic() {
            super("jstatic", Lisp.PACKAGE_JAVA, true);
        }

        @Override
        public LispObject execute(LispObject[] args) {
            return Java.jstatic(this, args, true);
        }
    }

    @DocString(name="jmethod", args="class-ref method-name &rest parameter-class-refs", doc="Returns a reference to the Java method METHOD-NAME of CLASS-REF with the given PARAMETER-CLASS-REFS.")
    private static final class pf_jmethod
    extends Primitive {
        pf_jmethod() {
            super("jmethod", Lisp.PACKAGE_JAVA, true);
        }

        @Override
        public LispObject execute(LispObject[] args) {
            if (args.length < 2) {
                Lisp.error(new WrongNumberOfArgumentsException((Operator)this, 2, -1));
            }
            Class c = Java.javaClass(args[0]);
            String methodName = args[1].getStringValue();
            try {
                int argCount = 0;
                if (args.length != 3 || !(args[2] instanceof Fixnum)) {
                    Class[] parameterTypes = new Class[args.length - 2];
                    for (int i = 2; i < args.length; ++i) {
                        parameterTypes[i - 2] = Java.javaClass(args[i]);
                    }
                    return JavaObject.getInstance(c.getMethod(methodName, parameterTypes));
                }
                argCount = ((Fixnum)args[2]).value;
                Method[] methods = c.getMethods();
                for (int i = 0; i < methods.length; ++i) {
                    Method method = methods[i];
                    if (!method.getName().equals(methodName) || method.getParameterTypes().length != argCount) continue;
                    return JavaObject.getInstance(method);
                }
                throw new NoSuchMethodException();
            }
            catch (NoSuchMethodException e) {
                StringBuilder sb = new StringBuilder("No such method: ");
                sb.append(c.getName());
                sb.append('.');
                sb.append(methodName);
                sb.append('(');
                for (int i = 2; i < args.length; ++i) {
                    sb.append(args[i].princToString());
                    if (i >= args.length - 1) continue;
                    sb.append(',');
                }
                sb.append(')');
                Lisp.error(new LispError(sb.toString()));
            }
            catch (ControlTransfer e) {
                throw e;
            }
            catch (Throwable t) {
                Lisp.error(new LispError(Java.getMessage(t)));
            }
            return Lisp.NIL;
        }
    }

    @DocString(name="jconstructor", args="class-ref &rest parameter-class-refs", doc="Returns a reference to the Java constructor of CLASS-REF with the given PARAMETER-CLASS-REFS.")
    private static final class pf_jconstructor
    extends Primitive {
        pf_jconstructor() {
            super("jconstructor", Lisp.PACKAGE_JAVA, true);
        }

        @Override
        public LispObject execute(LispObject[] args) {
            if (args.length < 1) {
                Lisp.error(new WrongNumberOfArgumentsException((Operator)this, 1, -1));
            }
            try {
                Class c = Java.javaClass(args[0]);
                int argCount = 0;
                if (args.length != 2 || !(args[1] instanceof Fixnum)) {
                    Class[] parameterTypes = new Class[args.length - 1];
                    for (int i = 1; i < args.length; ++i) {
                        parameterTypes[i - 1] = Java.javaClass(args[i]);
                    }
                    return JavaObject.getInstance(c.getConstructor(parameterTypes));
                }
                argCount = Fixnum.getValue(args[1]);
                Constructor<?>[] constructors = c.getConstructors();
                for (int i = 0; i < constructors.length; ++i) {
                    Constructor<?> constructor = constructors[i];
                    if (constructor.getParameterTypes().length != argCount) continue;
                    return JavaObject.getInstance(constructor);
                }
                throw new NoSuchMethodException();
            }
            catch (NoSuchMethodException e) {
                Lisp.error(new LispError("no such constructor"));
            }
            catch (ControlTransfer e) {
                throw e;
            }
            catch (Throwable t) {
                Lisp.error(new LispError(Java.getMessage(t)));
            }
            return Lisp.NIL;
        }
    }

    @DocString(name="jfield", args="class-ref-or-field field-or-instance &optional instance value", doc="Retrieves or modifies a field in a Java class or instance. Does not\nattempt to coerce its value or the result into a Lisp object.\n\nSupported argument patterns:\n\n   Case 1: class-ref  field-name:\n      Retrieves the value of a static field.\n\n   Case 2: class-ref  field-name  instance-ref:\n      Retrieves the value of a class field of the instance.\n\n   Case 3: class-ref  field-name  primitive-value:\n      Stores a primitive-value in a static field.\n\n   Case 4: class-ref  field-name  instance-ref  value:\n      Stores value in a class field of the instance.\n\n   Case 5: class-ref  field-name  nil  value:\n      Stores value in a static field (when value may be\n      confused with an instance-ref).\n\n   Case 6: field-name  instance:\n      Retrieves the value of a field of the instance. The\n      class is derived from the instance.\n\n   Case 7: field-name  instance  value:\n      Stores value in a field of the instance. The class is\n      derived from the instance.\n\n")
    private static final class pf_jfield_raw
    extends Primitive {
        pf_jfield_raw() {
            super("jfield-raw", Lisp.PACKAGE_JAVA, true);
        }

        @Override
        public LispObject execute(LispObject[] args) {
            return Java.jfield(this, args, false);
        }
    }

    @DocString(name="jfield", args="class-ref-or-field field-or-instance &optional instance value", doc="Retrieves or modifies a field in a Java class or instance.\n\nSupported argument patterns:\n\n   Case 1: class-ref  field-name:\n      Retrieves the value of a static field.\n\n   Case 2: class-ref  field-name  instance-ref:\n      Retrieves the value of a class field of the instance.\n\n   Case 3: class-ref  field-name  primitive-value:\n      Stores a primitive-value in a static field.\n\n   Case 4: class-ref  field-name  instance-ref  value:\n      Stores value in a class field of the instance.\n\n   Case 5: class-ref  field-name  nil  value:\n      Stores value in a static field (when value may be\n      confused with an instance-ref).\n\n   Case 6: field-name  instance:\n      Retrieves the value of a field of the instance. The\n      class is derived from the instance.\n\n   Case 7: field-name  instance  value:\n      Stores value in a field of the instance. The class is\n      derived from the instance.\n\n")
    private static final class pf_jfield
    extends Primitive {
        pf_jfield() {
            super("jfield", Lisp.PACKAGE_JAVA, true);
        }

        @Override
        public LispObject execute(LispObject[] args) {
            return Java.jfield(this, args, true);
        }
    }

    @DocString(name="jclass", args="name-or-class-ref &optional class-loader", doc="Returns a reference to the Java class designated by NAME-OR-CLASS-REF. If the CLASS-LOADER parameter is passed, the class is resolved with respect to the given ClassLoader.")
    private static final class pf_jclass
    extends Primitive {
        pf_jclass() {
            super(Symbol.JCLASS);
        }

        @Override
        public LispObject execute(LispObject arg) {
            return JavaObject.getInstance(Java.javaClass(arg, JavaClassLoader.getCurrentClassLoader()));
        }

        @Override
        public LispObject execute(LispObject className, LispObject classLoader) {
            ClassLoader loader = (ClassLoader)classLoader.javaInstance(ClassLoader.class);
            return JavaObject.getInstance(Java.javaClass(className, loader));
        }
    }

    @DocString(name="unregister-java-exception", args="exception-name", doc="Unregisters the Java Throwable EXCEPTION-NAME previously registered by REGISTER-JAVA-EXCEPTION.")
    private static final class pf_unregister_java_exception
    extends Primitive {
        pf_unregister_java_exception() {
            super("unregister-java-exception", Lisp.PACKAGE_JAVA, true);
        }

        @Override
        public LispObject execute(LispObject className) {
            return registeredExceptions.remove(Java.classForName(className.getStringValue())) == null ? Lisp.NIL : Lisp.T;
        }
    }

    @DocString(name="register-java-exception", args="exception-name condition-symbol", doc="Registers the Java Throwable named by the symbol EXCEPTION-NAME as the condition designated by CONDITION-SYMBOL.  Returns T if successful, NIL if not.")
    private static final class pf_register_java_exception
    extends Primitive {
        pf_register_java_exception() {
            super("register-java-exception", Lisp.PACKAGE_JAVA, true);
        }

        @Override
        public LispObject execute(LispObject className, LispObject symbol) {
            LispClass lispClass = (LispClass)LispClass.findClass(symbol, true);
            if (Java.isJavaException(lispClass)) {
                registeredExceptions.put(Java.classForName(className.getStringValue()), (Symbol)symbol);
                return Lisp.T;
            }
            return Lisp.NIL;
        }
    }

    @DocString(name="ensure-java-object", args="obj", doc="Ensures OBJ is wrapped in a JAVA-OBJECT, wrapping it if necessary.")
    private static final class pf_ensure_java_object
    extends Primitive {
        pf_ensure_java_object() {
            super("ensure-java-object", Lisp.PACKAGE_JAVA, true);
        }

        @Override
        public LispObject execute(LispObject obj) {
            return obj instanceof JavaObject ? obj : new JavaObject(obj);
        }
    }
}

