/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.metamata;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.LogOutputStream;
import org.apache.tools.ant.taskdefs.StreamPumper;
import org.apache.tools.ant.taskdefs.optional.metamata.MAudit;
import org.apache.tools.ant.taskdefs.optional.metamata.MAuditParser;
import org.apache.tools.ant.util.DOMElementWriter;
import org.apache.tools.ant.util.DateUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class MAuditStreamHandler
implements ExecuteStreamHandler {
    private MAudit task;
    private BufferedReader br;
    private OutputStream xmlOut = null;
    private OutputStream errStream;
    private Thread errThread;
    private Hashtable auditedFiles = new Hashtable();
    private Date program_start;

    MAuditStreamHandler(MAudit task, OutputStream xmlOut) {
        this.task = task;
        this.xmlOut = xmlOut;
    }

    public void setProcessInputStream(OutputStream os) {
    }

    public void setProcessErrorStream(InputStream is) {
        this.errStream = new LogOutputStream((Task)this.task, 0);
        this.errThread = this.createPump(is, this.errStream);
    }

    public void setProcessOutputStream(InputStream is) throws IOException {
        this.br = new BufferedReader(new InputStreamReader(is));
    }

    public void start() throws IOException {
        this.program_start = new Date();
        this.errThread.start();
        this.parseOutput(this.br);
    }

    public void stop() {
        try {
            this.errThread.join();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        try {
            this.errStream.flush();
        }
        catch (IOException e) {
            // empty catch block
        }
        Document doc = MAuditStreamHandler.getDocumentBuilder().newDocument();
        Element rootElement = doc.createElement("classes");
        Enumeration keys = this.auditedFiles.keys();
        Hashtable filemapping = this.task.getFileMapping();
        Date now = new Date();
        rootElement.setAttribute("snapshot_created", DateUtils.format((Date)now, (String)"yyyy-MM-dd'T'HH:mm:ss"));
        rootElement.setAttribute("elapsed_time", String.valueOf(now.getTime() - this.program_start.getTime()));
        rootElement.setAttribute("program_start", DateUtils.format((Date)now, (String)"yyyy-MM-dd'T'HH:mm:ss"));
        rootElement.setAttribute("audited", String.valueOf(filemapping.size()));
        rootElement.setAttribute("reported", String.valueOf(this.auditedFiles.size()));
        int errors = 0;
        while (keys.hasMoreElements()) {
            String filepath = (String)keys.nextElement();
            Vector v = (Vector)this.auditedFiles.get(filepath);
            String fullclassname = (String)filemapping.get(filepath);
            if (fullclassname == null) {
                this.task.getProject().log("Could not find class mapping for " + filepath, 1);
                continue;
            }
            int pos = fullclassname.lastIndexOf(46);
            String pkg = pos == -1 ? "" : fullclassname.substring(0, pos);
            String clazzname = pos == -1 ? fullclassname : fullclassname.substring(pos + 1);
            Element clazz = doc.createElement("class");
            clazz.setAttribute("package", pkg);
            clazz.setAttribute("name", clazzname);
            int violationCount = v.size();
            clazz.setAttribute("violations", String.valueOf(violationCount));
            errors += violationCount;
            for (int i = 0; i < violationCount; ++i) {
                MAuditParser.Violation violation = (MAuditParser.Violation)v.elementAt(i);
                Element error = doc.createElement("violation");
                error.setAttribute("line", violation.line);
                error.setAttribute("message", violation.error);
                clazz.appendChild(error);
            }
            rootElement.appendChild(clazz);
        }
        rootElement.setAttribute("violations", String.valueOf(errors));
        DOMElementWriter domWriter = new DOMElementWriter();
        try {
            domWriter.write(rootElement, this.xmlOut);
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }

    protected static DocumentBuilder getDocumentBuilder() {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (Exception exc) {
            throw new ExceptionInInitializerError(exc);
        }
    }

    protected Thread createPump(InputStream is, OutputStream os) {
        Thread result = new Thread((Runnable)new StreamPumper(is, os));
        result.setDaemon(true);
        return result;
    }

    protected void parseOutput(BufferedReader br) throws IOException {
        String line = null;
        MAuditParser parser = new MAuditParser();
        while ((line = br.readLine()) != null) {
            MAuditParser.Violation violation = parser.parseLine(line);
            if (violation != null) {
                this.addViolation(violation.file, violation);
                continue;
            }
            this.task.log(line, 2);
        }
    }

    private void addViolation(String file, MAuditParser.Violation entry) {
        Vector<MAuditParser.Violation> violations = (Vector<MAuditParser.Violation>)this.auditedFiles.get(file);
        if (violations == null) {
            violations = new Vector<MAuditParser.Violation>();
            this.auditedFiles.put(file, violations);
        }
        violations.addElement(entry);
    }
}

