/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common;

import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.solr.common.SolrCloseable;

public class SolrCloseableLatch {
    private final SolrCloseable closeable;
    private final CountDownLatch latch;

    public SolrCloseableLatch(int count, SolrCloseable closeable) {
        Objects.requireNonNull(closeable);
        this.closeable = closeable;
        this.latch = new CountDownLatch(count);
    }

    public void await() throws InterruptedException {
        this.await(Long.MAX_VALUE, TimeUnit.SECONDS);
    }

    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        for (timeout = unit.toMillis(timeout); timeout > 0L; timeout -= 100L) {
            if (this.latch.await(100L, TimeUnit.MILLISECONDS)) {
                return true;
            }
            if (!this.closeable.isClosed()) continue;
            throw new InterruptedException(this.closeable + " has been closed.");
        }
        return false;
    }

    public void countDown() {
        this.latch.countDown();
    }

    public long getCount() {
        return this.latch.getCount();
    }
}

