/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.apollo.util.list;

import java.util.ArrayList;
import org.apache.activemq.apollo.util.Comparators;
import org.apache.activemq.apollo.util.TreeMap;
import org.apache.activemq.apollo.util.list.SortedLinkedListNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortedLinkedList<T extends SortedLinkedListNode<T>> {
    protected final TreeMap<Long, T> index = new TreeMap(Comparators.LONG_COMPARATOR);
    T head;
    int size;

    public boolean isEmpty() {
        return this.head == null;
    }

    public void add(T node) {
        SortedLinkedListNode prev = null;
        if (this.head != null) {
            if (((SortedLinkedListNode)((SortedLinkedListNode)this.head).prev).getSequence() < ((SortedLinkedListNode)node).getSequence()) {
                prev = ((SortedLinkedListNode)this.head).prev;
            } else {
                TreeMap.TreeEntry<Long, T> entry = this.index.lowerEntry(((SortedLinkedListNode)node).getSequence());
                if (entry != null) {
                    prev = (SortedLinkedListNode)entry.getValue();
                }
            }
        }
        if (prev == null) {
            ((SortedLinkedListNode)node).linkToHead(this);
        } else {
            prev.linkAfter(node);
        }
    }

    public T get(long sequence) {
        return (T)((SortedLinkedListNode)this.index.get(sequence));
    }

    public T lower(long sequence, boolean inclusive) {
        TreeMap.TreeEntry<Long, T> lower = this.index.floorEntry(sequence);
        if (lower == null) {
            return null;
        }
        if (inclusive) {
            return (T)((SortedLinkedListNode)lower.getValue());
        }
        if ((Long)lower.getKey() == sequence) {
            return ((SortedLinkedListNode)lower.getValue()).prev;
        }
        return (T)((SortedLinkedListNode)lower.getValue());
    }

    public T upper(long sequence, boolean inclusive) {
        if (this.head == null || ((SortedLinkedListNode)((SortedLinkedListNode)this.head).prev).getSequence() < sequence) {
            return null;
        }
        TreeMap.TreeEntry<Long, T> upper = this.index.ceilingEntry(sequence);
        if (upper == null) {
            return null;
        }
        if (inclusive) {
            return (T)((SortedLinkedListNode)upper.getValue());
        }
        if ((Long)upper.getKey() == sequence) {
            return ((SortedLinkedListNode)upper.getValue()).next;
        }
        return (T)((SortedLinkedListNode)upper.getValue());
    }

    public void remove(T node) {
        if (((SortedLinkedListNode)node).list == this) {
            ((SortedLinkedListNode)node).unlink();
        }
    }

    public T getHead() {
        return this.head;
    }

    public T getTail() {
        return ((SortedLinkedListNode)this.head).prev;
    }

    public void clear() {
        while (this.head != null) {
            ((SortedLinkedListNode)this.head).unlink();
        }
        this.index.clear();
    }

    public int size() {
        return this.size;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        boolean first = true;
        for (T cur = this.getHead(); cur != null; cur = ((SortedLinkedListNode)cur).getNext()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append(cur);
            first = false;
        }
        sb.append("]");
        return sb.toString();
    }

    public ArrayList<T> toArrayList() {
        ArrayList<T> rc = new ArrayList<T>(this.size);
        for (T cur = this.head; cur != null; cur = ((SortedLinkedListNode)cur).getNext()) {
            rc.add(cur);
        }
        return rc;
    }
}

