/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.dockbar.event;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.SwingUtilities;
import org.flexdock.dockbar.DockbarManager;
import org.flexdock.dockbar.ViewPane;
import org.flexdock.dockbar.event.ActivationListener;
import org.flexdock.docking.DockingConstants;
import org.flexdock.util.SwingUtility;

public class DockbarTracker
implements DockingConstants,
PropertyChangeListener,
AWTEventListener {
    public static void register() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                DockbarTracker tracker = new DockbarTracker();
                KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                focusManager.addPropertyChangeListener(tracker);
                long evtType = 48L;
                Toolkit.getDefaultToolkit().addAWTEventListener(tracker, evtType);
            }
        });
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("activeWindow".equals(evt.getPropertyName())) {
            Component newWindow = SwingUtility.toComponent(evt.getNewValue());
            DockbarManager.windowChanged(newWindow);
        }
    }

    public void eventDispatched(AWTEvent event) {
        ActivationListener listener;
        int evtType = event.getID();
        if (evtType != 503 && evtType != 501) {
            return;
        }
        DockbarManager mgr = DockbarManager.getCurrent();
        ActivationListener activationListener = listener = mgr == null ? null : mgr.getActivationListener();
        if (listener == null || !listener.isAvailable()) {
            return;
        }
        MouseEvent evt = (MouseEvent)event;
        Point p = SwingUtilities.convertPoint((Component)evt.getSource(), evt.getPoint(), mgr.getViewPane().getParent());
        ViewPane viewPane = mgr.getViewPane();
        boolean mouseOver = viewPane.getBounds().contains(p);
        if (evtType == 501) {
            listener.mousePressed(p, mouseOver);
        } else {
            this.handleMouseMove(listener, p, mouseOver);
        }
    }

    private void handleMouseMove(ActivationListener listener, Point mousePoint, boolean mouseOver) {
        if (mouseOver) {
            if (!listener.isMouseOver()) {
                listener.mouseEntered(mousePoint);
            }
        } else if (listener.isMouseOver()) {
            listener.mouseExited(mousePoint);
        }
    }
}

