/*
 * Decompiled with CFR 0.152.
 */
package free.util;

import free.util.IOUtilities;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;

public abstract class ChildClassLoader
extends ClassLoader {
    private final ChildClassLoader parent;
    private final Hashtable namesToClasses = new Hashtable();

    public ChildClassLoader(ChildClassLoader childClassLoader) {
        this.parent = childClassLoader;
    }

    public ChildClassLoader() {
        this(null);
    }

    public ChildClassLoader getParentClassLoader() {
        return this.parent;
    }

    public final synchronized Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class clazz = (Class)this.namesToClasses.get(string);
        if (clazz != null) {
            return clazz;
        }
        clazz = this.loadClassImpl(string, bl);
        if (clazz == null) {
            if (this.parent == null) {
                throw new ClassNotFoundException(string);
            }
            clazz = this.parent.loadClass(string, bl);
        }
        this.namesToClasses.put(string, clazz);
        return clazz;
    }

    public final InputStream getResourceAsStream(String string) {
        InputStream inputStream = this.getResourceAsStreamImpl(string);
        return inputStream != null ? inputStream : (this.parent == null ? null : this.parent.getResourceAsStream(string));
    }

    public final URL getResource(String string) {
        URL uRL = this.getResourceImpl(string);
        return uRL != null ? uRL : (this.parent == null ? null : this.parent.getResource(string));
    }

    protected byte[] loadClassData(String string) throws IOException {
        String string2 = string.replace('.', '/') + ".class";
        InputStream inputStream = this.getResourceAsStreamImpl(string2);
        if (inputStream == null) {
            return null;
        }
        return IOUtilities.readToEnd(inputStream);
    }

    protected Class loadClassImpl(String string, boolean bl) {
        try {
            Class<?> clazz = null;
            try {
                clazz = this.findSystemClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (clazz == null) {
                byte[] byArray = this.loadClassData(string);
                if (byArray == null) {
                    return null;
                }
                clazz = this.defineClass(string, byArray, 0, byArray.length);
            }
            if (bl) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    protected abstract InputStream getResourceAsStreamImpl(String var1);

    protected abstract URL getResourceImpl(String var1);
}

