/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.VTM.glyphs;

import com.xerox.VTM.engine.Camera;
import com.xerox.VTM.glyphs.ClosedShape;
import com.xerox.VTM.glyphs.RectangularShape;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import net.claribole.zvtm.glyphs.projection.ProjEllipse;

public class VEllipse
extends ClosedShape
implements RectangularShape {
    long vw;
    long vh;
    float ar;
    ProjEllipse[] pc;

    public VEllipse() {
        this.vx = 0L;
        this.vy = 0L;
        this.vz = 0;
        this.vw = 10L;
        this.vh = 10L;
        this.setColor(Color.white);
        this.setBorderColor(Color.black);
        this.computeSize();
    }

    public VEllipse(long x, long y, int z, long sx, long sy, Color c) {
        this.vx = x;
        this.vy = y;
        this.vz = z;
        this.vw = sx;
        this.vh = sy;
        this.orient = 0.0f;
        this.setColor(c);
        this.setBorderColor(Color.black);
        this.computeSize();
    }

    public VEllipse(long x, long y, int z, long sx, long sy, Color c, Color bc) {
        this.vx = x;
        this.vy = y;
        this.vz = z;
        this.vw = sx;
        this.vh = sy;
        this.orient = 0.0f;
        this.setColor(c);
        this.setBorderColor(bc);
        this.computeSize();
    }

    public void initCams(int nbCam) {
        this.pc = new ProjEllipse[nbCam];
        for (int i = 0; i < nbCam; ++i) {
            this.pc[i] = new ProjEllipse();
        }
    }

    public void addCamera(int verifIndex) {
        if (this.pc != null) {
            if (verifIndex == this.pc.length) {
                ProjEllipse[] ta = this.pc;
                this.pc = new ProjEllipse[ta.length + 1];
                for (int i = 0; i < ta.length; ++i) {
                    this.pc[i] = ta[i];
                }
                this.pc[this.pc.length - 1] = new ProjEllipse();
            } else {
                System.err.println("VEllipse:Error while adding camera " + verifIndex);
            }
        } else if (verifIndex == 0) {
            this.pc = new ProjEllipse[1];
            this.pc[0] = new ProjEllipse();
        } else {
            System.err.println("VEllipse:Error while adding camera " + verifIndex);
        }
    }

    public void removeCamera(int index) {
        this.pc[index] = null;
    }

    public void resetMouseIn() {
        for (int i = 0; i < this.pc.length; ++i) {
            this.resetMouseIn(i);
        }
    }

    public void resetMouseIn(int i) {
        if (this.pc[i] != null) {
            this.pc[i].prevMouseIn = false;
        }
        this.borderColor = this.bColor;
    }

    public float getOrient() {
        return 0.0f;
    }

    public void orientTo(float angle) {
    }

    void computeSize() {
        this.size = Math.max(this.vw, this.vh);
        this.ar = (float)this.vw / (float)this.vh;
    }

    public float getSize() {
        return this.size;
    }

    public void sizeTo(float radius) {
        this.size = radius;
        if (this.vw >= this.vh) {
            this.vw = (long)this.size;
            this.vh = (long)((float)this.vw / this.ar);
        } else {
            this.vh = (long)this.size;
            this.vw = (long)((float)this.vh * this.ar);
        }
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void setWidth(long w) {
        this.vw = w;
        this.computeSize();
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void setHeight(long h) {
        this.vh = h;
        this.computeSize();
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public long getWidth() {
        return this.vw;
    }

    public long getHeight() {
        return this.vh;
    }

    public void reSize(float factor) {
        this.size *= factor;
        if (this.vw >= this.vh) {
            this.vw = (long)this.size;
            this.vh = (long)((float)this.vw / this.ar);
        } else {
            this.vh = (long)this.size;
            this.vw = (long)((float)this.vh * this.ar);
        }
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public long[] getBounds() {
        long[] res = new long[]{this.vx - this.vw, this.vy + this.vh, this.vx + this.vw, this.vy - this.vh};
        return res;
    }

    public boolean fillsView(long w, long h, int camIndex) {
        return false;
    }

    public boolean coordInside(int jpx, int jpy, int camIndex, long cvx, long cvy) {
        return this.pc[camIndex].ellipse.contains(jpx, jpy);
    }

    public boolean visibleInDisc(long dvx, long dvy, long dvr, Shape dvs, int camIndex, int jpx, int jpy, int dpr) {
        return this.pc[camIndex].ellipse.intersects(jpx - dpr, jpy - dpr, 2 * dpr, 2 * dpr);
    }

    public short mouseInOut(int jpx, int jpy, int camIndex, long cvx, long cvy) {
        if (this.coordInside(jpx, jpy, camIndex, cvx, cvy)) {
            if (!this.pc[camIndex].prevMouseIn) {
                this.pc[camIndex].prevMouseIn = true;
                return 1;
            }
            return 0;
        }
        if (this.pc[camIndex].prevMouseIn) {
            this.pc[camIndex].prevMouseIn = false;
            return -1;
        }
        return 0;
    }

    public void project(Camera c, Dimension d) {
        int i = c.getIndex();
        this.coef = c.focal / (c.focal + c.altitude);
        this.pc[i].cx = d.width / 2 + Math.round((float)(this.vx - c.posx) * this.coef);
        this.pc[i].cy = d.height / 2 - Math.round((float)(this.vy - c.posy) * this.coef);
        this.pc[i].cvw = (float)this.vw * this.coef;
        this.pc[i].cvh = (float)this.vh * this.coef;
        this.pc[i].ellipse.setFrame((float)this.pc[i].cx - (float)this.vw * this.coef, (float)this.pc[i].cy - (float)this.vh * this.coef, 2.0f * this.pc[i].cvw, 2.0f * this.pc[i].cvh);
    }

    public void projectForLens(Camera c, int lensWidth, int lensHeight, float lensMag, long lensx, long lensy) {
        int i = c.getIndex();
        this.coef = c.focal / (c.focal + c.altitude) * lensMag;
        this.pc[i].lcx = lensWidth / 2 + Math.round((float)(this.vx - lensx) * this.coef);
        this.pc[i].lcy = lensHeight / 2 - Math.round((float)(this.vy - lensy) * this.coef);
        this.pc[i].lcvw = (float)this.vw * this.coef;
        this.pc[i].lcvh = (float)this.vh * this.coef;
        this.pc[i].lellipse.setFrame((float)this.pc[i].lcx - (float)this.vw * this.coef, (float)this.pc[i].lcy - (float)this.vh * this.coef, 2.0f * this.pc[i].lcvw, 2.0f * this.pc[i].lcvh);
    }

    public void draw(Graphics2D g, int vW, int vH, int i, Stroke stdS, AffineTransform stdT, int dx, int dy) {
        if (this.pc[i].ellipse.getBounds().width > 2 && this.pc[i].ellipse.getBounds().height > 2) {
            if (this.filled) {
                g.setColor(this.color);
                g.translate(dx, dy);
                g.fill(this.pc[i].ellipse);
                g.translate(-dx, -dy);
            }
            if (this.paintBorder) {
                g.setColor(this.borderColor);
                if (this.stroke != null) {
                    g.setStroke(this.stroke);
                    g.translate(dx, dy);
                    g.draw(this.pc[i].ellipse);
                    g.translate(-dx, -dy);
                    g.setStroke(stdS);
                } else {
                    g.translate(dx, dy);
                    g.draw(this.pc[i].ellipse);
                    g.translate(-dx, -dy);
                }
            }
        } else {
            g.setColor(this.color);
            g.fillRect(dx + this.pc[i].cx, dy + this.pc[i].cy, 1, 1);
        }
    }

    public void drawForLens(Graphics2D g, int vW, int vH, int i, Stroke stdS, AffineTransform stdT, int dx, int dy) {
        if (this.pc[i].lellipse.getBounds().width > 2 && this.pc[i].lellipse.getBounds().height > 2) {
            if (this.filled) {
                g.setColor(this.color);
                g.translate(dx, dy);
                g.fill(this.pc[i].lellipse);
                g.translate(-dx, -dy);
            }
            if (this.paintBorder) {
                g.setColor(this.borderColor);
                if (this.stroke != null) {
                    g.setStroke(this.stroke);
                    g.translate(dx, dy);
                    g.draw(this.pc[i].lellipse);
                    g.translate(-dx, -dy);
                    g.setStroke(stdS);
                } else {
                    g.translate(dx, dy);
                    g.draw(this.pc[i].lellipse);
                    g.translate(-dx, -dy);
                }
            }
        } else {
            g.setColor(this.color);
            g.fillRect(dx + this.pc[i].lcx, dy + this.pc[i].lcy, 1, 1);
        }
    }

    public Object clone() {
        VEllipse res = new VEllipse(this.vx, this.vy, 0, this.vw, this.vh, this.color);
        res.borderColor = this.borderColor;
        res.mouseInsideColor = this.mouseInsideColor;
        res.bColor = this.bColor;
        return res;
    }
}

