require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&HEADER_DSA_H)) {
    eval 'sub HEADER_DSA_H () {1;}' unless defined(&HEADER_DSA_H);
    require 'openssl/opensslconf.ph';
    unless(defined(&OPENSSL_NO_DSA)) {
	if(defined(&__cplusplus)) {
	}
	require 'openssl/e_os2.ph';
	require 'openssl/bio.ph';
	require 'openssl/crypto.ph';
	require 'openssl/ossl_typ.ph';
	require 'openssl/bn.ph';
	if((defined(&OPENSSL_API_COMPAT) ? &OPENSSL_API_COMPAT : undef) < 0x10100000) {
	    require 'openssl/dh.ph';
	}
	require 'openssl/dsaerr.ph';
	unless(defined(&OPENSSL_DSA_MAX_MODULUS_BITS)) {
	    eval 'sub OPENSSL_DSA_MAX_MODULUS_BITS () {10000;}' unless defined(&OPENSSL_DSA_MAX_MODULUS_BITS);
	}
	eval 'sub OPENSSL_DSA_FIPS_MIN_MODULUS_BITS () {1024;}' unless defined(&OPENSSL_DSA_FIPS_MIN_MODULUS_BITS);
	eval 'sub DSA_FLAG_CACHE_MONT_P () {0x1;}' unless defined(&DSA_FLAG_CACHE_MONT_P);
	if((defined(&OPENSSL_API_COMPAT) ? &OPENSSL_API_COMPAT : undef) < 0x10100000) {
	    eval 'sub DSA_FLAG_NO_EXP_CONSTTIME () {0x;}' unless defined(&DSA_FLAG_NO_EXP_CONSTTIME);
	}
	eval 'sub DSA_FLAG_FIPS_METHOD () {0x400;}' unless defined(&DSA_FLAG_FIPS_METHOD);
	eval 'sub DSA_FLAG_NON_FIPS_ALLOW () {0x400;}' unless defined(&DSA_FLAG_NON_FIPS_ALLOW);
	eval 'sub DSA_FLAG_FIPS_CHECKED () {0x800;}' unless defined(&DSA_FLAG_FIPS_CHECKED);
	eval 'sub d2i_DSAparams_fp {
	    my($fp,$x) = @_;
    	    eval q(( &DSA *) &ASN1_d2i_fp((\'char\' *(*)()) &DSA_new, (\'char\' *(*)()) &d2i_DSAparams,,($x)));
	}' unless defined(&d2i_DSAparams_fp);
	eval 'sub i2d_DSAparams_fp {
	    my($fp,$x) = @_;
    	    eval q( &ASN1_i2d_fp( &i2d_DSAparams,, ($x)));
	}' unless defined(&i2d_DSAparams_fp);
	eval 'sub d2i_DSAparams_bio {
	    my($bp,$x) = @_;
    	    eval q( &ASN1_d2i_bio_of( &DSA, &DSA_new, &d2i_DSAparams,$bp,$x));
	}' unless defined(&d2i_DSAparams_bio);
	eval 'sub i2d_DSAparams_bio {
	    my($bp,$x) = @_;
    	    eval q( &ASN1_i2d_bio_of_const( &DSA, &i2d_DSAparams,$bp,$x));
	}' unless defined(&i2d_DSAparams_bio);
	eval 'sub DSA_get_ex_new_index {
	    my($l, $p, $newf, $dupf, $freef) = @_;
    	    eval q( &CRYPTO_get_ex_new_index( &CRYPTO_EX_INDEX_DSA, $l, $p, $newf, $dupf, $freef));
	}' unless defined(&DSA_get_ex_new_index);
	unless(defined(&OPENSSL_NO_STDIO)) {
	}
	eval 'sub DSS_prime_checks () {64;}' unless defined(&DSS_prime_checks);
	eval 'sub DSA_is_prime {
	    my($n, $callback, $cb_arg) = @_;
    	    eval q( &BN_is_prime($n,  &DSS_prime_checks, $callback,  &NULL, $cb_arg));
	}' unless defined(&DSA_is_prime);
	unless(defined(&OPENSSL_NO_DH)) {
	}
	eval 'sub EVP_PKEY_CTX_set_dsa_paramgen_bits {
	    my($ctx, $nbits) = @_;
    	    eval q( &EVP_PKEY_CTX_ctrl($ctx,  &EVP_PKEY_DSA,  &EVP_PKEY_OP_PARAMGEN,  &EVP_PKEY_CTRL_DSA_PARAMGEN_BITS, $nbits,  &NULL));
	}' unless defined(&EVP_PKEY_CTX_set_dsa_paramgen_bits);
	eval 'sub EVP_PKEY_CTX_set_dsa_paramgen_q_bits {
	    my($ctx, $qbits) = @_;
    	    eval q( &EVP_PKEY_CTX_ctrl($ctx,  &EVP_PKEY_DSA,  &EVP_PKEY_OP_PARAMGEN,  &EVP_PKEY_CTRL_DSA_PARAMGEN_Q_BITS, $qbits,  &NULL));
	}' unless defined(&EVP_PKEY_CTX_set_dsa_paramgen_q_bits);
	eval 'sub EVP_PKEY_CTX_set_dsa_paramgen_md {
	    my($ctx, $md) = @_;
    	    eval q( &EVP_PKEY_CTX_ctrl($ctx,  &EVP_PKEY_DSA,  &EVP_PKEY_OP_PARAMGEN,  &EVP_PKEY_CTRL_DSA_PARAMGEN_MD, 0, ( &void *)($md)));
	}' unless defined(&EVP_PKEY_CTX_set_dsa_paramgen_md);
	eval 'sub EVP_PKEY_CTRL_DSA_PARAMGEN_BITS () {( &EVP_PKEY_ALG_CTRL + 1);}' unless defined(&EVP_PKEY_CTRL_DSA_PARAMGEN_BITS);
	eval 'sub EVP_PKEY_CTRL_DSA_PARAMGEN_Q_BITS () {( &EVP_PKEY_ALG_CTRL + 2);}' unless defined(&EVP_PKEY_CTRL_DSA_PARAMGEN_Q_BITS);
	eval 'sub EVP_PKEY_CTRL_DSA_PARAMGEN_MD () {( &EVP_PKEY_ALG_CTRL + 3);}' unless defined(&EVP_PKEY_CTRL_DSA_PARAMGEN_MD);
	if(defined(&__cplusplus)) {
	}
    }
}
1;
