/*
 * This file is part of the TYPO3 CMS project.
 *
 * It is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, either version 2
 * of the License, or any later version.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * The TYPO3 project - inspiring people to share!
 */
import{LitElement as b,html as d,nothing as p}from"lit";import{property as w,state as N,query as P}from"lit/decorators.js";import{repeat as C}from"lit/directives/repeat.js";import{styleMap as v}from"lit/directives/style-map.js";import{ifDefined as y}from"lit/directives/if-defined.js";import{TreeNodePositionEnum as g,TreeNodeCommandEnum as h}from"@typo3/backend/tree/tree-node.js";import E from"@typo3/core/ajax/ajax-request.js";import I from"@typo3/backend/notification.js";import{KeyTypesEnum as l}from"@typo3/backend/enum/key-types.js";import"@typo3/backend/element/icon-element.js";import T from"@typo3/backend/storage/client.js";import{DataTransferTypes as m}from"@typo3/backend/enum/data-transfer-types.js";import S from"@typo3/backend/severity.js";var f=function(_,e,t,s){var r=arguments.length,i=r<3?e:s===null?s=Object.getOwnPropertyDescriptor(e,t):s,o;if(typeof Reflect=="object"&&typeof Reflect.decorate=="function")i=Reflect.decorate(_,e,t,s);else for(var n=_.length-1;n>=0;n--)(o=_[n])&&(i=(r<3?o(i):r>3?o(e,t,i):o(e,t))||i);return r>3&&i&&Object.defineProperty(e,t,i),i};class c extends b{constructor(){super(...arguments),this.setup=null,this.settings={showIcons:!1,width:300,dataUrl:"",filterUrl:"",defaultProperties:{},expandUpToLevel:null,actions:[]},this.nodes=[],this.currentScrollPosition=0,this.currentVisibleHeight=0,this.searchTerm=null,this.loading=!1,this.hoveredNode=null,this.nodeDragAllowed=!1,this.isOverRoot=!1,this.nodeDragPosition=null,this.nodeDragMode=null,this.draggingNode=null,this.nodeHeight=32,this.indentWidth=20,this.displayNodes=[],this.focusedNode=null,this.lastFocusedNode=null,this.editingNode=null,this.openNodeTimeout={targetNode:null,timeout:null},this.unfilteredNodes="",this.muteErrorNotifications=!1,this.networkErrorTitle=top.TYPO3.lang.tree_networkError,this.networkErrorMessage=top.TYPO3.lang.tree_networkErrorDescription,this.allowNodeEdit=!1,this.allowNodeDrag=!1,this.allowNodeSorting=!1,this.currentFilterRequest=null,this.__loadPromise=new Promise(e=>this.__loadFinished=e)}get loadComplete(){return this.__loadPromise}getNodeFromElement(e){return e===null||!("treeId"in e.dataset)?null:this.getNodeByTreeIdentifier(e.dataset.treeId)}getElementFromNode(e){return this.querySelector('[data-tree-id="'+this.getNodeTreeIdentifier(e)+'"]')}hideChildren(e){e.__expanded=!1,this.saveNodeStatus(e),this.dispatchEvent(new CustomEvent("typo3:tree:expand-toggle",{detail:{node:e}}))}async showChildren(e){e.__expanded=!0,await this.loadChildren(e),this.saveNodeStatus(e),this.dispatchEvent(new CustomEvent("typo3:tree:expand-toggle",{detail:{node:e}}))}getDataUrl(e=null){return e===null?this.settings.dataUrl:this.settings.dataUrl+"&parent="+e.identifier+"&depth="+e.depth}getFilterUrl(){return this.settings.filterUrl+"&q="+this.searchTerm}async loadData(){this.loading=!0,this.nodes=this.prepareNodes(await this.fetchData()),this.__loadFinished(),this.__loadPromise=new Promise(e=>this.__loadFinished=e),this.loading=!1}async fetchData(e=null){try{let s=await(await new E(this.getDataUrl(e)).get({cache:"no-cache"})).resolve();return Array.isArray(s)?(e!==null&&(s=s.filter(i=>i.identifier!==e.identifier),s.unshift(e)),s=this.enhanceNodes(s),e!==null&&s.shift(),(await Promise.all(s.map(async i=>{const o=i.__parents.join("_"),n=s.find(u=>u.__treeIdentifier===o)||null,a=n===null||n.__expanded;if(!i.loaded&&i.hasChildren&&i.__expanded&&a){const u=await this.fetchData(i);return i.loaded=!0,[i,...u]}else return[i]}))).flat()):[]}catch(t){return this.errorNotification(t),[]}}async loadChildren(e){try{if(e.loaded){await Promise.all(this.nodes.filter(i=>i.__parents.join("_")===e.__treeIdentifier&&!i.loaded&&i.hasChildren&&i.__expanded).map(i=>this.loadChildren(i)));return}e.__loading=!0;const t=this.prepareNodes(await this.fetchData(e)),s=this.nodes.indexOf(e)+1;let r=0;for(let i=s;i<this.nodes.length&&!(this.nodes[i].depth<=e.depth);++i)r++;this.nodes.splice(s,r,...t),e.__loading=!1,e.loaded=!0}catch(t){throw this.errorNotification(t),e.__loading=!1,t}}getIdentifier(){return this.id??this.setup.id}getLocalStorageIdentifier(){return"tree-state-"+this.getIdentifier()}getNodeStatus(e){return(JSON.parse(T.get(this.getLocalStorageIdentifier()))??{})[e.__treeIdentifier]??{expanded:!1}}saveNodeStatus(e){const t=JSON.parse(T.get(this.getLocalStorageIdentifier()))??{};t[e.__treeIdentifier]={expanded:e.__expanded},T.set(this.getLocalStorageIdentifier(),JSON.stringify(t))}refreshOrFilterTree(){this.searchTerm!==""?this.filter(this.searchTerm):this.loadData()}selectFirstNode(){const e=this.getFirstNode();this.selectNode(e,!0),this.focusNode(e)}selectNode(e,t=!0){this.isNodeSelectable(e)&&(this.resetSelectedNodes(),e.checked=!0,this.dispatchEvent(new CustomEvent("typo3:tree:node-selected",{detail:{node:e,propagate:t}})))}async focusNode(e){this.lastFocusedNode=this.focusedNode,this.focusedNode=e,this.requestUpdate();const t=this.getElementFromNode(this.focusedNode);t?t.focus():this.updateComplete.then(()=>{this.getElementFromNode(this.focusedNode)?.focus()})}async editNode(e){this.isNodeEditable(e)&&(this.editingNode=e,this.requestUpdate(),this.updateComplete.then(()=>{const t=this.getElementFromNode(this.editingNode)?.querySelector(".node-edit");t&&(t.focus(),t.select())}))}async deleteNode(e){if(!e.deletable){console.error("The Node cannot be deleted.");return}this.handleNodeDelete(e)}async moveNode(e,t,s){this.handleNodeMove(e,t,s)}async addNode(e,t,s){let r=this.nodes.indexOf(t);const i=s===g.INSIDE?t:this.getParentNode(t),o=this.enhanceNodes([i,{...e,depth:i?i.depth+1:0}]).pop();i&&(i.hasChildren&&!i.__expanded&&await this.showChildren(i),i.hasChildren||(i.hasChildren=!0,i.__expanded=!0)),(s===g.INSIDE||s===g.AFTER)&&r++,this.nodes.splice(r,0,o),this.handleNodeAdd(o,t,s)}async removeNode(e){const t=this.nodes.indexOf(e),s=this.getParentNode(e);t>-1&&this.nodes.splice(t,1),this.requestUpdate(),this.updateComplete.then(()=>{s.__expanded&&s.hasChildren&&this.getNodeChildren(s).length===0&&(s.hasChildren=!1,s.__expanded=!1)})}filter(e){typeof e=="string"&&(this.searchTerm=e),this.searchTerm&&this.settings.filterUrl?(this.loading=!0,this.currentFilterRequest?.abort(),this.currentFilterRequest=new E(this.getFilterUrl()),this.currentFilterRequest.get({cache:"no-cache"}).then(t=>t.resolve()).then(t=>{const s=Array.isArray(t)?t:[];s.length>0&&(this.unfilteredNodes===""&&(this.unfilteredNodes=JSON.stringify(this.nodes)),this.nodes=this.enhanceNodes(s))}).catch(t=>{if(!(t instanceof DOMException&&t.name==="AbortError"))throw this.errorNotification(t),t}).then(()=>{this.loading=!1,this.currentFilterRequest=null})):(this.resetFilter(),this.loading=!1)}resetFilter(){if(this.searchTerm="",this.unfilteredNodes.length>0){const e=this.getSelectedNodes()[0];if(typeof e>"u"){this.loadData();return}this.nodes=this.enhanceNodes(JSON.parse(this.unfilteredNodes)),this.unfilteredNodes="";const t=this.getNodeByTreeIdentifier(e.__treeIdentifier);t?this.selectNode(t,!1):this.loadData()}else this.loadData()}errorNotification(e=null){if(!this.muteErrorNotifications)if(Array.isArray(e))e.forEach(t=>{I.error(t.title,t.message)});else{let t=this.networkErrorTitle;e&&e.target&&(e.target.status||e.target.statusText)&&(t+=" - "+(e.target.status||"")+" "+(e.target.statusText||"")),I.error(t,this.networkErrorMessage)}}getSelectedNodes(){return this.nodes.filter(e=>e.checked)}getNodeByTreeIdentifier(e){return this.nodes.find(t=>t.__treeIdentifier===e)}getNodeDragStatusIcon(){return this.nodeDragMode===h.DELETE?"actions-delete":this.nodeDragMode===h.NEW?"actions-add":this.nodeDragPosition===g.BEFORE?"apps-pagetree-drag-move-above":this.nodeDragPosition===g.INSIDE?"apps-pagetree-drag-move-into":this.nodeDragPosition===g.AFTER?"apps-pagetree-drag-move-below":"actions-ban"}async expandParents(e){for(const t of e){const s=this.nodes.find(r=>r.identifier===t.toString());if(!s)return;s.__expanded||await this.showChildren(s)}}async expandNodeParents(e){await this.expandParents(e.__parents)}prepareNodes(e){const t=new CustomEvent("typo3:tree:nodes-prepared",{detail:{nodes:e},bubbles:!1});return this.dispatchEvent(t),t.detail.nodes}enhanceNodes(e){const t=e.reduce((r,i)=>{if(i.__processed===!0)return[...r,i];i=Object.assign({},this.settings.defaultProperties,i),i.__parents=[];const o=i.depth>0?r.findLast(a=>a.depth<i.depth):null;o&&(i.__parents=[...o.__parents,o.identifier]),i.__treeIdentifier=i.identifier,i.__loading=!1,i.__treeParents=[],o&&(i.__treeIdentifier=o.__treeIdentifier+"_"+i.__treeIdentifier,i.__treeParents=[...o.__treeParents,o.__treeIdentifier]),this.searchTerm?i.__expanded=i.loaded&&i.hasChildren:i.hasChildren?i.__expanded=this.settings.expandUpToLevel!==null?i.depth<this.settings.expandUpToLevel:!!this.getNodeStatus(i).expanded:i.__expanded=!1,i.__processed=!0;const n=this;return[...r,new Proxy(i,{set(a,u,D){return a[u]!==D&&(a[u]=D,n.requestUpdate()),!0}})]},[]);return t.filter(r=>r.depth===0).length===1&&(t[0].__expanded=!0),t}createRenderRoot(){return this}render(){const e=this.loading?d`<div class=nodes-loader><div class=nodes-loader-inner><typo3-backend-icon identifier=spinner-circle size=medium></typo3-backend-icon></div></div>`:p;return d`<div class=nodes-container>${e}<div class=nodes-root @scroll=${t=>{this.currentScrollPosition=t.currentTarget.scrollTop}} @mouseover=${()=>this.isOverRoot=!0} @mouseout=${()=>this.isOverRoot=!1} @keydown=${t=>this.handleKeyboardInteraction(t)}>${this.renderVisibleNodes()}</div></div>`}renderVisibleNodes(){const e=[];this.nodes.forEach(i=>{i.__expanded===!1&&e.push(this.getNodeTreeIdentifier(i))}),this.displayNodes=this.nodes.filter(i=>i.__hidden!==!0&&!i.__treeParents.some(o=>e.indexOf(o)!==-1)),this.displayNodes.forEach((i,o)=>{i.__x=i.depth*this.indentWidth,i.__y=o*this.nodeHeight});const t=Math.ceil(this.currentVisibleHeight/this.nodeHeight),s=Math.floor(this.currentScrollPosition/this.nodeHeight),r=this.displayNodes.filter((i,o)=>this.getFirstNode()===i||this.focusedNode===i||this.lastFocusedNode===i?!0:o+2>=s&&o-2<s+t);return d`<div class=nodes-list role=tree style=${v({height:this.displayNodes.length*this.nodeHeight+"px"})}>${C(r,i=>this.getNodeTreeIdentifier(i),i=>d`<div class=${this.getNodeClasses(i).join(" ")} role=treeitem draggable=true title=${this.getNodeTitle(i)} aria-owns=${y(i.hasChildren?"group-identifier-"+this.getNodeIdentifier(i):null)} aria-expanded=${y(i.hasChildren?i.__expanded?"1":"0":null)} aria-level=${this.getNodeDepth(i)+1} aria-setsize=${this.getNodeSetsize(i)} aria-posinset=${this.getNodePositionInSet(i)} data-id=${this.getNodeIdentifier(i)} data-tree-id=${this.getNodeTreeIdentifier(i)} style=top:${i.__y+"px"};height:${this.nodeHeight+"px"} tabindex=${this.getNodeTabindex(i)} @dragover=${o=>{this.handleNodeDragOver(o)}} @dragstart=${o=>{this.handleNodeDragStart(o,i)}} @dragleave=${o=>{this.handleNodeDragLeave(o)}} @dragend=${o=>{this.handleNodeDragEnd(o)}} @drop=${o=>{this.handleNodeDrop(o)}} @click=${o=>{this.handleNodeClick(o,i)}} @dblclick=${o=>{this.handleNodeDoubleClick(o,i)}} @focusin=${()=>{this.focusedNode=i}} @focusout=${()=>{this.focusedNode===i&&(this.lastFocusedNode=i,this.focusedNode=null)}} @contextmenu=${o=>{o.preventDefault(),o.stopPropagation(),this.dispatchEvent(new CustomEvent("typo3:tree:node-context",{detail:{node:i,originalEvent:o}}))}}>${this.createNodeLabel(i)} ${this.createNodeGuides(i)} ${this.createNodeLoader(i)||this.createNodeToggle(i)||p} ${this.createNodeContent(i)} ${this.createNodeStatusInformation(i)} ${this.createNodeDeleteDropZone(i)}</div>`)}</div>`}async firstUpdated(){new ResizeObserver(t=>{for(const s of t)s.target===this.root&&(this.currentVisibleHeight=s.target.getBoundingClientRect().height)}).observe(this.root),Object.assign(this.settings,this.setup||{}),this.registerUnloadHandler(),await this.loadData(),this.dispatchEvent(new Event("tree:initialized"))}resetSelectedNodes(){this.getSelectedNodes().forEach(e=>{e.checked===!0&&(e.checked=!1)})}isNodeSelectable(e){return!0}isNodeEditable(e){return e.editable&&this.allowNodeEdit}handleNodeClick(e,t){e.detail===1&&(e.preventDefault(),e.stopPropagation(),this.editingNode!==t&&this.selectNode(t,!0))}handleNodeDoubleClick(e,t){e.preventDefault(),e.stopPropagation(),this.editingNode!==t&&this.editNode(t)}cleanDrag(){this.querySelectorAll(".node").forEach(function(t){t.classList.remove("node-dragging-before"),t.classList.remove("node-dragging-after"),t.classList.remove("node-hover")})}getNodeFromDragEvent(e){const t=e.target;return this.getNodeFromElement(t.closest("[data-tree-id]"))}getTooltipDescription(e){return"ID: "+e.identifier}handleNodeDragStart(e,t){if(this.allowNodeDrag===!1||t.depth===0){e.preventDefault();return}this.draggingNode=t,this.requestUpdate(),e.dataTransfer.clearData();const s={statusIconIdentifier:this.getNodeDragStatusIcon(),tooltipIconIdentifier:t.icon,tooltipLabel:t.name,tooltipDescription:this.getTooltipDescription(t)};e.dataTransfer.setData(m.dragTooltip,JSON.stringify(s)),this.createDataTransferItemsFromNode(t).forEach(({data:r,type:i})=>e.dataTransfer.items.add(r,i)),e.dataTransfer.effectAllowed="move"}handleNodeDragOver(e){if(!e.dataTransfer.types.includes(m.treenode)&&!e.dataTransfer.types.includes(m.newTreenode))return!1;const t=e.target,s=this.getNodeFromDragEvent(e);if(s===null||this.draggingNode===null)return!1;this.cleanDrag(),this.refreshDragToolTip(),this.nodeDragMode=null,this.nodeDragPosition=null;const r=this.getElementFromNode(s);if(r.classList.add("node-hover"),s.hasChildren&&!s.__expanded?this.openNodeTimeout.targetNode!=s&&(this.openNodeTimeout.targetNode=s,clearTimeout(this.openNodeTimeout.timeout),this.openNodeTimeout.timeout=setTimeout(()=>{this.showChildren(this.openNodeTimeout.targetNode),this.openNodeTimeout.targetNode=null,this.openNodeTimeout.timeout=null},1e3)):(clearTimeout(this.openNodeTimeout.timeout),this.openNodeTimeout.targetNode=null,this.openNodeTimeout.timeout=null),this.draggingNode==s)return t.dataset.treeDropzone==="delete"?(this.nodeDragMode=h.DELETE,e.preventDefault(),this.refreshDragToolTip(),!0):(this.refreshDragToolTip(),!0);if(s.__parents.includes(this.draggingNode.identifier))return this.refreshDragToolTip(),!0;if(this.nodeDragMode=h.MOVE,e.dataTransfer.types.includes(m.newTreenode)&&(this.nodeDragMode=h.NEW),this.nodeDragPosition=g.INSIDE,s.depth===0||this.allowNodeSorting===!1)return this.refreshDragToolTip(),e.preventDefault(),!0;const o=this.getElementFromNode(s).getBoundingClientRect(),n=e.clientY-o.y;return n<6?(this.nodeDragPosition=g.BEFORE,r.classList.add("node-dragging-before")):this.nodeHeight-n<6&&s.hasChildren===!1&&s.__expanded===!1&&(this.nodeDragPosition=g.AFTER,r.classList.add("node-dragging-after")),this.refreshDragToolTip(),e.preventDefault(),!0}handleNodeDragLeave(e){this.draggingNode!==null&&this.cleanDrag()}handleNodeDragEnd(e){this.cleanDrag(),this.draggingNode=null,this.requestUpdate()}handleNodeDrop(e){if(this.cleanDrag(),e.dataTransfer.types.includes(m.treenode)){e.preventDefault();const t=e.dataTransfer.getData(m.treenode),s=this.getNodeByTreeIdentifier(t);this.nodeDragMode===h.DELETE&&this.deleteNode(s);const r=this.getNodeFromDragEvent(e);return r===null?!1:(this.nodeDragMode===h.MOVE&&this.moveNode(s,r,this.nodeDragPosition),this.nodeDragMode=null,this.nodeDragPosition=null,!0)}if(e.dataTransfer.types.includes(m.newTreenode)){e.preventDefault();const t=this.getNodeFromDragEvent(e);if(t===null)return!1;const s=e.dataTransfer.getData(m.newTreenode);return this.addNode(JSON.parse(s),t,this.nodeDragPosition),this.nodeDragMode=null,this.nodeDragPosition=null,!0}return!1}refreshDragToolTip(){top.document.dispatchEvent(new CustomEvent("typo3:drag-tooltip:metadata-update",{detail:{statusIconIdentifier:this.getNodeDragStatusIcon()}}))}createNodeLabel(e){const t=this.getNodeLabels(e);if(t.length===0)return d`${p}`;const r={backgroundColor:t[0].color};return d`<span class=node-label style=${v(r)}></span>`}createNodeGuides(e){const t=e.__treeParents.map(s=>{const r=this.getNodeByTreeIdentifier(s);let i="none";return this.getNodeSetsize(r)!==this.getNodePositionInSet(r)&&(i="line"),d`<div class="node-treeline node-treeline--${i}" data-origin=${this.getNodeTreeIdentifier(r)} data-nodesize=${this.getNodeSetsize(r)} data-position=${this.getNodePositionInSet(r)}></div>`});return this.getNodeSetsize(e)===this.getNodePositionInSet(e)?t.push(d`<div class="node-treeline node-treeline--last" data-origin=${this.getNodeTreeIdentifier(e)}></div>`):t.push(d`<div class="node-treeline node-treeline--connect" data-origin=${this.getNodeTreeIdentifier(e)}></div>`),d`<div class=node-treelines>${t}</div>`}createNodeLoader(e){return e.__loading===!0?d`<span class=node-loading> <typo3-backend-icon identifier=spinner-circle size=small></typo3-backend-icon> </span>`:null}createNodeToggle(e){const t=this.isRTL()?"actions-chevron-left":"actions-chevron-right";return e.hasChildren===!0?d`<span class=node-toggle @click=${s=>{s.preventDefault(),s.stopImmediatePropagation(),this.handleNodeToggle(e)}}> <typo3-backend-icon identifier=${e.__expanded?"actions-chevron-down":t} size=small></typo3-backend-icon> </span>`:null}createNodeContent(e){return d`<div class=node-content>${this.createNodeContentIcon(e)} ${this.editingNode===e?this.createNodeForm(e):this.createNodeContentLabel(e)} ${this.createNodeContentAction(e)}</div>`}createNodeContentIcon(e){return this.settings.showIcons?d`<span class=node-icon @click=${t=>{t.preventDefault(),t.stopImmediatePropagation(),this.dispatchEvent(new CustomEvent("typo3:tree:node-context",{detail:{node:e,originalEvent:t}}))}} @dblclick=${t=>{t.preventDefault(),t.stopImmediatePropagation()}}> <typo3-backend-icon identifier=${e.icon} overlay=${e.overlayIcon} size=small></typo3-backend-icon> </span>`:d`${p}`}createNodeContentLabel(e){let t=(e.prefix||"")+e.name+(e.suffix||"");const s=document.createElement("div");if(s.textContent=t,t=s.innerHTML,this.searchTerm){const r=new RegExp(this.searchTerm.replace(/[/\-\\^$*+?.()|[\]{}]/g,"\\$&"),"gi");t=t.replace(r,'<span class="node-highlight-text">$&</span>')}return d`<div class=node-contentlabel><div class=node-name .innerHTML=${t}></div>${e.note?d`<div class=node-note>${e.note}</div>`:p}</div>`}createNodeStatusInformation(e){const t=this.getNodeStatusInformation(e);if(t.length===0)return d`${p}`;const s=t[0],r=S.getCssClass(s.severity),i=s.icon!==""?s.icon:"actions-dot",o=s.overlayIcon!==""?s.overlayIcon:void 0;return d`<span class=node-information> <typo3-backend-icon class=text-${r} identifier=${i} overlay=${y(o)} size=small></typo3-backend-icon> </span>`}createNodeDeleteDropZone(e){return this.draggingNode===e&&e.deletable?d`<div class=node-dropzone-delete data-tree-dropzone=delete><typo3-backend-icon identifier=actions-delete size=small></typo3-backend-icon>${TYPO3.lang.deleteItem}</div>`:d`${p}`}createNodeForm(e){const t=e.identifier.startsWith("NEW")?h.NEW:h.EDIT;return d`<input class=node-edit @click=${i=>{i.stopImmediatePropagation()}} @blur=${i=>{if(this.editingNode!==null){this.editingNode=null;const n=i.target.value.trim();n!==e.name&&n!==""?this.handleNodeEdit(e,n):t===h.NEW&&this.removeNode(e),this.requestUpdate()}}} @keydown=${i=>{const o=i.key;if([l.ENTER,l.TAB].includes(o)){const a=i.target.value.trim();this.editingNode=null,this.requestUpdate(),a!==e.name&&a!==""?(this.handleNodeEdit(e,a),this.focusNode(e)):t===h.NEW&&a===""?this.removeNode(e):this.focusNode(e)}else[l.ESCAPE].includes(o)&&(this.editingNode=null,this.requestUpdate(),t===h.NEW?this.removeNode(e):this.focusNode(e))}} value=${e.name}>`}async handleNodeEdit(e,t){console.error("The function Tree->handleNodeEdit is not implemented.")}handleNodeDelete(e){console.error("The function Tree->handleNodeDelete is not implemented.")}handleNodeMove(e,t,s){console.error("The function Tree->handleNodeMove is not implemented.")}async handleNodeAdd(e,t,s){console.error("The function Tree->handleNodeAdd is not implemented.")}createNodeContentAction(e){return d`${p}`}createDataTransferItemsFromNode(e){throw new Error("The function Tree->createDataTransferItemFromNode is not implemented.")}getNodeIdentifier(e){return e.identifier}getNodeTreeIdentifier(e){return e.__treeIdentifier}getNodeParentTreeIdentifier(e){return e.__parents.join("_")}getNodeClasses(e){const t=["node"];return e.checked&&t.push("node-selected"),this.draggingNode===e&&t.push("node-dragging"),t}getNodeLabels(e){let t=e.labels;if(t.length>0)return t=t.sort((r,i)=>i.priority-r.priority),t;const s=this.getParentNode(e);return s===null?[]:this.getNodeLabels(s)}getNodeStatusInformation(e){return e.statusInformation.length===0?[]:e.statusInformation.sort((s,r)=>s.severity!==r.severity?r.severity-s.severity:r.priority-s.priority)}getNodeDepth(e){return e.depth}getNodeTabindex(e){return this.focusedNode?this.focusedNode===e?0:-1:this.lastFocusedNode?this.lastFocusedNode===e?0:-1:this.getFirstNode()===e?0:-1}getNodeChildren(e){return e.hasChildren?this.displayNodes.filter(t=>e===this.getParentNode(t)):[]}getNodeSetsize(e){if(e.depth===0)return this.displayNodes.filter(r=>r.depth===0).length;const t=this.getParentNode(e);return this.getNodeChildren(t).length}getNodePositionInSet(e){const t=this.getParentNode(e);let s=[];return e.depth===0?s=this.displayNodes.filter(r=>r.depth===0):t!==null&&(s=this.getNodeChildren(t)),s.indexOf(e)+1}getFirstNode(){return this.displayNodes.length?this.displayNodes[0]:null}getPreviousNode(e){const s=this.displayNodes.indexOf(e)-1;return this.displayNodes[s]?this.displayNodes[s]:null}getNextNode(e){const s=this.displayNodes.indexOf(e)+1;return this.displayNodes[s]?this.displayNodes[s]:null}getLastNode(){return this.displayNodes.length?this.displayNodes[this.displayNodes.length-1]:null}getParentNode(e){return e.__parents.length?this.getNodeByTreeIdentifier(this.getNodeParentTreeIdentifier(e)):null}getNodeTitle(e){let t=e.tooltip?e.tooltip:"uid="+e.identifier+" "+e.name;const s=this.getNodeLabels(e);s.length&&(t+="; "+s.map(i=>i.label).join("; "));const r=this.getNodeStatusInformation(e);return r.length&&(t+="; "+r.map(i=>i.label).join("; ")),t}handleNodeToggle(e){e.__expanded?this.hideChildren(e):this.showChildren(e)}isRTL(){return window.getComputedStyle(document.documentElement).getPropertyValue("direction")==="rtl"}handleKeyboardInteraction(e){if(this.editingNode!==null||[l.ENTER,l.SPACE,l.END,l.HOME,l.LEFT,l.UP,l.RIGHT,l.DOWN].includes(e.key)===!1)return;const s=e.target,r=this.getNodeFromElement(s);if(r===null)return;const i=this.getParentNode(r),o=this.getFirstNode(),n=this.getPreviousNode(r),a=this.getNextNode(r),u=this.getLastNode();switch(e.preventDefault(),e.key){case l.HOME:o!==null&&(this.scrollNodeIntoVisibleArea(o),this.focusNode(o));break;case l.END:u!==null&&(this.scrollNodeIntoVisibleArea(u),this.focusNode(u));break;case l.UP:n!==null&&(this.scrollNodeIntoVisibleArea(n),this.focusNode(n));break;case l.DOWN:a!==null&&(this.scrollNodeIntoVisibleArea(a),this.focusNode(a));break;case l.LEFT:r.__expanded?r.hasChildren&&this.hideChildren(r):i&&(this.scrollNodeIntoVisibleArea(i),this.focusNode(i));break;case l.RIGHT:r.__expanded&&a?(this.scrollNodeIntoVisibleArea(a),this.focusNode(a)):r.hasChildren&&this.showChildren(r);break;case l.ENTER:case l.SPACE:this.selectNode(r);break;default:}}scrollNodeIntoVisibleArea(e){const t=e.__y,s=e.__y+this.nodeHeight,r=t>=this.currentScrollPosition,i=s<=this.currentScrollPosition+this.currentVisibleHeight;if(!(r&&i)){let n=this.currentScrollPosition;!r&&!i?n=s-this.currentVisibleHeight:r?i||(n=s-this.currentVisibleHeight):n=t,n<0&&(n=0),this.root.scrollTo({top:n})}}registerUnloadHandler(){try{if(!window.frameElement)return;window.addEventListener("pagehide",()=>this.muteErrorNotifications=!0,{once:!0})}catch{console.error("Failed to check the existence of window.frameElement \u2013 using a foreign origin?")}}}f([w({type:Object})],c.prototype,"setup",void 0),f([N()],c.prototype,"settings",void 0),f([P(".nodes-root")],c.prototype,"root",void 0),f([N()],c.prototype,"nodes",void 0),f([N()],c.prototype,"currentScrollPosition",void 0),f([N()],c.prototype,"currentVisibleHeight",void 0),f([N()],c.prototype,"searchTerm",void 0),f([N()],c.prototype,"loading",void 0),f([N()],c.prototype,"hoveredNode",void 0),f([N()],c.prototype,"nodeDragAllowed",void 0);export{c as Tree};
