/*
 * Decompiled with CFR 0.152.
 */
package org.sablecc.sablecc;

import java.util.Vector;
import org.sablecc.sablecc.IntSet;
import org.sablecc.sablecc.Symbol;

final class SymbolSet
implements Cloneable {
    private final IntSet terminals;
    private final IntSet nonterminals;
    private boolean empty;
    private boolean modified = true;
    private Symbol[] symbols;

    private void computeArray() {
        int i;
        Vector<Symbol> symbols = new Vector<Symbol>(0);
        int[] elements = this.terminals.elements();
        for (i = 0; i < elements.length; ++i) {
            symbols.addElement(Symbol.symbol(elements[i], true));
        }
        elements = this.nonterminals.elements();
        for (i = 0; i < elements.length; ++i) {
            symbols.addElement(Symbol.symbol(elements[i], false));
        }
        this.symbols = new Symbol[symbols.size()];
        symbols.copyInto(this.symbols);
        this.modified = false;
    }

    SymbolSet() {
        this.terminals = new IntSet();
        this.nonterminals = new IntSet();
    }

    private SymbolSet(SymbolSet set) {
        this.terminals = (IntSet)set.terminals.clone();
        this.nonterminals = (IntSet)set.nonterminals.clone();
        this.empty = set.empty;
    }

    void setTerminal(int terminal) {
        this.terminals.set(terminal);
        this.modified = true;
    }

    void clearTerminal(int terminal) {
        this.terminals.clear(terminal);
        this.modified = true;
    }

    boolean getTerminal(int terminal) {
        return this.terminals.get(terminal);
    }

    void setNonterminal(int nonterminal) {
        this.nonterminals.set(nonterminal);
        this.modified = true;
    }

    void clearNonterminal(int nonterminal) {
        this.nonterminals.clear(nonterminal);
        this.modified = true;
    }

    boolean getNonterminal(int nonterminal) {
        return this.nonterminals.get(nonterminal);
    }

    void setEmpty() {
        this.empty = true;
        this.modified = true;
    }

    void clearEmpty() {
        this.empty = false;
        this.modified = true;
    }

    boolean getEmpty() {
        return this.empty;
    }

    void and(SymbolSet s) {
        this.terminals.and(s.terminals);
        this.nonterminals.and(s.nonterminals);
        this.empty &= s.empty;
        this.modified = true;
    }

    void or(SymbolSet s) {
        this.terminals.or(s.terminals);
        this.nonterminals.or(s.nonterminals);
        this.empty |= s.empty;
        this.modified = true;
    }

    void xor(SymbolSet s) {
        this.terminals.xor(s.terminals);
        this.nonterminals.xor(s.nonterminals);
        this.empty ^= s.empty;
        this.modified = true;
    }

    public int hashCode() {
        return this.terminals.hashCode() + this.nonterminals.hashCode() + new Boolean(this.empty).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        SymbolSet s = (SymbolSet)obj;
        return this.terminals.equals(s.terminals) && this.nonterminals.equals(s.nonterminals) && this.empty == s.empty;
    }

    Symbol[] getSymbols() {
        if (this.modified) {
            this.computeArray();
        }
        return this.symbols;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("{");
        Symbol[] symbols = this.getSymbols();
        boolean comma = false;
        for (int i = 0; i < symbols.length; ++i) {
            if (comma) {
                result.append(",");
            } else {
                comma = true;
            }
            result.append(symbols[i]);
        }
        if (this.empty) {
            if (comma) {
                result.append(",");
            } else {
                comma = true;
            }
            result.append("*empty*");
        }
        result.append("}");
        return result.toString();
    }

    public Object clone() {
        return new SymbolSet(this);
    }
}

