/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Configuration;
import net.sf.saxon.PreparedStylesheet;
import net.sf.saxon.expr.CollationMap;
import net.sf.saxon.expr.sort.CodepointCollator;
import net.sf.saxon.functions.ConstructorFunctionLibrary;
import net.sf.saxon.functions.ExecutableFunctionLibrary;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.functions.FunctionLibraryList;
import net.sf.saxon.functions.SystemFunctionLibrary;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.om.DocumentURI;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.query.XQueryFunction;
import net.sf.saxon.query.XQueryFunctionLibrary;
import net.sf.saxon.serialize.CharacterMap;
import net.sf.saxon.serialize.CharacterMapIndex;
import net.sf.saxon.style.CollationDeclaration;
import net.sf.saxon.style.Declaration;
import net.sf.saxon.style.SourceBinding;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.StylesheetFunctionLibrary;
import net.sf.saxon.style.StylesheetModule;
import net.sf.saxon.style.StylesheetProcedure;
import net.sf.saxon.style.XSLAttributeSet;
import net.sf.saxon.style.XSLCharacterMap;
import net.sf.saxon.style.XSLFunction;
import net.sf.saxon.style.XSLGlobalVariable;
import net.sf.saxon.style.XSLImportSchema;
import net.sf.saxon.style.XSLNamespaceAlias;
import net.sf.saxon.style.XSLOutput;
import net.sf.saxon.style.XSLStylesheet;
import net.sf.saxon.style.XSLTemplate;
import net.sf.saxon.trans.CompilerInfo;
import net.sf.saxon.trans.RuleManager;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.z.IntHashMap;
import net.sf.saxon.z.IntIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrincipalStylesheetModule
extends StylesheetModule {
    private static final boolean TIMING = false;
    private PreparedStylesheet preparedStylesheet;
    private HashSet<String> schemaIndex = new HashSet(10);
    private XQueryFunctionLibrary queryFunctions;
    private FunctionLibraryList functionLibrary;
    private String version;
    private HashMap<StructuredQName, Declaration> globalVariableIndex = new HashMap(20);
    private HashMap<StructuredQName, Declaration> templateIndex = new HashMap(20);
    private IntHashMap<HashMap<StructuredQName, Declaration>> functionIndex = new IntHashMap(8);
    private HashMap<StructuredQName, Integer> localParameterNumbers = null;
    private int numberOfAliases = 0;
    private List<Declaration> namespaceAliasList = new ArrayList<Declaration>(5);
    private HashMap<String, NamespaceBinding> namespaceAliasMap;
    private Set<String> aliasResultUriSet;
    private boolean needsDynamicOutputProperties = false;
    private int largestPatternStackFrame = 0;
    private HashMap<DocumentURI, XSLStylesheet> moduleCache = new HashMap(4);

    public PrincipalStylesheetModule(XSLStylesheet sourceElement, int precedence) {
        super(sourceElement, precedence);
    }

    public void setPreparedStylesheet(PreparedStylesheet preparedStylesheet) {
        this.preparedStylesheet = preparedStylesheet;
    }

    public PreparedStylesheet getPreparedStylesheet() {
        return this.preparedStylesheet;
    }

    @Override
    public PrincipalStylesheetModule getPrincipalStylesheetModule() {
        return this;
    }

    public FunctionLibraryList createFunctionLibrary(CompilerInfo info) {
        Configuration config = this.getPreparedStylesheet().getConfiguration();
        FunctionLibraryList functionLibrary = new FunctionLibraryList();
        int functionSet = 3;
        if ("3.0".equals(this.getVersion())) {
            functionSet |= 0x50;
        }
        functionLibrary.addFunctionLibrary(SystemFunctionLibrary.getSystemFunctionLibrary(functionSet));
        functionLibrary.addFunctionLibrary(new StylesheetFunctionLibrary(this, true));
        functionLibrary.addFunctionLibrary(config.getVendorFunctionLibrary());
        functionLibrary.addFunctionLibrary(new ConstructorFunctionLibrary(config));
        if (info.getExtensionFunctionLibrary() != null) {
            functionLibrary.addFunctionLibrary(info.getExtensionFunctionLibrary());
        }
        this.queryFunctions = new XQueryFunctionLibrary(config);
        functionLibrary.addFunctionLibrary(this.queryFunctions);
        functionLibrary.addFunctionLibrary(config.getIntegratedFunctionLibrary());
        config.addExtensionBinders(functionLibrary);
        functionLibrary.addFunctionLibrary(new StylesheetFunctionLibrary(this, false));
        if (this.getPreparedStylesheet().getAccumulatorManager() != null) {
            functionLibrary.addFunctionLibrary(this.getPreparedStylesheet().getAccumulatorManager().getAccumulatorFunctionLibrary());
        }
        this.functionLibrary = functionLibrary;
        return this.functionLibrary;
    }

    public FunctionLibrary getFunctionLibrary() {
        return this.functionLibrary;
    }

    public void declareXQueryFunction(XQueryFunction function) throws XPathException {
        this.queryFunctions.declareFunction(function);
    }

    public void putStylesheetDocument(DocumentURI key, XSLStylesheet module) {
        this.moduleCache.put(key, module);
    }

    public XSLStylesheet getStylesheetDocument(DocumentURI key) {
        XSLStylesheet sheet = this.moduleCache.get(key);
        if (sheet != null) {
            TransformerException warning = new TransformerException("Stylesheet module " + key + " is included or imported more than once. " + "This is permitted, but may lead to errors or unexpected behavior");
            this.getPreparedStylesheet().reportWarning(warning);
        }
        return sheet;
    }

    public void preprocess() throws XPathException {
        Declaration decl2;
        this.spliceIncludes();
        this.buildIndexes();
        this.checkForSchemaAwareness();
        this.processAllAttributes();
        this.collectNamespaceAliases();
        for (Declaration decl2 : this.topLevel) {
            StyleElement inst = decl2.getSourceElement();
            if (inst.isActionCompleted(16)) continue;
            inst.setActionCompleted(16);
            inst.fixupReferences();
        }
        XSLStylesheet top = this.getSourceElement();
        this.setInputTypeAnnotations(top.getInputTypeAnnotationsAttribute());
        decl2 = new Declaration(this, top);
        if (!top.isActionCompleted(1)) {
            top.setActionCompleted(1);
            top.validate(decl2);
            for (Declaration d : this.topLevel) {
                d.getSourceElement().validateSubtree(d);
            }
        }
    }

    private void buildIndexes() throws XPathException {
        for (int i = this.topLevel.size() - 1; i >= 0; --i) {
            Declaration decl = (Declaration)this.topLevel.get(i);
            decl.getSourceElement().index(decl, this);
        }
        Configuration config = this.getPreparedStylesheet().getConfiguration();
        for (String ns : this.schemaIndex) {
            config.sealNamespace(ns);
        }
    }

    public void processAllAttributes() throws XPathException {
        this.getSourceElement().processDefaultCollationAttribute();
        this.getSourceElement().prepareAttributes();
        for (Declaration decl : this.topLevel) {
            StyleElement inst = decl.getSourceElement();
            if (inst.isActionCompleted(32)) continue;
            inst.setActionCompleted(32);
            try {
                inst.processAllAttributes();
            }
            catch (XPathException err) {
                decl.getSourceElement().compileError(err);
            }
        }
    }

    protected void indexFunction(Declaration decl) throws XPathException {
        int arity;
        XSLFunction function = (XSLFunction)decl.getSourceElement();
        StructuredQName qName = function.getObjectName();
        Declaration other = this.getFunctionDeclaration(qName, arity = function.getNumberOfArguments());
        if (other == null) {
            this.putFunction(decl);
        } else {
            int otherPrecedence;
            int thisPrecedence = decl.getPrecedence();
            if (thisPrecedence == (otherPrecedence = other.getPrecedence())) {
                StyleElement f2 = other.getSourceElement();
                if (decl.getSourceElement() == f2) {
                    function.compileError("Function " + qName.getDisplayName() + " is declared more than once " + "(caused by including the containing module more than once)", "XTSE0770");
                } else {
                    function.compileError("Duplicate function declaration (see line " + f2.getLineNumber() + " of " + f2.getSystemId() + ')', "XTSE0770");
                }
            } else if (thisPrecedence >= otherPrecedence) {
                this.putFunction(decl);
            }
        }
    }

    protected Declaration getFunctionDeclaration(StructuredQName name, int arity) {
        HashMap<StructuredQName, Declaration> m = this.functionIndex.get(arity);
        return m == null ? null : m.get(name);
    }

    protected XSLFunction getFunction(StructuredQName name, int arity) {
        if (arity == -1) {
            IntIterator arities = this.functionIndex.keyIterator();
            while (arities.hasNext()) {
                int a = arities.next();
                Declaration decl = this.getFunctionDeclaration(name, a);
                if (decl == null) continue;
                return (XSLFunction)decl.getSourceElement();
            }
            return null;
        }
        Declaration decl = this.getFunctionDeclaration(name, arity);
        return decl == null ? null : (XSLFunction)decl.getSourceElement();
    }

    protected void putFunction(Declaration decl) {
        XSLFunction function = (XSLFunction)decl.getSourceElement();
        StructuredQName qName = function.getObjectName();
        int arity = function.getNumberOfArguments();
        HashMap<StructuredQName, Declaration> m = this.functionIndex.get(arity);
        if (m == null) {
            m = new HashMap();
            this.functionIndex.put(arity, m);
        }
        m.put(qName, decl);
    }

    protected void indexVariableDeclaration(Declaration decl) throws XPathException {
        XSLGlobalVariable var = (XSLGlobalVariable)decl.getSourceElement();
        StructuredQName qName = var.getSourceBinding().getVariableQName();
        if (qName != null) {
            Declaration other = this.globalVariableIndex.get(qName);
            if (other == null) {
                this.globalVariableIndex.put(qName, decl);
            } else {
                int otherPrecedence;
                int thisPrecedence = decl.getPrecedence();
                if (thisPrecedence == (otherPrecedence = other.getPrecedence())) {
                    StyleElement v2 = other.getSourceElement();
                    if (v2 == var) {
                        var.compileError("Global variable " + qName.getDisplayName() + " is declared more than once " + "(caused by including the containing module more than once)", "XTSE0630");
                    } else {
                        var.compileError("Duplicate global variable declaration (see line " + v2.getLineNumber() + " of " + v2.getSystemId() + ')', "XTSE0630");
                    }
                } else if (thisPrecedence < otherPrecedence && var != other.getSourceElement()) {
                    var.setRedundant(true);
                } else if (var != other.getSourceElement()) {
                    ((XSLGlobalVariable)other.getSourceElement()).setRedundant(true);
                    this.globalVariableIndex.put(qName, decl);
                }
            }
        }
    }

    public SourceBinding getGlobalVariable(StructuredQName qName) {
        Declaration decl = this.globalVariableIndex.get(qName);
        return decl == null ? null : ((XSLGlobalVariable)decl.getSourceElement()).getSourceBinding();
    }

    public int allocateUniqueParameterNumber(StructuredQName qName) {
        Integer x;
        HashMap<StructuredQName, Integer> params = this.localParameterNumbers;
        if (params == null) {
            params = this.localParameterNumbers = new HashMap(50);
        }
        if ((x = params.get(qName)) == null) {
            x = params.size();
            params.put(qName, x);
        }
        return x;
    }

    protected void indexNamedTemplate(Declaration decl) throws XPathException {
        XSLTemplate template = (XSLTemplate)decl.getSourceElement();
        StructuredQName qName = template.getTemplateName();
        if (qName != null) {
            Declaration other = this.templateIndex.get(qName);
            if (other == null) {
                this.templateIndex.put(qName, decl);
                this.getPreparedStylesheet().putNamedTemplate(qName, template.getCompiledTemplate());
            } else {
                int otherPrecedence;
                int thisPrecedence = decl.getPrecedence();
                if (thisPrecedence == (otherPrecedence = other.getPrecedence())) {
                    StyleElement t2 = other.getSourceElement();
                    template.compileError("Duplicate named template (see line " + t2.getLineNumber() + " of " + t2.getSystemId() + ')', "XTSE0660");
                } else if (thisPrecedence >= otherPrecedence) {
                    this.templateIndex.put(qName, decl);
                    this.getPreparedStylesheet().putNamedTemplate(qName, template.getCompiledTemplate());
                }
            }
        }
    }

    public XSLTemplate getNamedTemplate(StructuredQName name) {
        Declaration decl = this.templateIndex.get(name);
        return decl == null ? null : (XSLTemplate)decl.getSourceElement();
    }

    private void checkForSchemaAwareness() {
        PreparedStylesheet exec = this.getPreparedStylesheet();
        if (!exec.isSchemaAware() && exec.getConfiguration().isLicensedFeature(2)) {
            for (Declaration decl : this.topLevel) {
                StyleElement node = decl.getSourceElement();
                if (!(node instanceof XSLImportSchema)) continue;
                exec.setSchemaAware(true);
                return;
            }
        }
    }

    protected void addNamespaceAlias(Declaration node) {
        this.namespaceAliasList.add(node);
        ++this.numberOfAliases;
    }

    protected NamespaceBinding getNamespaceAlias(String uri) {
        return this.namespaceAliasMap.get(uri);
    }

    protected boolean isAliasResultNamespace(String uri) {
        return this.aliasResultUriSet.contains(uri);
    }

    private void collectNamespaceAliases() throws XPathException {
        this.namespaceAliasMap = new HashMap(this.numberOfAliases);
        this.aliasResultUriSet = new HashSet<String>(this.numberOfAliases);
        HashSet<String> aliasesAtThisPrecedence = new HashSet<String>();
        int currentPrecedence = -1;
        for (int i = 0; i < this.numberOfAliases; ++i) {
            Declaration decl = this.namespaceAliasList.get(i);
            XSLNamespaceAlias xna = (XSLNamespaceAlias)decl.getSourceElement();
            String scode = xna.getStylesheetURI();
            NamespaceBinding resultBinding = xna.getResultNamespaceBinding();
            int prec = decl.getPrecedence();
            if (currentPrecedence != prec) {
                currentPrecedence = prec;
                aliasesAtThisPrecedence.clear();
            }
            if (aliasesAtThisPrecedence.contains(scode) && !this.namespaceAliasMap.get(scode).getURI().equals(resultBinding.getURI())) {
                xna.compileError("More than one alias is defined for the same namespace", "XTSE0810");
            }
            if (this.namespaceAliasMap.get(scode) == null) {
                this.namespaceAliasMap.put(scode, resultBinding);
                this.aliasResultUriSet.add(resultBinding.getURI());
            }
            aliasesAtThisPrecedence.add(scode);
        }
        this.namespaceAliasList = null;
    }

    protected boolean hasNamespaceAliases() {
        return this.numberOfAliases > 0;
    }

    public CollationMap getCollationMap() {
        return this.getPreparedStylesheet().getCollationTable();
    }

    public void setCollation(String name, StringCollator collation) {
        PreparedStylesheet exec = this.getPreparedStylesheet();
        if (exec.getCollationTable() == null) {
            exec.setCollationMap(new CollationMap(exec.getConfiguration()));
        }
        exec.getCollationTable().setNamedCollation(name, collation);
    }

    public StringCollator findCollation(String name, String baseURI) {
        PreparedStylesheet exec = this.getPreparedStylesheet();
        Configuration config = exec.getConfiguration();
        if (name.equals("http://www.w3.org/2005/xpath-functions/collation/codepoint")) {
            return CodepointCollator.getInstance();
        }
        StringCollator c = null;
        if (exec.getCollationTable() != null) {
            c = exec.getCollationTable().getNamedCollation(name);
        }
        if (c != null) {
            return c;
        }
        for (int i = this.topLevel.size() - 1; i >= 0; --i) {
            CollationDeclaration t;
            Declaration decl = (Declaration)this.topLevel.get(i);
            if (!(decl.getSourceElement() instanceof CollationDeclaration) || !(t = (CollationDeclaration)((Object)decl.getSourceElement())).getCollationName().equals(name)) continue;
            return t.getCollator();
        }
        return config.getCollationURIResolver().resolve(name, baseURI, config);
    }

    public Properties gatherOutputProperties(StructuredQName formatQName) throws XPathException {
        boolean found = formatQName == null;
        Configuration config = this.getPreparedStylesheet().getConfiguration();
        Properties details = new Properties(config.getDefaultSerializationProperties());
        HashMap<String, Integer> precedences = new HashMap<String, Integer>(10);
        for (int i = this.topLevel.size() - 1; i >= 0; --i) {
            Declaration decl = (Declaration)this.topLevel.get(i);
            if (!(decl.getSourceElement() instanceof XSLOutput)) continue;
            XSLOutput xo = (XSLOutput)decl.getSourceElement();
            if (!(formatQName == null ? xo.getFormatQName() == null : formatQName.equals(xo.getFormatQName()))) continue;
            found = true;
            xo.gatherOutputProperties(details, precedences, decl.getPrecedence());
        }
        if (!found) {
            this.compileError("Requested output format " + formatQName.getDisplayName() + " has not been defined", "XTDE1460");
        }
        return details;
    }

    public void compileStylesheet() throws XPathException {
        block26: {
            try {
                StyleElement node;
                StyleElement snode;
                PreparedStylesheet pss = this.getPreparedStylesheet();
                Configuration config = pss.getConfiguration();
                try {
                    Iterator<XQueryFunction> qf = this.queryFunctions.getFunctionDefinitions();
                    while (qf.hasNext()) {
                        XQueryFunction f = qf.next();
                        f.fixupReferences();
                    }
                }
                catch (XPathException e) {
                    this.compileError(e);
                }
                for (Declaration decl : this.topLevel) {
                    snode = decl.getSourceElement();
                    if (!(snode instanceof XSLTemplate)) continue;
                    ((XSLTemplate)snode).register(decl);
                }
                for (Declaration decl : this.topLevel) {
                    snode = decl.getSourceElement();
                    if (snode.isActionCompleted(2)) continue;
                    snode.setActionCompleted(2);
                    snode.compileDeclaration(pss, decl);
                }
                IntIterator arities = this.functionIndex.keyIterator();
                while (arities.hasNext()) {
                    for (Declaration decl : this.functionIndex.get(arities.next()).values()) {
                        node = decl.getSourceElement();
                        if (node.isActionCompleted(4)) continue;
                        node.setActionCompleted(4);
                        ((XSLFunction)node).typeCheckBody();
                    }
                }
                if (this.getPreparedStylesheet().getErrorCount() > 0) {
                    return;
                }
                for (Declaration decl : this.topLevel) {
                    StyleElement node2 = decl.getSourceElement();
                    if (!(node2 instanceof StylesheetProcedure) || node2 instanceof XSLFunction || node2.isActionCompleted(8)) continue;
                    node2.setActionCompleted(8);
                    ((StylesheetProcedure)((Object)node2)).optimize(decl);
                }
                arities = this.functionIndex.keyIterator();
                while (arities.hasNext()) {
                    for (Declaration decl : this.functionIndex.get(arities.next()).values()) {
                        node = decl.getSourceElement();
                        if (node.isActionCompleted(8)) continue;
                        node.setActionCompleted(8);
                        ((StylesheetProcedure)((Object)node)).optimize(decl);
                    }
                }
                if (config.isTiming() && config.isGenerateByteCode(50)) {
                    config.getStandardErrorOutput().println("Generating byte code...");
                }
                pss.setStripsWhitespace(this.stripsWhitespace());
                Properties props = this.gatherOutputProperties(null);
                props.setProperty("{http://saxon.sf.net/}stylesheet-version", this.getVersion());
                pss.setDefaultOutputProperties(props);
                HashSet<StructuredQName> outputNames = new HashSet<StructuredQName>(5);
                for (Declaration decl : this.topLevel) {
                    XSLOutput out;
                    StructuredQName qName;
                    if (!(decl.getSourceElement() instanceof XSLOutput) || (qName = (out = (XSLOutput)decl.getSourceElement()).getFormatQName()) == null) continue;
                    outputNames.add(qName);
                }
                if (outputNames.isEmpty()) {
                    if (this.needsDynamicOutputProperties) {
                        this.compileError("The stylesheet contains xsl:result-document instructions that calculate the output format name at run-time, but there are no named xsl:output declarations", "XTDE1460");
                    }
                } else {
                    for (StructuredQName qName : outputNames) {
                        Properties oprops = this.gatherOutputProperties(qName);
                        if (!this.needsDynamicOutputProperties) continue;
                        pss.setOutputProperties(qName, oprops);
                    }
                }
                pss.setPatternSlotSpace(this.largestPatternStackFrame);
                pss.setStripsInputTypeAnnotations(this.getInputTypeAnnotations() == 1);
                for (Declaration decl : this.topLevel) {
                    XSLCharacterMap t;
                    if (!(decl.getSourceElement() instanceof XSLCharacterMap) || (t = (XSLCharacterMap)decl.getSourceElement()).isRedundant()) continue;
                    StructuredQName qn = t.getCharacterMapName();
                    IntHashMap<String> charMap = new IntHashMap<String>();
                    t.assemble(charMap);
                    CharacterMap map = new CharacterMap(charMap);
                    if (pss.getCharacterMapIndex() == null) {
                        pss.setCharacterMapIndex(new CharacterMapIndex());
                    }
                    pss.getCharacterMapIndex().putCharacterMap(qn, map);
                }
                pss.getDecimalFormatManager().checkConsistency();
                RuleManager ruleManager = this.getPreparedStylesheet().getRuleManager();
                ruleManager.computeRankings();
                ruleManager.invertStreamableTemplates(config.obtainOptimizer());
                ExecutableFunctionLibrary overriding = new ExecutableFunctionLibrary(config);
                ExecutableFunctionLibrary underriding = new ExecutableFunctionLibrary(config);
                for (Declaration decl : this.topLevel) {
                    if (!(decl.getSourceElement() instanceof XSLFunction)) continue;
                    XSLFunction func = (XSLFunction)decl.getSourceElement();
                    if (func.isOverriding()) {
                        overriding.addFunction(func.getCompiledFunction());
                        continue;
                    }
                    underriding.addFunction(func.getCompiledFunction());
                }
                FunctionLibraryList libraryList = new FunctionLibraryList();
                for (FunctionLibrary lib : this.functionLibrary.getLibraryList()) {
                    if (lib instanceof StylesheetFunctionLibrary) {
                        if (((StylesheetFunctionLibrary)lib).isOverriding()) {
                            libraryList.addFunctionLibrary(overriding);
                            continue;
                        }
                        libraryList.addFunctionLibrary(underriding);
                        continue;
                    }
                    libraryList.addFunctionLibrary(lib);
                }
                pss.setFunctionLibrary(libraryList);
            }
            catch (RuntimeException err) {
                if (this.getPreparedStylesheet().getErrorCount() != 0) break block26;
                throw err;
            }
        }
    }

    protected boolean isImportedSchema(String targetNamespace) {
        return this.schemaIndex.contains(targetNamespace);
    }

    protected void addImportedSchema(String targetNamespace) {
        this.schemaIndex.add(targetNamespace);
    }

    protected HashSet<String> getImportedSchemaTable() {
        return this.schemaIndex;
    }

    protected boolean getAttributeSets(StructuredQName name, List<Declaration> list) throws XPathException {
        boolean found = false;
        for (Declaration decl : this.topLevel) {
            XSLAttributeSet t;
            if (!(decl.getSourceElement() instanceof XSLAttributeSet) || !(t = (XSLAttributeSet)decl.getSourceElement()).getAttributeSetName().equals(name)) continue;
            t.incrementReferenceCount();
            list.add(decl);
            found = true;
        }
        return found;
    }

    public boolean stripsWhitespace() {
        for (Declaration aTopLevel : this.topLevel) {
            StyleElement s = aTopLevel.getSourceElement();
            if (s.getFingerprint() != 198) continue;
            return true;
        }
        return false;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public void setNeedsDynamicOutputProperties(boolean b) {
        this.needsDynamicOutputProperties = b;
    }

    public Declaration getCharacterMap(StructuredQName name) {
        for (int i = this.topLevel.size() - 1; i >= 0; --i) {
            XSLCharacterMap t;
            Declaration decl = (Declaration)this.topLevel.get(i);
            if (!(decl.getSourceElement() instanceof XSLCharacterMap) || !(t = (XSLCharacterMap)decl.getSourceElement()).getCharacterMapName().equals(name)) continue;
            return decl;
        }
        return null;
    }

    public void allocatePatternSlots(int n) {
        if (n > this.largestPatternStackFrame) {
            this.largestPatternStackFrame = n;
        }
    }

    protected void compileError(String message, String errorCode) throws XPathException {
        XPathException tce = new XPathException(message);
        tce.setErrorCode(errorCode);
        this.compileError(tce);
    }

    protected void compileError(XPathException error) throws XPathException {
        error.setIsStaticError(true);
        PreparedStylesheet pss = this.getPreparedStylesheet();
        try {
            if (pss == null) {
                throw error;
            }
            pss.reportError(error);
        }
        catch (TransformerException err2) {
            throw XPathException.makeXPathException(err2);
        }
    }
}

