/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.syntax;

import java.awt.event.ActionEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.action.SquirrelAction;
import net.sourceforge.squirrel_sql.client.session.ISQLEntryPanel;
import net.sourceforge.squirrel_sql.client.session.ISQLPanelAPI;
import net.sourceforge.squirrel_sql.client.session.action.ISQLPanelAction;
import net.sourceforge.squirrel_sql.fw.util.IResources;
import net.sourceforge.squirrel_sql.plugins.syntax.SyntaxPluginResources;

public class DuplicateLineAction
extends SquirrelAction
implements ISQLPanelAction {
    private static final long serialVersionUID = 1L;
    private transient ISQLPanelAPI _panel;
    private ISQLEntryPanel _isqlEntryPanel;

    public DuplicateLineAction(IApplication app, SyntaxPluginResources rsrc) throws IllegalArgumentException {
        super(app, (IResources)rsrc);
    }

    public DuplicateLineAction(IApplication app, SyntaxPluginResources rsrc, ISQLEntryPanel isqlEntryPanel) {
        this(app, rsrc);
        this._isqlEntryPanel = isqlEntryPanel;
    }

    public void actionPerformed(ActionEvent evt) {
        if (null != this._isqlEntryPanel) {
            this.duplicateLineAction(this._isqlEntryPanel);
        } else if (null != this._panel) {
            this.duplicateLineAction(this._panel.getSQLEntryPanel());
        }
    }

    private void duplicateLineAction(ISQLEntryPanel sqlEntryPanel) {
        try {
            String selectedText = sqlEntryPanel.getSelectedText();
            if (null != selectedText && 0 < selectedText.length()) {
                JTextComponent txtComp = sqlEntryPanel.getTextComponent();
                int selectionEnd = sqlEntryPanel.getSelectionEnd();
                txtComp.getDocument().insertString(selectionEnd, selectedText, null);
                sqlEntryPanel.setSelectionStart(selectionEnd);
                sqlEntryPanel.setSelectionEnd(selectionEnd + selectedText.length());
            } else {
                this.duplicateCurrentLine(sqlEntryPanel);
            }
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
    }

    private void duplicateCurrentLine(ISQLEntryPanel sqlEntryPanel) throws BadLocationException {
        JTextComponent txtComp = sqlEntryPanel.getTextComponent();
        int docLen = txtComp.getDocument().getLength();
        String text = txtComp.getDocument().getText(0, txtComp.getDocument().getLength());
        int caretPosition = txtComp.getCaretPosition();
        int lineBeg = 0;
        for (int i = caretPosition - 1; i > 0; --i) {
            if (text.charAt(i) != '\n') continue;
            lineBeg = i;
            break;
        }
        int lineEnd = txtComp.getDocument().getLength();
        for (int i = caretPosition; i < docLen; ++i) {
            if (text.charAt(i) != '\n') continue;
            lineEnd = i;
            break;
        }
        String line = text.substring(lineBeg, lineEnd);
        if (0 == lineBeg) {
            line = line + "\n";
        }
        txtComp.getDocument().insertString(lineBeg, line, null);
    }

    public void setSQLPanel(ISQLPanelAPI panel) {
        this._panel = panel;
    }
}

