/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tinylaf.controlpanel;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class NumericTextField
extends JTextField {
    private Vector listeners;
    private ActionEvent actionEvent;
    private int min;
    private int max;
    private int columns;
    private boolean resistUpdate;

    public NumericTextField(int columns, int value, int min, int max) {
        super(columns);
        this.columns = columns;
        this.min = min;
        this.max = max;
        this.setHorizontalAlignment(4);
        this.setText("" + value);
        this.addKeyListener(new ArrowKeyAction(this, min, max));
        this.actionEvent = new ActionEvent(this, 1001, "");
    }

    public int getValue() {
        if (this.getText().length() == 0) {
            return 0;
        }
        return Integer.parseInt(this.getText());
    }

    public void setValue(int newValue) {
        if (this.resistUpdate) {
            return;
        }
        this.setText(String.valueOf(newValue));
    }

    public void addActionListener(ActionListener l) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        if (this.listeners.contains(l)) {
            return;
        }
        this.listeners.add(l);
    }

    public void removeActionListener(ActionListener l) {
        if (this.listeners == null) {
            return;
        }
        if (!this.listeners.contains(l)) {
            return;
        }
        this.listeners.remove(l);
    }

    public void notifyActionListeners() {
        if (this.listeners == null) {
            return;
        }
        this.resistUpdate = true;
        Iterator ii = ((AbstractList)this.listeners).iterator();
        while (ii.hasNext()) {
            ((ActionListener)ii.next()).actionPerformed(this.actionEvent);
        }
        this.resistUpdate = false;
    }

    protected Document createDefaultModel() {
        return new NumericDocument();
    }

    class KeyInputListener
    implements DocumentListener {
        KeyInputListener() {
        }

        public void changedUpdate(DocumentEvent e) {
        }

        public void insertUpdate(DocumentEvent e) {
            NumericTextField.this.notifyActionListeners();
        }

        public void removeUpdate(DocumentEvent e) {
            NumericTextField.this.notifyActionListeners();
        }
    }

    class ArrowKeyAction
    extends KeyAdapter
    implements ActionListener {
        private JTextField theField;
        private Timer keyTimer;
        private int step;

        ArrowKeyAction(JTextField field, int min, int max) {
            this.theField = field;
            this.keyTimer = new Timer(20, this);
        }

        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 38) {
                this.step = 1;
                if (e.getModifiers() == 1) {
                    this.step = 10;
                }
                this.changeVal();
                this.keyTimer.setInitialDelay(300);
                this.keyTimer.start();
            } else if (e.getKeyCode() == 40) {
                this.step = -1;
                if (e.getModifiers() == 1) {
                    this.step = -10;
                }
                this.changeVal();
                this.keyTimer.setInitialDelay(300);
                this.keyTimer.start();
            }
        }

        public void keyReleased(KeyEvent e) {
            this.keyTimer.stop();
        }

        public void actionPerformed(ActionEvent e) {
            this.changeVal();
        }

        private void changeVal() {
            int val = Integer.parseInt(this.theField.getText()) + this.step;
            if (val > NumericTextField.this.max) {
                val = NumericTextField.this.max;
            } else if (val < NumericTextField.this.min) {
                val = NumericTextField.this.min;
            }
            this.theField.setText("" + val);
        }
    }

    protected class NumericDocument
    extends PlainDocument {
        NumericDocument() {
            this.addDocumentListener(new KeyInputListener());
        }

        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (str == null || str.length() == 0) {
                return;
            }
            if (this.getLength() + str.length() > NumericTextField.this.columns) {
                return;
            }
            if (!this.checkInput(str)) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            String text = this.getText(0, this.getLength());
            text = offs == 0 ? str + text : (offs >= text.length() ? text + str : text.substring(0, offs) + str + text.substring(offs));
            int val = Integer.parseInt(text);
            boolean correct = false;
            if (val < NumericTextField.this.min) {
                val = NumericTextField.this.min;
                correct = true;
            } else if (val > NumericTextField.this.max) {
                val = NumericTextField.this.max;
                correct = true;
            }
            if (correct) {
                this.remove(0, this.getLength());
                super.insertString(0, String.valueOf(val), a);
            } else {
                super.insertString(offs, str, a);
            }
        }

        private boolean checkInput(String s) {
            for (int i = 0; i < s.length(); ++i) {
                if (Character.isDigit(s.charAt(i))) continue;
                return false;
            }
            return true;
        }
    }
}

