/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.refactoring.commands;

import net.sourceforge.squirrel_sql.client.session.ISQLExecuterHandler;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.SQLExecuterTask;
import net.sourceforge.squirrel_sql.client.session.SessionUtils;
import net.sourceforge.squirrel_sql.fw.dialects.DatabaseObjectQualifier;
import net.sourceforge.squirrel_sql.fw.dialects.HibernateDialect;
import net.sourceforge.squirrel_sql.fw.dialects.UserCancelledOperationException;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.refactoring.commands.AbstractRefactoringCommand;
import net.sourceforge.squirrel_sql.plugins.refactoring.gui.RenameTableDialog;

public class RenameTableCommand
extends AbstractRefactoringCommand {
    private final ILogger s_log = LoggerController.createLogger(RenameTableCommand.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(RenameTableCommand.class);
    protected RenameTableDialog customDialog;

    public RenameTableCommand(ISession session, IDatabaseObjectInfo[] dbInfo) {
        super(session, dbInfo);
    }

    @Override
    protected void onExecute() {
        this.showCustomDialog();
    }

    @Override
    protected String[] generateSQLStatements() throws UserCancelledOperationException {
        String result = null;
        try {
            DatabaseObjectQualifier qualifier = new DatabaseObjectQualifier(this._info[0].getCatalogName(), this._info[0].getSchemaName());
            result = this._dialect.getRenameTableSQL(this._info[0].getSimpleName(), this.customDialog.getNewSimpleName(), qualifier, this._sqlPrefs);
        }
        catch (UnsupportedOperationException e2) {
            this._session.showMessage(s_stringMgr.getString("RenameTableCommand.unsupportedOperationMsg", new Object[]{this._dialect.getDisplayName()}));
        }
        return new String[]{result};
    }

    @Override
    protected void executeScript(String script) {
        AbstractRefactoringCommand.CommandExecHandler handler = new AbstractRefactoringCommand.CommandExecHandler(this._session);
        SQLExecuterTask executer = new SQLExecuterTask(this._session, script, (ISQLExecuterHandler)handler);
        executer.run();
        this._session.getApplication().getThreadPool().addTask(new Runnable(){

            @Override
            public void run() {
                GUIUtils.processOnSwingEventThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        RenameTableCommand.this.customDialog.setVisible(false);
                        RenameTableCommand.this.customDialog.dispose();
                        RenameTableCommand.this._session.getSchemaInfo().reloadAll();
                    }
                });
            }
        });
    }

    @Override
    protected boolean isRefactoringSupportedForDialect(HibernateDialect dialectExt) {
        return dialectExt.supportsRenameTable();
    }

    private void showCustomDialog() {
        this._session.getApplication().getThreadPool().addTask(new Runnable(){

            @Override
            public void run() {
                GUIUtils.processOnSwingEventThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        RenameTableCommand.this.customDialog = new RenameTableDialog(RenameTableCommand.this._info, 2, SessionUtils.getOwningFrame((ISession)RenameTableCommand.this._session));
                        RenameTableCommand.this.customDialog.addExecuteListener(new AbstractRefactoringCommand.ExecuteListener());
                        RenameTableCommand.this.customDialog.addEditSQLListener(new AbstractRefactoringCommand.EditSQLListener(RenameTableCommand.this.customDialog));
                        RenameTableCommand.this.customDialog.addShowSQLListener(new AbstractRefactoringCommand.ShowSQLListener(i18n.SHOWSQL_DIALOG_TITLE, RenameTableCommand.this.customDialog));
                        RenameTableCommand.this.customDialog.setLocationRelativeTo(SessionUtils.getOwningFrame((ISession)RenameTableCommand.this._session));
                        RenameTableCommand.this.customDialog.setVisible(true);
                    }
                });
            }
        });
    }

    static /* synthetic */ StringManager access$000() {
        return s_stringMgr;
    }

    static interface i18n {
        public static final String SHOWSQL_DIALOG_TITLE = RenameTableCommand.access$000().getString("RenameTableCommand.sqlDialogTitle");
    }
}

