/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.analysis;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import org.opensolaris.opengrok.analysis.FileAnalyzer;
import org.opensolaris.opengrok.analysis.FileAnalyzerFactory;

public abstract class TextAnalyzer
extends FileAnalyzer {
    public TextAnalyzer(FileAnalyzerFactory factory) {
        super(factory);
    }

    protected Reader getReader(InputStream stream) throws IOException {
        InputStream in = stream.markSupported() ? stream : new BufferedInputStream(stream);
        String charset = null;
        in.mark(3);
        byte[] head = new byte[3];
        int br = in.read(head, 0, 3);
        if (br >= 2 && head[0] == -2 && head[1] == -1 || head[0] == -1 && head[1] == -2) {
            charset = "UTF-16";
            in.reset();
        } else if (br >= 3 && head[0] == -17 && head[1] == -69 && head[2] == -65) {
            charset = "UTF-8";
        }
        if (charset == null) {
            in.reset();
            charset = Charset.defaultCharset().name();
        }
        return new InputStreamReader(in, charset);
    }
}

