/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.configuration;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.opensolaris.opengrok.configuration.RuntimeEnvironment;

public class Project {
    private String path;
    private String description;
    private int tabSize;

    public String getDescription() {
        return this.description;
    }

    public String getPath() {
        return this.path;
    }

    public String getId() {
        return this.path;
    }

    public int getTabSize() {
        return this.tabSize;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setTabSize(int tabSize) {
        this.tabSize = tabSize;
    }

    public boolean hasTabSizeSetting() {
        return this.tabSize > 0;
    }

    public static Project getProject(String path) {
        RuntimeEnvironment env;
        Project ret = null;
        String lpath = path;
        if (File.separatorChar != '/') {
            lpath = path.replace(File.separatorChar, '/');
        }
        if ((env = RuntimeEnvironment.getInstance()).hasProjects()) {
            for (Project proj : env.getProjects()) {
                if (lpath.indexOf(proj.getPath()) != 0) continue;
                ret = proj;
            }
        }
        return ret;
    }

    public static Project getProject(File file) {
        Project ret = null;
        try {
            ret = Project.getProject(RuntimeEnvironment.getInstance().getPathRelativeToSourceRoot(file, 0));
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ret;
    }

    public static Project getByDescription(String desc) {
        Project ret = null;
        RuntimeEnvironment env = RuntimeEnvironment.getInstance();
        if (env.hasProjects()) {
            for (Project proj : env.getProjects()) {
                if (desc.indexOf(proj.getDescription()) != 0) continue;
                ret = proj;
            }
        }
        return ret;
    }
}

