/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jrcs.rcs;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.jrcs.diff.PatchFailedException;
import org.apache.commons.jrcs.rcs.InvalidFileFormatException;
import org.apache.commons.jrcs.rcs.Lines;
import org.apache.commons.jrcs.rcs.Node;
import org.apache.commons.jrcs.rcs.NodeNotFoundException;
import org.apache.commons.jrcs.rcs.TrunkNode;

class Path {
    private List path = new LinkedList();

    public void add(Node node) {
        this.path.add(node);
    }

    public int size() {
        return this.path.size();
    }

    public Node last() {
        if (this.size() == 0) {
            return null;
        }
        return (Node)this.path.get(this.size() - 1);
    }

    public List patch() throws InvalidFileFormatException, PatchFailedException, NodeNotFoundException {
        return this.patch(false);
    }

    public List patch(boolean bl) throws InvalidFileFormatException, PatchFailedException, NodeNotFoundException {
        return this.patch(new Lines(), bl);
    }

    public List patch(List list) throws InvalidFileFormatException, PatchFailedException, NodeNotFoundException {
        return this.patch(list, false);
    }

    public List patch(List list, boolean bl) throws InvalidFileFormatException, PatchFailedException, NodeNotFoundException {
        Iterator iterator = this.path.iterator();
        TrunkNode trunkNode = (TrunkNode)iterator.next();
        trunkNode.patch0(list, bl);
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            node.patch(list, bl);
        }
        return list;
    }

    public List newpatch(List list, boolean bl) throws InvalidFileFormatException, PatchFailedException {
        if (!bl) {
            Iterator iterator = this.path.iterator();
            TrunkNode trunkNode = (TrunkNode)iterator.next();
            trunkNode.patch0(list, false);
            while (iterator.hasNext()) {
                Node node = (Node)iterator.next();
                node.patch(list, false);
            }
        } else {
            Object object;
            ListIterator listIterator = this.path.listIterator();
            Node node = (Node)listIterator.next();
            Node node2 = node.root();
            ((TrunkNode)node).newpatch0(list, node2);
            while (listIterator.hasNext()) {
                object = (Node)listIterator.next();
                if (((Node)object).version.isBranch()) {
                    listIterator.previous();
                    break;
                }
                node = object;
                node.newpatch(list, false, node2);
            }
            if (node2 != node) {
                try {
                    object = node.rcsnext.pathTo(node2.version);
                    LinkedList linkedList = new LinkedList(list);
                    Iterator iterator = ((Path)object).path.iterator();
                    while (iterator.hasNext()) {
                        Node node3 = (Node)iterator.next();
                        node3.newpatch(linkedList, true, node2);
                    }
                }
                catch (NodeNotFoundException nodeNotFoundException) {
                    // empty catch block
                }
            }
            while (listIterator.hasNext()) {
                node = (Node)listIterator.next();
                node.newpatch(list, false, node);
            }
        }
        return list;
    }
}

