/*
 * This file is part of the TYPO3 CMS project.
 *
 * It is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, either version 2
 * of the License, or any later version.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * The TYPO3 project - inspiring people to share!
 */
import{LitElement as f,html as d,nothing as c}from"lit";import{property as y,state as g,customElement as b}from"lit/decorators.js";import{until as h}from"lit/directives/until.js";import"@typo3/backend/element/icon-element.js";import{copyToClipboard as v}from"@typo3/backend/copy-to-clipboard.js";import $ from"@typo3/backend/notification.js";import{lll as m}from"@typo3/core/lit-helper.js";import{markdown as w}from"@typo3/core/directive/markdown.js";import A from"@typo3/core/ajax/ajax-request.js";import{SettingsMode as u,sanitizeSettingsMode as E}from"@typo3/backend/settings/enum/settings-mode.enum.js";var l=function(p,e,t,i){var s=arguments.length,o=s<3?e:i===null?i=Object.getOwnPropertyDescriptor(e,t):i,n;if(typeof Reflect=="object"&&typeof Reflect.decorate=="function")o=Reflect.decorate(p,e,t,i);else for(var r=p.length-1;r>=0;r--)(n=p[r])&&(o=(s<3?n(o):s>3?n(e,t,o):n(e,t))||o);return s>3&&o&&Object.defineProperty(e,t,o),o};let a=class extends f{constructor(){super(...arguments),this.mode=u.basic,this.hasChange=!1,this.typeElement=null}createRenderRoot(){return this}render(){const{value:e,systemDefault:t,definition:i}=this.setting;return d`<div class=${`settings-item settings-item-${i.type} ${this.hasChange?"has-change":""}`} tabindex=0 data-status=${JSON.stringify(e)===JSON.stringify(t)?"none":"modified"}><div class=settings-item-indicator></div><div class=settings-item-title><label for=${`setting-${i.key}`} class=settings-item-label>${i.label}</label><div class=settings-item-description>${w(i.description??"","minimal")}</div>${this.mode===u.advanced?d`<div class=settings-item-key>${i.key}</div>`:c}</div><div class=settings-item-control>${h(this.renderField(),c)}</div><div class=settings-item-message></div><div class=settings-item-actions>${this.renderActions()}</div></div>`}renderField(){return this.typeElement!==null?(this.updateFieldAttributes(this.typeElement),this.typeElement):(async()=>{const{typeImplementation:e}=this.setting,t=await import(e);if(!("componentName"in t))throw new Error(`module ${e} is missing the "componentName" export`);const i=document.createElement(t.componentName);return i.addEventListener("typo3:setting:changed",s=>{this.hasChange=JSON.stringify(this.setting.value)!==JSON.stringify(s.detail.value)}),this.updateFieldAttributes(i),this.typeElement=i,i})()}updateFieldAttributes(e){const{definition:t,value:i}=this.setting,s=Object.entries(t.enum||{}),o={key:t.key,formid:`setting-${t.key}`,name:`settings[${t.key}]`,value:Array.isArray(i)?JSON.stringify(i):String(i),debug:this.mode===u.advanced,readonly:t.readonly,enum:s.length>0?JSON.stringify(Object.fromEntries(s)):!1,default:Array.isArray(t.default)?JSON.stringify(t.default):String(t.default),options:t.options?Array.isArray(t.options)&&t.options.length===0?"{}":JSON.stringify(t.options):"{}"};for(const[n,r]of Object.entries(o)){if(typeof r=="boolean"){r&&!e.hasAttribute(n)&&e.setAttribute(n,""),!r&&e.hasAttribute(n)&&e.removeAttribute(n);continue}e.getAttribute(n)!==r&&e.setAttribute(n,r)}}renderActions(){const{definition:e}=this.setting;return d`<div class=dropdown><button class=dropdown-toggle type=button data-bs-toggle=dropdown aria-expanded=false><typo3-backend-icon identifier=actions-cog size=small></typo3-backend-icon><span class=visually-hidden>More actions</span></button><ul class=dropdown-menu><li><button class="dropdown-item dropdown-item-spaced" type=button ?disabled=${e.readonly} @click=${()=>this.setToDefaultValue()}><typo3-backend-icon identifier=actions-undo size=small></typo3-backend-icon>${m("settingseditor.edit.resetSetting")}</button></li>${this.mode===u.advanced?d`<li><hr class=dropdown-divider></li><li><typo3-copy-to-clipboard text=${e.key} class="dropdown-item dropdown-item-spaced"><typo3-backend-icon identifier=actions-clipboard size=small></typo3-backend-icon>${m("settingseditor.edit.copySettingsIdentifier")}</typo3-copy-to-clipboard></li>${this.dumpuri?d`<li><button class="dropdown-item dropdown-item-spaced" type=button @click=${()=>this.copyAsYaml()}><typo3-backend-icon identifier=actions-clipboard-paste size=small></typo3-backend-icon>${m("settingseditor.edit.copyAsYaml")}</button></li>`:c}`:c}</ul></div>`}setToDefaultValue(){this.typeElement&&(this.typeElement.value=this.setting.systemDefault,this.typeElement.requestUpdate("value"))}async copyAsYaml(){const e=new FormData(this.typeElement.form),t=`settings[${this.setting.definition.key}]`,i=e.get(t),s=new FormData;s.append("specificSetting",this.setting.definition.key),s.append(t,i);const n=await(await new A(this.dumpuri).post(s)).resolve();typeof n.yaml=="string"?v(n.yaml):(console.warn("Value can not be copied to clipboard.",typeof n.yaml),$.error(m("copyToClipboard.error")))}};l([y({type:Object})],a.prototype,"setting",void 0),l([y({type:String})],a.prototype,"dumpuri",void 0),l([y({type:String,converter:E})],a.prototype,"mode",void 0),l([g()],a.prototype,"hasChange",void 0),a=l([b("typo3-backend-editable-setting")],a);export{a as EditableSettingElement};
