from typing import TypedDict


class RequestHeader(TypedDict):
    section: str
    name: str
    description: str
    experimental: bool
    url: str


REQUEST_HEADERS: list[RequestHeader] = [
    {
        "section": "Authentication",
        "name": "Authorization",
        "description": "Contains the credentials to authenticate a user-agent with a server.",
        "experimental": False,
        "url": "/en-US/docs/Web/HTTP/Headers/Authorization",
    },
    {
        "section": "Authentication",
        "name": "Proxy-Authorization",
        "description": "Contains the credentials to authenticate a user agent with a proxy server.",
        "experimental": False,
        "url": "/en-US/docs/Web/HTTP/Headers/Proxy-Authorization",
    },
    {
        "section": "Caching",
        "name": "Cache-Control",
        "description": "Directives for caching mechanisms in both requests and responses.",
        "experimental": False,
        "url": "/en-US/docs/Web/HTTP/Headers/Cache-Control",
    },
    {
        "section": "Conditionals",
        "name": "If-Match",
        "description": "Makes the request conditional, and applies the method only if the stored resource matches one of the given ETags.",
        "experimental": False,
        "url": "/en-US/docs/Web/HTTP/Headers/If-Match",
    },
    {
        "section": "Conditionals",
        "name": "If-None-Match",
        "description": "Makes the request conditional, and applies the method only if the stored resource doesn't match any of the given ETags. This is used to update caches (for safe requests), or to prevent uploading a new resource when one already exists.",
        "experimental": False,
        "url": "/en-US/docs/Web/HTTP/Headers/If-None-Match",
    },
    {
        "section": "Conditionals",
        "name": "If-Modified-Since",
        "description": "Makes the request conditional, and expects the resource to be transmitted only if it has been modified after the given date. This is used to transmit data only when the cache is out of date.",
        "experimental": False,
        "url": "/en-US/docs/Web/HTTP/Headers/If-Modified-Since",
    },
    {
        "section": "Conditionals",
        "name": "If-Unmodified-Since",
        "description": "Makes the request conditional, and expects the resource to be transmitted only if it has not been modified after the given date. This ensures the coherence of a new fragment of a specific range with previous ones, or to implement an optimistic concurrency control system when modifying existing documents.",
        "experimental": False,
        "url": "/en-US/docs/Web/HTTP/Headers/If-Unmodified-Since",
    },
    {
        "section": "Connection management",
        "name": "Connection",
        "description": "Controls whether the network connection stays open after the current transaction finishes.",
        "experimental": False,
        "url": "/en-US/docs/Web/HTTP/Headers/Connection",
    },
    {
        "section": "Connection management",
        "name": "Keep-Alive",
        "description": "Controls how long a persistent connection should stay open.",
        "experimental": False,
        "url": "/en-US/docs/Web/HTTP/Headers/Keep-Alive",
    },
    {
        "section": "Content negotiation",
        "name": "Accept",
        "description": "Informs the server about the types of data that can be sent back.",
        "experimental": False,
        "url": "/en-US/docs/Web/HTTP/Headers/Accept",
    },
    {
        "section": "Content negotiation",
        "name": "Accept-Encoding",
        "description": "The encoding algorithm, usually a compression algorithm, that can be used on the resource sent back.",
        "experimental": False,
        "url": "/en-US/docs/Web/HTTP/Headers/Accept-Encoding",
    },
    {
        "section": "Content negotiation",
        "name": "Accept-Language",
        "description": "Informs the server about the human language the server is expected to send back. This is a hint and is not necessarily under the full control of the user: the server should always pay attention not to override an explicit user choice (like selecting a language from a dropdown).",
        "experimental": False,
        "url": "/en-US/docs/Web/HTTP/Headers/Accept-Language",
    },
    {
        "section": "Controls",
        "name": "Expect",
        "description": "Indicates expectations that need to be fulfilled by the server to properly handle the request.",
        "experimental": False,
        "url": "/en-US/docs/Web/HTTP/Headers/Expect",
    },
    {
        "section": "Controls",
        "name": "Max-Forwards",
        "description": "When using TRACE, indicates the maximum number of hops the request can do before being reflected to the sender.",
        "experimental": False,
        "url": "/en-US/docs/Web/HTTP/Headers/Max-Forwards",
    },
    {
        "section": "Cookies",
        "name": "Cookie",
        "description": "Contains stored HTTP cookies previously sent by the server with the Set-Cookie header.",
        "experimental": False,
        "url": "/en-US/docs/Web/HTTP/Headers/Cookie",
    },
    {
        "section": "CORS",
        "name": "Access-Control-Request-Headers",
        "description": "Used when issuing a preflight request to let the server know which HTTP headers will be used when the actual request is made.",
        "experimental": False,
        "url": "/en-US/docs/Web/HTTP/Headers/Access-Control-Request-Headers",
    },
    {
        "section": "CORS",
        "name": "Access-Control-Request-Method",
        "description": "Used when issuing a preflight request to let the server know which HTTP method will be used when the actual request is made.",
        "experimental": False,
        "url": "/en-US/docs/Web/HTTP/Headers/Access-Control-Request-Method",
    },
    {
        "section": "CORS",
        "name": "Origin",
        "description": "Indicates where a fetch originates from.",
        "experimental": False,
        "url": "/en-US/docs/Web/HTTP/Headers/Origin",
    },
    {
        "section": "Message body information",
        "name": "Content-Length",
        "description": "The size of the resource, in decimal number of bytes.",
        "experimental": False,
        "url": "/en-US/docs/Web/HTTP/Headers/Content-Length",
    },
    {
        "section": "Message body information",
        "name": "Content-Type",
        "description": "Indicates the media type of the resource.",
        "experimental": False,
        "url": "/en-US/docs/Web/HTTP/Headers/Content-Type",
    },
    {
        "section": "Message body information",
        "name": "Content-Encoding",
        "description": "Used to specify the compression algorithm.",
        "experimental": False,
        "url": "/en-US/docs/Web/HTTP/Headers/Content-Encoding",
    },
    {
        "section": "Message body information",
        "name": "Content-Language",
        "description": "Describes the human language(s) intended for the audience, so that it allows a user to differentiate according to the users' own preferred language.",
        "experimental": False,
        "url": "/en-US/docs/Web/HTTP/Headers/Content-Language",
    },
    {
        "section": "Message body information",
        "name": "Content-Location",
        "description": "Indicates an alternate location for the returned data.",
        "experimental": False,
        "url": "/en-US/docs/Web/HTTP/Headers/Content-Location",
    },
    {
        "section": "Proxies",
        "name": "Forwarded",
        "description": "Contains information from the client-facing side of proxy servers that is altered or lost when a proxy is involved in the path of the request.",
        "experimental": False,
        "url": "/en-US/docs/Web/HTTP/Headers/Forwarded",
    },
    {
        "section": "Proxies",
        "name": "Via",
        "description": "Added by proxies, both forward and reverse proxies, and can appear in the request headers and the response headers.",
        "experimental": False,
        "url": "/en-US/docs/Web/HTTP/Headers/Via",
    },
    {
        "section": "Request context",
        "name": "From",
        "description": "Contains an Internet email address for a human user who controls the requesting user agent.",
        "experimental": False,
        "url": "/en-US/docs/Web/HTTP/Headers/From",
    },
    {
        "section": "Request context",
        "name": "Host",
        "description": "Specifies the domain name of the server (for virtual hosting), and (optionally) the TCP port number on which the server is listening.",
        "experimental": False,
        "url": "/en-US/docs/Web/HTTP/Headers/Host",
    },
    {
        "section": "Request context",
        "name": "Referer",
        "description": "The address of the previous web page from which a link to the currently requested page was followed.",
        "experimental": False,
        "url": "/en-US/docs/Web/HTTP/Headers/Referer",
    },
    {
        "section": "Request context",
        "name": "User-Agent",
        "description": "Contains a characteristic string that allows the network protocol peers to identify the application type, operating system, software vendor or software version of the requesting software user agent.",
        "experimental": False,
        "url": "/en-US/docs/Web/HTTP/Headers/User-Agent",
    },
    {
        "section": "Range requests",
        "name": "Range",
        "description": "Indicates the part of a document that the server should return.",
        "experimental": False,
        "url": "/en-US/docs/Web/HTTP/Headers/Range",
    },
    {
        "section": "Range requests",
        "name": "If-Range",
        "description": "Creates a conditional range request that is only fulfilled if the given etag or date matches the remote resource. Used to prevent downloading two ranges from incompatible version of the resource.",
        "experimental": False,
        "url": "/en-US/docs/Web/HTTP/Headers/If-Range",
    },
    {
        "section": "Security",
        "name": "Upgrade-Insecure-Requests",
        "description": "Sends a signal to the server expressing the client's preference for an encrypted and authenticated response, and that it can successfully handle the upgrade-insecure-requests directive.",
        "experimental": False,
        "url": "/en-US/docs/Web/HTTP/Headers/Upgrade-Insecure-Requests",
    },
    {
        "section": "Transfer coding",
        "name": "Transfer-Encoding",
        "description": "Specifies the form of encoding used to safely transfer the resource to the user.",
        "experimental": False,
        "url": "/en-US/docs/Web/HTTP/Headers/Transfer-Encoding",
    },
    {
        "section": "Transfer coding",
        "name": "TE",
        "description": "Specifies the transfer encodings the user agent is willing to accept.",
        "experimental": False,
        "url": "/en-US/docs/Web/HTTP/Headers/TE",
    },
    {
        "section": "Transfer coding",
        "name": "Trailer",
        "description": "Allows the sender to include additional fields at the end of chunked message.",
        "experimental": False,
        "url": "/en-US/docs/Web/HTTP/Headers/Trailer",
    },
    {
        "section": "Other",
        "name": "Alt-Used",
        "description": "Used to identify the alternative service in use.",
        "experimental": False,
        "url": "/en-US/docs/Web/HTTP/Headers/Alt-Used",
    },
    {
        "section": "Other",
        "name": "Date",
        "description": "Contains the date and time at which the message was originated.",
        "experimental": False,
        "url": "/en-US/docs/Web/HTTP/Headers/Date",
    },
    {
        "section": "Other",
        "name": "Link",
        "description": "This entity-header field provides a means for serializing one or more links in HTTP headers. It is semantically equivalent to the HTML <link> element.",
        "experimental": False,
        "url": "/en-US/docs/Web/HTTP/Headers/Link",
    },
    {
        "section": "Non-standard headers",
        "name": "X-Forwarded-For",
        "description": "Identifies the originating IP addresses of a client connecting to a web server through an HTTP proxy or a load balancer.",
        "experimental": False,
        "url": "/en-US/docs/Web/HTTP/Headers/X-Forwarded-For",
    },
    {
        "section": "Non-standard headers",
        "name": "X-Forwarded-Host",
        "description": "Identifies the original host requested that a client used to connect to your proxy or load balancer.",
        "experimental": False,
        "url": "/en-US/docs/Web/HTTP/Headers/X-Forwarded-Host",
    },
    {
        "section": "Non-standard headers",
        "name": "X-Forwarded-Proto",
        "description": "Identifies the protocol (HTTP or HTTPS) that a client used to connect to your proxy or load balancer.",
        "experimental": False,
        "url": "/en-US/docs/Web/HTTP/Headers/X-Forwarded-Proto",
    },
    {
        "section": "Deprecated headers",
        "name": "Pragma",
        "description": "Implementation-specific header that may have various effects anywhere along the request-response chain. Used for backwards compatibility with HTTP/1.0 caches where the Cache-Control header is not yet present.",
        "experimental": False,
        "url": "/en-US/docs/Web/HTTP/Headers/Pragma",
    },
    {
        "section": "Experimental headers",
        "name": "Origin-Isolation",
        "description": "Provides a mechanism to allow web applications to isolate their origins.",
        "experimental": True,
        "url": "/en-US/docs/Web/HTTP/Headers/Origin-Isolation",
    },
    {
        "section": "Experimental headers",
        "name": "Accept-Push-Policy",
        "description": "A client can express the desired push policy for a request by sending an Accept-Push-Policy header field in the request.",
        "experimental": True,
        "url": "/en-US/docs/Web/HTTP/Headers/Accept-Push-Policy",
    },
    {
        "section": "Experimental headers",
        "name": "Accept-Signature",
        "description": "A client can send the Accept-Signature header field to indicate intention to take advantage of any available signatures and to indicate what kinds of signatures it supports.",
        "experimental": True,
        "url": "/en-US/docs/Web/HTTP/Headers/Accept-Signature",
    },
    {
        "section": "Experimental headers",
        "name": "Early-Data",
        "description": "Indicates that the request has been conveyed in TLS early data.",
        "experimental": True,
        "url": "/en-US/docs/Web/HTTP/Headers/Early-Data",
    },
    {
        "section": "Experimental headers",
        "name": "Signature",
        "description": "The Signature header field conveys a list of signatures for an exchange, each one accompanied by information about how to determine the authority of and refresh that signature.",
        "experimental": True,
        "url": "/en-US/docs/Web/HTTP/Headers/Signature",
    },
    {
        "section": "Experimental headers",
        "name": "Signed-Headers",
        "description": "The Signed-Headers header field identifies an ordered list of response header fields to include in a signature.",
        "experimental": True,
        "url": "/en-US/docs/Web/HTTP/Headers/Signed-Headers",
    },
    {
        "section": "Privacy",
        "name": "Sec-GPC",
        "description": "Indicates whether the user consents to a website or service selling or sharing their personal information with third parties.",
        "experimental": True,
        "url": "/en-US/docs/Web/HTTP/Headers/Sec-GPC",
    },
    {
        "section": "Content negotiation",
        "name": "Accept-Charset",
        "description": "Indicates which character encodings the client can understand.",
        "experimental": False,
        "url": "/en-US/docs/Web/HTTP/Headers/Accept-Charset",
    },
    {
        "section": "Privacy",
        "name": "DNT",
        "description": "Expresses the user's tracking preference.",
        "experimental": False,
        "url": "/en-US/docs/Web/HTTP/Headers/DNT",
    },
    {
        "section": "Controls",
        "name": "Upgrade",
        "description": "Requests an upgrade to a different protocol.",
        "experimental": False,
        "url": "/en-US/docs/Web/HTTP/Headers/Upgrade",
    },
    {
        "section": "Security",
        "name": "Sec-Fetch-Site",
        "description": "Indicates the relationship between the request initiator's origin and the resource's origin.",
        "experimental": False,
        "url": "/en-US/docs/Web/HTTP/Headers/Sec-Fetch-Site",
    },
    {
        "section": "Security",
        "name": "Sec-Fetch-Mode",
        "description": "Indicates the mode of the request.",
        "experimental": False,
        "url": "/en-US/docs/Web/HTTP/Headers/Sec-Fetch-Mode",
    },
    {
        "section": "Security",
        "name": "Sec-Fetch-User",
        "description": "Indicates whether a navigation request was triggered by user activation.",
        "experimental": False,
        "url": "/en-US/docs/Web/HTTP/Headers/Sec-Fetch-User",
    },
    {
        "section": "Security",
        "name": "Sec-Fetch-Dest",
        "description": "Indicates the destination of the request.",
        "experimental": False,
        "url": "/en-US/docs/Web/HTTP/Headers/Sec-Fetch-Dest",
    },
    {
        "section": "Service Workers",
        "name": "Service-Worker-Navigation-Preload",
        "description": "Allows a service worker to request navigation preloads.",
        "experimental": False,
        "url": "/en-US/docs/Web/HTTP/Headers/Service-Worker-Navigation-Preload",
    },
]
