/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.swing.plugins.online;

import java.awt.event.ActionEvent;
import java.util.EnumSet;
import javax.swing.AbstractAction;
import javax.swing.SwingWorker;
import org.diylc.common.EventType;
import org.diylc.common.IPlugIn;
import org.diylc.common.IPlugInPort;
import org.diylc.images.IconLoader;
import org.diylc.swing.gui.DialogFactory;
import org.diylc.swing.plugins.online.presenter.LibraryPresenter;
import org.diylc.swing.plugins.online.view.LoginDialog;
import org.diylc.swing.plugins.online.view.NewUserDialog;
import org.diylc.swing.plugins.online.view.UploadDialog;
import org.diylc.swingframework.ProgressDialog;

public class OnlineManager
implements IPlugIn {
    private static final String ONLINE_TITLE = "Online";
    private IPlugInPort plugInPort;
    private LibraryPresenter libraryPresenter;

    public void connect(IPlugInPort iPlugInPort) {
        this.plugInPort = iPlugInPort;
        this.libraryPresenter = new LibraryPresenter();
        this.initialize();
    }

    private void initialize() {
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                OnlineManager.this.libraryPresenter.connectDb();
                return null;
            }

            @Override
            protected void done() {
                if (OnlineManager.this.libraryPresenter.isLoggedIn()) {
                    // empty if block
                }
            }
        };
        swingWorker.execute();
    }

    public EnumSet<EventType> getSubscribedEventTypes() {
        return null;
    }

    public void processMessage(EventType eventType, Object ... objectArray) {
    }

    class ManageProjectsAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public ManageProjectsAction() {
            this.putValue("Name", "Manage Projects");
            this.putValue("SmallIcon", IconLoader.Wrench.getIcon());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ProgressDialog progressDialog = DialogFactory.getInstance().createProgressDialog("Test", new String[0], "Some text", false);
            progressDialog.setVisible(true);
        }
    }

    class UploadAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public UploadAction() {
            this.putValue("Name", "Upload Project");
            this.putValue("SmallIcon", IconLoader.Upload.getIcon());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            UploadDialog uploadDialog = DialogFactory.getInstance().createUploadDialog();
            uploadDialog.setVisible(true);
        }
    }

    class CreateAccountAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public CreateAccountAction() {
            this.putValue("Name", "Create New Account");
            this.putValue("SmallIcon", IconLoader.IdCardAdd.getIcon());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            NewUserDialog newUserDialog = DialogFactory.getInstance().createNewUserDialog();
            newUserDialog.setVisible(true);
        }
    }

    class LoginAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public LoginAction() {
            this.putValue("Name", "Log in");
            this.putValue("SmallIcon", IconLoader.IdCard.getIcon());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LoginDialog loginDialog = DialogFactory.getInstance().createLoginDialog();
            loginDialog.setVisible(true);
        }
    }

    class LibraryAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public LibraryAction() {
            this.putValue("Name", "Browse Library");
            this.putValue("SmallIcon", IconLoader.Chest.getIcon());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
        }
    }
}

