/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.InvalidArgumentCombination;
import com.amazon.aes.webservices.client.cmd.Outputter;
import org.apache.commons.cli.Options;

public class DeletePlacementGroup
extends BaseCmd {
    public DeletePlacementGroup(String[] args) {
        super("ec2delpgrp", "ec2-delete-placement-group");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    protected String getOptionString() {
        return "GROUP_NAME";
    }

    private Options getOptions() {
        Options options = new Options();
        return options;
    }

    public void printDescription() {
        super.printDescription();
        System.out.println("     Deletes a placement group with the name GROUP_NAME");
    }

    public void printOptions() {
        super.printOptions(false);
    }

    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        this.validateParameters();
        String groupName = this.getPlacementGroupName();
        RequestResultPair rsp = jec2.deletePlacementGroup(groupName);
        out.outputPlacementGroup(System.out, groupName, "deleted");
        out.printRequestId(System.out, (RequestResult)rsp);
        return true;
    }

    protected void validateParameters() {
    }

    protected void parseOpts(String[] args) {
        super.parseOpts(args);
    }

    public static void main(String[] args) {
        new DeletePlacementGroup(args).invoke();
    }

    protected String getPlacementGroupName() {
        String[] groupNames = this.getNonOptions();
        if (groupNames.length == 0) {
            throw new InvalidArgumentCombination("A placement group must be specified");
        }
        if (groupNames.length > 1) {
            throw new InvalidArgumentCombination("Only one placement group may be specified.");
        }
        return groupNames[0];
    }
}

