/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.Serializable;
import java.util.concurrent.CountDownLatch;
import kafka.api.FetchRequest;
import kafka.api.FetchRequestBuilder;
import kafka.api.FetchResponse;
import kafka.api.FetchResponsePartitionData;
import kafka.api.FetchResponsePartitionData$;
import kafka.api.Request$;
import kafka.cluster.BrokerEndPoint;
import kafka.common.TopicAndPartition;
import kafka.consumer.SimpleConsumer;
import kafka.message.ByteBufferMessageSet;
import kafka.message.MessageSet$;
import kafka.tools.ReplicaBuffer;
import kafka.tools.ReplicaVerificationTool$;
import kafka.utils.ShutdownableThread;
import kafka.utils.ShutdownableThread$;
import org.apache.kafka.common.protocol.Errors;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001i4A!\u0001\u0002\u0005\u000f\tq!+\u001a9mS\u000e\fg)\u001a;dQ\u0016\u0014(BA\u0002\u0005\u0003\u0015!xn\u001c7t\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0003\u0001!\u0001\"!\u0003\u0007\u000e\u0003)Q!a\u0003\u0003\u0002\u000bU$\u0018\u000e\\:\n\u00055Q!AE*ikR$wn\u001e8bE2,G\u000b\u001b:fC\u0012D\u0011b\u0004\u0001\u0003\u0002\u0003\u0006I\u0001E\u000f\u0002\t9\fW.\u001a\t\u0003#iq!A\u0005\r\u0011\u0005M1R\"\u0001\u000b\u000b\u0005U1\u0011A\u0002\u001fs_>$hHC\u0001\u0018\u0003\u0015\u00198-\u00197b\u0013\tIb#\u0001\u0004Qe\u0016$WMZ\u0005\u00037q\u0011aa\u0015;sS:<'BA\r\u0017\u0013\tyA\u0002\u0003\u0005 \u0001\t\u0005\t\u0015!\u0003!\u00031\u0019x.\u001e:dK\n\u0013xn[3s!\t\tC%D\u0001#\u0015\t\u0019C!A\u0004dYV\u001cH/\u001a:\n\u0005\u0015\u0012#A\u0004\"s_.,'/\u00128e!>Lg\u000e\u001e\u0005\tO\u0001\u0011\t\u0011)A\u0005Q\u0005\u0011Bo\u001c9jG\u0006sG\rU1si&$\u0018n\u001c8t!\rIc&\r\b\u0003U1r!aE\u0016\n\u0003]I!!\f\f\u0002\u000fA\f7m[1hK&\u0011q\u0006\r\u0002\t\u0013R,'/\u00192mK*\u0011QF\u0006\t\u0003eUj\u0011a\r\u0006\u0003i\u0011\taaY8n[>t\u0017B\u0001\u001c4\u0005E!v\u000e]5d\u0003:$\u0007+\u0019:uSRLwN\u001c\u0005\tq\u0001\u0011\t\u0011)A\u0005s\u0005i!/\u001a9mS\u000e\f')\u001e4gKJ\u0004\"AO\u001e\u000e\u0003\tI!\u0001\u0010\u0002\u0003\u001bI+\u0007\u000f\\5dC\n+hMZ3s\u0011!q\u0004A!A!\u0002\u0013y\u0014!D:pG.,G\u000fV5nK>,H\u000f\u0005\u0002A\u00036\ta#\u0003\u0002C-\t\u0019\u0011J\u001c;\t\u0011\u0011\u0003!\u0011!Q\u0001\n}\n\u0001c]8dW\u0016$()\u001e4gKJ\u001c\u0016N_3\t\u0011\u0019\u0003!\u0011!Q\u0001\n}\n\u0011BZ3uG\"\u001c\u0016N_3\t\u0011!\u0003!\u0011!Q\u0001\n}\nq!\\1y/\u0006LG\u000f\u0003\u0005K\u0001\t\u0005\t\u0015!\u0003@\u0003!i\u0017N\u001c\"zi\u0016\u001c\b\u0002\u0003'\u0001\u0005\u0003\u0005\u000b\u0011B'\u0002\u001d\u0011|g+\u001a:jM&\u001c\u0017\r^5p]B\u0011\u0001IT\u0005\u0003\u001fZ\u0011qAQ8pY\u0016\fg\u000eC\u0003R\u0001\u0011\u0005!+\u0001\u0004=S:LGO\u0010\u000b\f'R+fk\u0016-Z5ncV\f\u0005\u0002;\u0001!)q\u0002\u0015a\u0001!!)q\u0004\u0015a\u0001A!)q\u0005\u0015a\u0001Q!)\u0001\b\u0015a\u0001s!)a\b\u0015a\u0001\u007f!)A\t\u0015a\u0001\u007f!)a\t\u0015a\u0001\u007f!)\u0001\n\u0015a\u0001\u007f!)!\n\u0015a\u0001\u007f!)A\n\u0015a\u0001\u001b\"9q\f\u0001b\u0001\n\u0003\u0001\u0017AD:j[BdWmQ8ogVlWM]\u000b\u0002CB\u0011!-Z\u0007\u0002G*\u0011A\rB\u0001\tG>t7/^7fe&\u0011am\u0019\u0002\u000f'&l\u0007\u000f\\3D_:\u001cX/\\3s\u0011\u0019A\u0007\u0001)A\u0005C\u0006y1/[7qY\u0016\u001cuN\\:v[\u0016\u0014\b\u0005C\u0004k\u0001\t\u0007I\u0011A6\u0002'\u0019,Go\u00195SKF,Xm\u001d;Ck&dG-\u001a:\u0016\u00031\u0004\"!\u001c9\u000e\u00039T!a\u001c\u0003\u0002\u0007\u0005\u0004\u0018.\u0003\u0002r]\n\u0019b)\u001a;dQJ+\u0017/^3ti\n+\u0018\u000e\u001c3fe\"11\u000f\u0001Q\u0001\n1\fACZ3uG\"\u0014V-];fgR\u0014U/\u001b7eKJ\u0004\u0003\"B;\u0001\t\u00032\u0018A\u00023p/>\u00148\u000eF\u0001x!\t\u0001\u00050\u0003\u0002z-\t!QK\\5u\u0001")
public class ReplicaFetcher
extends ShutdownableThread {
    private final BrokerEndPoint sourceBroker;
    private final Iterable<TopicAndPartition> topicAndPartitions;
    private final ReplicaBuffer replicaBuffer;
    private final int fetchSize;
    private final boolean doVerification;
    private final SimpleConsumer simpleConsumer;
    private final FetchRequestBuilder fetchRequestBuilder;

    public SimpleConsumer simpleConsumer() {
        return this.simpleConsumer;
    }

    public FetchRequestBuilder fetchRequestBuilder() {
        return this.fetchRequestBuilder;
    }

    @Override
    public void doWork() {
        CountDownLatch verificationBarrier;
        CountDownLatch fetcherBarrier;
        block7: {
            block6: {
                fetcherBarrier = this.replicaBuffer.getFetcherBarrier();
                verificationBarrier = this.replicaBuffer.getVerificationBarrier();
                this.topicAndPartitions.foreach((Function1 & Serializable & scala.Serializable)topicAndPartition -> this.fetchRequestBuilder().addFetch(topicAndPartition.topic(), topicAndPartition.partition(), $this.replicaBuffer.getOffset((TopicAndPartition)topicAndPartition), $this.fetchSize));
                FetchRequest fetchRequest = this.fetchRequestBuilder().build();
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Issuing fetch request " + fetchRequest);
                FetchResponse response = null;
                try {
                    response = this.simpleConsumer().fetch(fetchRequest);
                }
                finally {
                    if (response != null) {
                    }
                    break block6;
                }
                response.data().foreach((Function1 & Serializable & scala.Serializable)x0$8 -> {
                    ReplicaFetcher.$anonfun$doWork$3(this, x0$8);
                    return BoxedUnit.UNIT;
                });
                break block7;
            }
            this.topicAndPartitions.foreach((Function1 & Serializable & scala.Serializable)topicAndPartition -> {
                ReplicaFetcher.$anonfun$doWork$4(this, topicAndPartition);
                return BoxedUnit.UNIT;
            });
        }
        fetcherBarrier.countDown();
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Done fetching");
        fetcherBarrier.await();
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Ready for verification");
        if (this.doVerification) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Do verification");
            this.replicaBuffer.verifyCheckSum((Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x -> {
                Predef$.MODULE$.println(x);
                return BoxedUnit.UNIT;
            });
            this.replicaBuffer.createNewFetcherBarrier();
            this.replicaBuffer.createNewVerificationBarrier();
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Created new barrier");
            verificationBarrier.countDown();
        }
        verificationBarrier.await();
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Done verification");
    }

    public static final /* synthetic */ void $anonfun$doWork$3(ReplicaFetcher $this, Tuple2 x0$8) {
        Tuple2 tuple2 = x0$8;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicAndPartition topicAndPartition = (TopicAndPartition)tuple2._1();
        FetchResponsePartitionData partitionData = (FetchResponsePartitionData)tuple2._2();
        $this.replicaBuffer.addFetchedData(topicAndPartition, $this.sourceBroker.id(), partitionData);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$doWork$4(ReplicaFetcher $this, TopicAndPartition topicAndPartition) {
        ByteBufferMessageSet x$9 = MessageSet$.MODULE$.Empty();
        Errors x$10 = FetchResponsePartitionData$.MODULE$.$lessinit$greater$default$1();
        long x$11 = FetchResponsePartitionData$.MODULE$.$lessinit$greater$default$2();
        $this.replicaBuffer.addFetchedData(topicAndPartition, $this.sourceBroker.id(), new FetchResponsePartitionData(x$10, x$11, x$9));
    }

    public ReplicaFetcher(String name, BrokerEndPoint sourceBroker, Iterable<TopicAndPartition> topicAndPartitions, ReplicaBuffer replicaBuffer, int socketTimeout, int socketBufferSize, int fetchSize, int maxWait, int minBytes, boolean doVerification) {
        this.sourceBroker = sourceBroker;
        this.topicAndPartitions = topicAndPartitions;
        this.replicaBuffer = replicaBuffer;
        this.fetchSize = fetchSize;
        this.doVerification = doVerification;
        super(name, ShutdownableThread$.MODULE$.$lessinit$greater$default$2());
        this.simpleConsumer = new SimpleConsumer(sourceBroker.host(), sourceBroker.port(), socketTimeout, socketBufferSize, ReplicaVerificationTool$.MODULE$.clientId());
        this.fetchRequestBuilder = new FetchRequestBuilder().clientId(ReplicaVerificationTool$.MODULE$.clientId()).replicaId(Request$.MODULE$.DebuggingConsumerId()).maxWait(maxWait).minBytes(minBytes);
    }
}

