/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Map;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.state.WindowStore;
import org.apache.kafka.streams.state.internals.AbstractStoreSupplier;
import org.apache.kafka.streams.state.internals.RocksDbWindowBytesStoreSupplier;
import org.apache.kafka.streams.state.internals.WindowStoreBuilder;
import org.apache.kafka.streams.state.internals.WindowStoreSupplier;

@Deprecated
public class RocksDBWindowStoreSupplier<K, V>
extends AbstractStoreSupplier<K, V, WindowStore>
implements WindowStoreSupplier<WindowStore> {
    public static final int MIN_SEGMENTS = 2;
    private final long retentionPeriod;
    private WindowStoreBuilder<K, V> builder;

    public RocksDBWindowStoreSupplier(String name, long retentionPeriod, int numSegments, boolean retainDuplicates, Serde<K> keySerde, Serde<V> valueSerde, long windowSize, boolean logged, Map<String, String> logConfig, boolean enableCaching) {
        this(name, retentionPeriod, numSegments, retainDuplicates, keySerde, valueSerde, Time.SYSTEM, windowSize, logged, logConfig, enableCaching);
    }

    public RocksDBWindowStoreSupplier(String name, long retentionPeriod, int numSegments, boolean retainDuplicates, Serde<K> keySerde, Serde<V> valueSerde, Time time, long windowSize, boolean logged, Map<String, String> logConfig, boolean enableCaching) {
        super(name, keySerde, valueSerde, time, logged, logConfig);
        if (numSegments < 2) {
            throw new IllegalArgumentException("numSegments must be >= 2");
        }
        this.retentionPeriod = retentionPeriod;
        this.builder = new WindowStoreBuilder<K, V>(new RocksDbWindowBytesStoreSupplier(name, retentionPeriod, numSegments, windowSize, retainDuplicates), keySerde, valueSerde, time);
        if (enableCaching) {
            this.builder.withCachingEnabled();
        }
        if (!logged) {
            this.builder.withLoggingDisabled();
        }
    }

    @Override
    public WindowStore<K, V> get() {
        return this.builder.build();
    }

    @Override
    public long retentionPeriod() {
        return this.retentionPeriod;
    }
}

