/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.napkinlaf.sketch.sketchers;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.util.ListIterator;
import net.sourceforge.napkinlaf.sketch.AbstractSketcher;
import net.sourceforge.napkinlaf.sketch.Template;
import net.sourceforge.napkinlaf.sketch.TemplateItem;
import net.sourceforge.napkinlaf.sketch.geometry.CubicLine;
import net.sourceforge.napkinlaf.sketch.geometry.Path;
import net.sourceforge.napkinlaf.sketch.geometry.Point;
import net.sourceforge.napkinlaf.sketch.geometry.QuadLine;
import net.sourceforge.napkinlaf.sketch.geometry.SketchShape;
import net.sourceforge.napkinlaf.sketch.geometry.StraightLine;
import net.sourceforge.napkinlaf.util.NapkinRandom;

public class JotSketcher
extends AbstractSketcher {
    private static final double DEFORM_FACTOR = 0.2;

    public void sketch(Template template, Graphics2D g2d, Component c) {
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        ListIterator<TemplateItem> iter = template.getListIterator();
        while (iter.hasNext()) {
            TemplateItem current = (TemplateItem)iter.next();
            TemplateItem draw = current.clone();
            if (current.isDrawFill()) {
                draw.setDrawStroke(false);
                draw.setDrawFill(true);
                draw.setShape(JotSketcher.deform(current.getShape().transformToPath(), true));
                JotSketcher.cleanSketch(draw, g2d, c);
            }
            if (!current.isDrawStroke()) continue;
            draw.setDrawFill(false);
            draw.setDrawStroke(true);
            SketchShape u = current.getShape().deform(this);
            draw.setStrokeWeight(JotSketcher.computeStrokeModifier(u.approximateLength()));
            draw.setShape(u);
            JotSketcher.cleanSketch(draw, g2d, c);
        }
    }

    private static CubicLine deform(CubicLine c) {
        return JotSketcher.deform(c, true);
    }

    private static CubicLine deform(CubicLine c, boolean perturbInitial) {
        double twopercent = c.approximateLength() * 0.2;
        Point p1 = perturbInitial ? Point.random(c.getP1(), twopercent) : new Point(c.getP1());
        return new CubicLine(p1, Point.random(c.getCtrlP1(), twopercent * 5.0), Point.random(c.getCtrlP2(), twopercent * 5.0), Point.random(c.getP2(), twopercent));
    }

    private static Path deform(Path p) {
        return JotSketcher.deform(p, false);
    }

    private static Path deform(Path p, boolean close) {
        CubicLine draw;
        Point ctrl2;
        Point ctrl1;
        Point far;
        Path ret = new Path();
        Point initial = new Point(0.0, 0.0);
        Point current = new Point(0.0, 0.0);
        double[] coords = new double[6];
        PathIterator pi = p.getPathIterator(new AffineTransform());
        while (!pi.isDone()) {
            SketchShape seg;
            int segType = pi.currentSegment(coords);
            pi.next();
            switch (segType) {
                case 0: {
                    current = new Point(coords[0], coords[1]);
                    initial = new Point(current);
                    ret.moveTo(current.floatX(), current.floatY());
                    seg = null;
                    break;
                }
                case 1: {
                    far = new Point(coords[0], coords[1]);
                    seg = new StraightLine(current, far);
                    current = new Point(far);
                    break;
                }
                case 2: {
                    ctrl1 = new Point(coords[0], coords[1]);
                    far = new Point(coords[2], coords[3]);
                    seg = new QuadLine(current, ctrl1, far);
                    current = new Point(far);
                    break;
                }
                case 3: {
                    ctrl1 = new Point(coords[0], coords[1]);
                    ctrl2 = new Point(coords[2], coords[3]);
                    far = new Point(coords[4], coords[5]);
                    seg = new CubicLine(current, ctrl1, ctrl2, far);
                    current = new Point(far);
                    break;
                }
                case 4: {
                    seg = new StraightLine(current, initial);
                    current = new Point(initial);
                    break;
                }
                default: {
                    throw new IllegalStateException(segType + ": unknown");
                }
            }
            if (seg == null) continue;
            draw = JotSketcher.deform(seg.transformToCubic(), false);
            ctrl1 = new Point(draw.getCtrlP1());
            ctrl2 = new Point(draw.getCtrlP2());
            far = new Point(draw.getP2());
            ret.curveTo(ctrl1.floatX(), ctrl1.floatY(), ctrl2.floatX(), ctrl2.floatY(), far.floatX(), far.floatY());
        }
        if (close) {
            draw = JotSketcher.deform(new StraightLine(current, initial).transformToCubic(), false);
            ctrl1 = new Point(draw.getCtrlP1());
            ctrl2 = new Point(draw.getCtrlP2());
            far = new Point(draw.getP2());
            ret.curveTo(ctrl1.floatX(), ctrl1.floatY(), ctrl2.floatX(), ctrl2.floatY(), far.floatX(), far.floatY());
            ret.closePath();
        }
        return ret;
    }

    private static float computeStrokeModifier(double lineLength) {
        double ret = lineLength < 1.68 ? 2.0 - 0.19 * lineLength : Math.pow(lineLength + 0.5, 2.0) / Math.pow(lineLength, 2.0);
        return (float)(ret *= NapkinRandom.gaussian(0.15) + 1.0);
    }

    public SketchShape deformLine(StraightLine l) {
        return l.transformToCubic().deform(this);
    }

    public SketchShape deformQuad(QuadLine q) {
        return q.transformToCubic().deform(this);
    }

    public SketchShape deformCubic(CubicLine c) {
        return JotSketcher.deform(c);
    }

    public SketchShape deformPath(Path p) {
        return JotSketcher.deform(p);
    }
}

