/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.util;

import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.io.PrintStream;
import java.util.Timer;
import java.util.TimerTask;

public final class EventDispatchThreadHangMonitor
extends EventQueue {
    private static final EventQueue INSTANCE = new EventDispatchThreadHangMonitor();
    private static final long CHECK_INTERVAL_MS = 100L;
    private static final long UNREASONABLE_DISPATCH_DURATION_MS = 500L;
    private static final long NO_CURRENT_EVENT = 0L;
    private long startedLastEventDispatchAt = 0L;
    private boolean reportedHang = false;
    private Thread eventDispatchThread = null;

    private EventDispatchThreadHangMonitor() {
        this.initTimer();
    }

    private void initTimer() {
        long initialDelayMs = 0L;
        boolean isDaemon = true;
        Timer timer = new Timer("EventDispatchThreadHangMonitor", true);
        timer.schedule((TimerTask)new HangChecker(), 0L, 100L);
    }

    private long timeSoFar() {
        long currentTime = System.currentTimeMillis();
        return currentTime - this.startedLastEventDispatchAt;
    }

    public static void initMonitoring() {
        Toolkit.getDefaultToolkit().getSystemEventQueue().push(INSTANCE);
    }

    @Override
    protected void dispatchEvent(AWTEvent event) {
        this.preDispatchEvent();
        super.dispatchEvent(event);
        this.postDispatchEvent();
    }

    private synchronized void preDispatchEvent() {
        if (this.eventDispatchThread == null) {
            this.eventDispatchThread = Thread.currentThread();
        }
        this.reportedHang = false;
        this.startedLastEventDispatchAt = System.currentTimeMillis();
    }

    private synchronized void postDispatchEvent() {
        if (this.reportedHang) {
            System.out.println("--- event dispatch thread unstuck after " + this.timeSoFar() + " ms.");
        }
        this.startedLastEventDispatchAt = 0L;
    }

    private class HangChecker
    extends TimerTask {
        private HangChecker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            EventQueue eventQueue = INSTANCE;
            synchronized (eventQueue) {
                this.checkForHang();
            }
        }

        private void checkForHang() {
            if (EventDispatchThreadHangMonitor.this.startedLastEventDispatchAt == 0L) {
                return;
            }
            if (EventDispatchThreadHangMonitor.this.timeSoFar() > 500L) {
                this.reportHang();
            }
        }

        private void reportHang() {
            if (EventDispatchThreadHangMonitor.this.reportedHang) {
                return;
            }
            EventDispatchThreadHangMonitor.this.reportedHang = true;
            System.out.println("--- event dispatch thread stuck processing event for " + EventDispatchThreadHangMonitor.this.timeSoFar() + " ms:");
            StackTraceElement[] stackTrace = EventDispatchThreadHangMonitor.this.eventDispatchThread.getStackTrace();
            this.printStackTrace(System.out, stackTrace);
        }

        private void printStackTrace(PrintStream out, StackTraceElement[] stackTrace) {
            String ourEventQueueClassName = EventDispatchThreadHangMonitor.class.getName();
            for (StackTraceElement stackTraceElement : stackTrace) {
                if (stackTraceElement.getClassName().equals(ourEventQueueClassName)) {
                    return;
                }
                out.println("    " + stackTraceElement);
            }
        }
    }
}

