/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import org.fife.ui.DrawDnDIndicatorTabbedPane;

public class TabbedPaneTransferHandler
extends TransferHandler
implements DropTargetListener {
    private static final long serialVersionUID = 1L;
    private static final String mimeType = "application/x-java-jvm-local-objectref;class=javax.swing.JTabbedPane";
    private DataFlavor tabFlavor;
    protected Point mouseLocation;
    private TabTransferable currentTransferable;

    public TabbedPaneTransferHandler() {
        try {
            this.tabFlavor = new DataFlavor(mimeType);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public boolean canImport(JComponent c, DataFlavor[] flavors) {
        return this.hasTabFlavor(flavors);
    }

    protected Transferable createTransferable(JComponent c) {
        this.currentTransferable = new TabTransferable((JTabbedPane)c);
        return this.currentTransferable;
    }

    public void dragEnter(DropTargetDragEvent e) {
    }

    public void dragExit(DropTargetEvent e) {
        Component c = e.getDropTargetContext().getComponent();
        if (c instanceof DrawDnDIndicatorTabbedPane) {
            ((DrawDnDIndicatorTabbedPane)((Object)c)).clearDnDIndicatorRect();
        }
    }

    public void dragOver(DropTargetDragEvent e) {
        TabTransferable t;
        this.mouseLocation = e.getLocation();
        Component c = e.getDropTargetContext().getComponent();
        JTabbedPane destTabbedPane = (JTabbedPane)c;
        if (destTabbedPane instanceof DrawDnDIndicatorTabbedPane && (t = this.currentTransferable) != null) {
            Rectangle transferredTabBounds = t.getTabBounds();
            int tab = this.getDroppedTabIndex(destTabbedPane, this.mouseLocation);
            Rectangle iBounds = destTabbedPane.getBoundsAt(tab == 0 ? 0 : tab - 1);
            iBounds.y = iBounds.y + iBounds.height - transferredTabBounds.height;
            int tabPlacement = destTabbedPane.getTabPlacement();
            switch (tabPlacement) {
                case 1: 
                case 3: {
                    iBounds.x = iBounds.x + (tab == 0 ? 0 : iBounds.width);
                    iBounds.x -= transferredTabBounds.width / 2;
                    break;
                }
                case 2: 
                case 4: {
                    iBounds.y -= transferredTabBounds.height / 2;
                }
            }
            ((DrawDnDIndicatorTabbedPane)((Object)c)).setDnDIndicatorRect(iBounds.x, iBounds.y, transferredTabBounds.width, transferredTabBounds.height);
        }
    }

    public void drop(DropTargetDropEvent e) {
        Component c = e.getDropTargetContext().getComponent();
        if (c instanceof DrawDnDIndicatorTabbedPane) {
            ((DrawDnDIndicatorTabbedPane)((Object)c)).clearDnDIndicatorRect();
        }
    }

    public void dropActionChanged(DropTargetDragEvent e) {
    }

    protected int getDroppedTabIndex(JTabbedPane tabbedPane, Point p) {
        int tab = tabbedPane.indexAtLocation(this.mouseLocation.x, this.mouseLocation.y);
        if (tab == -1) {
            int tabCount = tabbedPane.getTabCount();
            int tabPlacement = tabbedPane.getTabPlacement();
            switch (tabPlacement) {
                case 1: 
                case 3: {
                    int x = p.x;
                    int dy = Integer.MAX_VALUE;
                    for (int i = 0; i < tabCount; ++i) {
                        int dy2;
                        Rectangle b = tabbedPane.getBoundsAt(i);
                        if (x < b.x || x >= b.x + b.width || (dy2 = Math.abs(b.y - p.y)) >= dy) continue;
                        tab = i;
                        dy = dy2;
                    }
                    break;
                }
                case 2: 
                case 4: {
                    int y = p.y;
                    int dx = Integer.MAX_VALUE;
                    for (int i = 0; i < tabCount; ++i) {
                        int dx2;
                        Rectangle b = tabbedPane.getBoundsAt(i);
                        if (y < b.y || y >= b.y + b.height || (dx2 = Math.abs(b.x - p.x)) >= dx) continue;
                        tab = i;
                        dx = dx2;
                    }
                    break;
                }
            }
        }
        if (tab == -1) {
            tab = tabbedPane.getTabCount();
        }
        return tab;
    }

    public int getSourceActions(JComponent c) {
        return 2;
    }

    protected boolean hasTabFlavor(DataFlavor[] flavors) {
        if (this.tabFlavor == null) {
            return false;
        }
        for (int i = 0; i < flavors.length; ++i) {
            if (!this.tabFlavor.equals(flavors[i])) continue;
            return true;
        }
        return false;
    }

    public boolean importData(JComponent c, Transferable t) {
        boolean successful = false;
        if (this.hasTabFlavor(t.getTransferDataFlavors()) && this.mouseLocation != null) {
            try {
                JTabbedPane tabbedPane = (JTabbedPane)c;
                int tab = this.getDroppedTabIndex(tabbedPane, this.mouseLocation);
                TabTransferable.TabTransferData td = (TabTransferable.TabTransferData)t.getTransferData(this.tabFlavor);
                JTabbedPane sourcePane = td.sourceTabbedPane;
                int sourceIndex = td.tabIndex;
                String tabName = sourcePane.getTitleAt(sourceIndex);
                Icon icon = sourcePane.getIconAt(sourceIndex);
                Component comp = sourcePane.getComponentAt(sourceIndex);
                String toolTip = sourcePane.getToolTipTextAt(sourceIndex);
                Color foreground = sourcePane.getForegroundAt(sourceIndex);
                tabbedPane.insertTab(tabName, icon, comp, toolTip, tab);
                int count = tabbedPane.getTabCount();
                for (int i = 0; i < count; ++i) {
                    Component comp2 = tabbedPane.getComponentAt(i);
                    if (comp2 == null || !comp2.equals(comp)) continue;
                    tabbedPane.setForegroundAt(i, foreground);
                    this.selectTab(tabbedPane, i);
                    break;
                }
                successful = true;
                if (c instanceof DrawDnDIndicatorTabbedPane) {
                    ((DrawDnDIndicatorTabbedPane)((Object)c)).clearDnDIndicatorRect();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.currentTransferable = null;
        return successful;
    }

    protected void selectTab(final JTabbedPane tabbedPane, final int index) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                tabbedPane.setSelectedIndex(index);
            }
        });
    }

    class TabTransferable
    implements Transferable {
        private TabTransferData transferData;

        TabTransferable(JTabbedPane tabbedPane) {
            int index = tabbedPane.getSelectedIndex();
            this.transferData = new TabTransferData(tabbedPane, index);
        }

        public Rectangle getTabBounds() {
            return this.transferData.sourceTabbedPane.getBoundsAt(this.transferData.tabIndex);
        }

        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
            if (!this.isDataFlavorSupported(flavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this.transferData;
        }

        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{TabbedPaneTransferHandler.this.tabFlavor};
        }

        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return TabbedPaneTransferHandler.this.tabFlavor.equals(flavor);
        }

        class TabTransferData {
            private JTabbedPane sourceTabbedPane;
            private int tabIndex;

            TabTransferData(JTabbedPane tabbedPane, int tabIndex) {
                this.sourceTabbedPane = tabbedPane;
                this.tabIndex = tabIndex;
            }
        }
    }
}

