/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextfilechooser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import org.fife.ui.EscapableDialog;
import org.fife.ui.OptionsDialogPanel;
import org.fife.ui.ResizableFrameContentPane;
import org.fife.ui.SubstanceUtils;
import org.fife.ui.UIUtil;
import org.fife.ui.modifiabletable.AbstractRowHandler;
import org.fife.ui.modifiabletable.ModifiableTable;
import org.fife.ui.modifiabletable.ModifiableTableChangeEvent;
import org.fife.ui.modifiabletable.ModifiableTableListener;
import org.fife.ui.rtextfilechooser.FileChooserIconManager;
import org.fife.ui.rtextfilechooser.FileChooserOwner;
import org.fife.ui.rtextfilechooser.RDirectoryChooser;
import org.fife.ui.rtextfilechooser.RTextFileChooser;

public class FileChooserFavoritesOptionPanel
extends OptionsDialogPanel
implements ModifiableTableListener {
    private static final long serialVersionUID = 1L;
    public static final String FAVORITES_PROPERTY = "Favorites";
    private FavoritesTableModel model;
    private ModifiableTable modifiableTable;
    private static final String MSG = "org.fife.ui.rtextfilechooser.FileChooserFavoritesOptionPanel";
    private static final String EDIT_FAVORITES_DIALOG_MSG = "org.fife.ui.rtextfilechooser.EditFavoriteDialog";
    private static final String SUBSTANCE_TABLE_RENDERER_CLASS = "org.pushingpixels.substance.api.renderers.SubstanceDefaultTableCellRenderer";

    public FileChooserFavoritesOptionPanel() {
        ComponentOrientation orientation = ComponentOrientation.getOrientation(this.getLocale());
        ResourceBundle msg = ResourceBundle.getBundle(MSG);
        this.setName(msg.getString(FAVORITES_PROPERTY));
        this.setBorder(UIUtil.getEmpty5Border());
        this.setLayout(new BorderLayout());
        JPanel favoritesPanel = new JPanel(new BorderLayout());
        favoritesPanel.setBorder(new OptionsDialogPanel.OptionPanelBorder(msg.getString("FavoritesSection")));
        String header = msg.getString("FavoriteTable.Header");
        this.model = new FavoritesTableModel(header);
        this.modifiableTable = new ModifiableTable(this.model, "South", 15);
        this.modifiableTable.setRowHandler(new FavoritesRowHandler());
        this.modifiableTable.addModifiableTableListener(this);
        JTable favoritesTable = this.modifiableTable.getTable();
        favoritesTable.setDefaultRenderer(Object.class, this.createCellRenderer());
        favoritesTable.setShowGrid(false);
        favoritesPanel.add(this.modifiableTable);
        this.add(favoritesPanel);
        this.applyComponentOrientation(orientation);
    }

    private DefaultTableCellRenderer createCellRenderer() {
        JLabel r = null;
        if (SubstanceUtils.isSubstanceInstalled()) {
            try {
                Class<?> clazz = Class.forName(SUBSTANCE_TABLE_RENDERER_CLASS);
                r = (DefaultTableCellRenderer)clazz.newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (r == null) {
            r = new DefaultTableCellRenderer();
        }
        r.setIcon(FileChooserIconManager.createFolderIcon());
        ComponentOrientation orientation = ComponentOrientation.getOrientation(this.getLocale());
        r.setComponentOrientation(orientation);
        return r;
    }

    protected void doApplyImpl(Frame owner) {
        if (!(owner instanceof FileChooserOwner)) {
            throw new IllegalArgumentException("owner must be a FileChooserOwner");
        }
        FileChooserOwner fco = (FileChooserOwner)((Object)owner);
        this.installFavorites(fco.getFileChooser());
    }

    protected OptionsDialogPanel.OptionsPanelCheckResult ensureValidInputsImpl() {
        return null;
    }

    public JComponent getTopJComponent() {
        return this.modifiableTable;
    }

    public void installFavorites(RTextFileChooser chooser) {
        this.model.setChooserFavorites(chooser);
    }

    public void modifiableTableChanged(ModifiableTableChangeEvent e) {
        this.hasUnsavedChanges = true;
        this.firePropertyChange(FAVORITES_PROPERTY, null, new Integer(e.getRow()));
    }

    public void setFavorites(RTextFileChooser chooser) {
        this.model.initFavorites(chooser);
    }

    protected void setValuesImpl(Frame owner) {
        if (!(owner instanceof FileChooserOwner)) {
            throw new IllegalArgumentException("owner must be a FileChooserOwner");
        }
        FileChooserOwner fco = (FileChooserOwner)((Object)owner);
        this.setFavorites(fco.getFileChooser());
    }

    public void updateUI() {
        if (this.modifiableTable != null) {
            DefaultTableCellRenderer r = (DefaultTableCellRenderer)this.modifiableTable.getTable().getDefaultRenderer(Object.class);
            r.setIcon(FileChooserIconManager.createFolderIcon());
        }
        super.updateUI();
    }

    private static class FavoritesTableModel
    extends DefaultTableModel {
        private static final long serialVersionUID = 1L;
        private String[] columnNames = new String[1];

        public FavoritesTableModel(String favoriteHeader) {
            this.columnNames[0] = favoriteHeader;
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        public void initFavorites(RTextFileChooser chooser) {
            this.setRowCount(0);
            String[] favorites = chooser.getFavorites();
            for (int i = 0; i < favorites.length; ++i) {
                Vector<String> v = new Vector<String>(2);
                String favorite = favorites[i];
                v.add(favorite);
                this.addRow(v);
            }
        }

        public void setChooserFavorites(RTextFileChooser chooser) {
            chooser.clearFavorites();
            for (int i = 0; i < this.getRowCount(); ++i) {
                String favorite = (String)this.getValueAt(i, 0);
                chooser.addToFavorites(favorite);
            }
        }
    }

    class FavoritesRowHandler
    extends AbstractRowHandler {
        private EditFavoriteDialog dialog;

        FavoritesRowHandler() {
        }

        public Object[] getNewRowInfo(Object[] oldData) {
            if (this.dialog == null) {
                this.dialog = new EditFavoriteDialog(FileChooserFavoritesOptionPanel.this.getOptionsDialog());
            }
            this.dialog.setData(oldData == null ? null : (String)oldData[0]);
            int rc = this.dialog.showEditFavoriteDialog();
            if (rc == 0) {
                return new Object[]{this.dialog.getDirectory()};
            }
            return null;
        }

        public void updateUI() {
            if (this.dialog != null) {
                SwingUtilities.updateComponentTreeUI(this.dialog);
            }
        }
    }

    private static class EditFavoriteDialog
    extends EscapableDialog
    implements ActionListener,
    DocumentListener {
        static final int OK = 0;
        static final int CANCEL = 1;
        private JTextField dirField;
        private JButton okButton;
        private JButton cancelButton;
        private int rc;

        public EditFavoriteDialog(JDialog owner) {
            super(owner);
            ComponentOrientation orientation = ComponentOrientation.getOrientation(this.getLocale());
            ResourceBundle msg = ResourceBundle.getBundle(FileChooserFavoritesOptionPanel.EDIT_FAVORITES_DIALOG_MSG);
            ResizableFrameContentPane contentPane = new ResizableFrameContentPane(new BorderLayout());
            contentPane.setBorder(UIUtil.getEmpty5Border());
            Box topPanel = Box.createVerticalBox();
            JPanel temp = new JPanel(new BorderLayout(5, 0));
            temp.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
            JLabel label = UIUtil.newLabel(msg, "Directory");
            temp.add((Component)label, "Before");
            this.dirField = new JTextField(35);
            this.dirField.getDocument().addDocumentListener(this);
            label.setLabelFor(this.dirField);
            temp.add(this.dirField);
            JButton browseButton = new JButton(msg.getString("Browse.Text"));
            browseButton.setMnemonic((int)msg.getString("Browse.Mnemonic").charAt(0));
            browseButton.setActionCommand("Browse");
            browseButton.addActionListener(this);
            temp.add((Component)browseButton, "After");
            topPanel.add(temp);
            contentPane.add((Component)topPanel, "North");
            this.okButton = UIUtil.newButton(msg, "OK.Text", "OK.Mnemonic");
            this.okButton.addActionListener(this);
            this.cancelButton = UIUtil.newButton(msg, "Cancel.Text", "Cancel.Mnemonic");
            this.cancelButton.addActionListener(this);
            Container buttons = UIUtil.createButtonFooter(this.okButton, this.cancelButton);
            contentPane.add((Component)buttons, "South");
            this.setTitle(msg.getString("Title"));
            this.setContentPane(contentPane);
            this.getRootPane().setDefaultButton(this.okButton);
            this.setModal(true);
            this.applyComponentOrientation(orientation);
            this.pack();
        }

        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == this.okButton) {
                this.rc = 0;
                this.escapePressed();
            } else if (source == this.cancelButton) {
                this.escapePressed();
            } else {
                String command = e.getActionCommand();
                if ("Browse".equals(command)) {
                    RDirectoryChooser chooser = new RDirectoryChooser((JDialog)this.getOwner());
                    chooser.setChosenDirectory(new File(this.getDirectory()));
                    chooser.setVisible(true);
                    String chosenDir = chooser.getChosenDirectory();
                    if (chosenDir != null) {
                        this.dirField.setText(chosenDir);
                    }
                }
            }
        }

        public void changedUpdate(DocumentEvent e) {
        }

        public String getDirectory() {
            return this.dirField.getText();
        }

        public void insertUpdate(DocumentEvent e) {
            this.okButton.setEnabled(true);
        }

        public void removeUpdate(DocumentEvent e) {
            this.okButton.setEnabled(this.dirField.getDocument().getLength() > 0);
        }

        public void setData(String dir) {
            this.dirField.setText(dir);
        }

        public int showEditFavoriteDialog() {
            this.rc = 1;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    EditFavoriteDialog.this.dirField.requestFocusInWindow();
                    EditFavoriteDialog.this.dirField.selectAll();
                }
            });
            this.setLocationRelativeTo(this.getOwner());
            this.okButton.setEnabled(false);
            this.setVisible(true);
            return this.rc;
        }
    }
}

