/*
 * Decompiled with CFR 0.152.
 */
package free.jin.ui;

import free.jin.Jin;
import free.util.AWTUtilities;
import free.util.swing.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public abstract class DialogPanel
extends JPanel {
    private JDialog dialog = null;
    private Component hintParent = null;
    private JButton defaultButton = null;
    private Object result;
    private boolean resultSet = false;

    protected abstract String getTitle();

    protected Object getCancelResult() {
        return null;
    }

    protected void setDefaultButton(JButton jButton) {
        this.defaultButton = jButton;
    }

    public void show(JDialog jDialog, Component component) {
        this.dialog = jDialog;
        SwingUtils.registerEscapeCloser(jDialog);
        jDialog.setModal(true);
        jDialog.setTitle(this.getTitle());
        jDialog.setResizable(false);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        jPanel.add((Component)this, "Center");
        jDialog.setContentPane(jPanel);
        jDialog.getRootPane().setDefaultButton(this.defaultButton);
        jDialog.setDefaultCloseOperation(2);
        AWTUtilities.centerWindow(jDialog, component);
        this.resultSet = false;
        jDialog.setVisible(true);
    }

    public void resizeContainerToFit() {
        if (this.dialog != null) {
            this.dialog.pack();
        }
    }

    public Object askResult() {
        Jin.getInstance().getUIProvider().showDialog(this, this.hintParent);
        if (this.resultSet) {
            return this.result;
        }
        return this.getCancelResult();
    }

    public final DialogPanel setHintParent(Component component) {
        this.hintParent = component;
        return this;
    }

    protected void close(Object object) {
        this.result = object;
        this.resultSet = true;
        this.dialog.dispose();
        this.dialog = null;
    }

    protected class ClosingListener
    implements ActionListener {
        private final Object result;

        public ClosingListener(Object object) {
            this.result = object;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DialogPanel.this.close(this.result);
        }
    }
}

