/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.restclient.ui.reqbody;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.net.MalformedURLException;
import java.net.URL;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.wiztools.restclient.bean.ReqEntity;
import org.wiztools.restclient.bean.ReqEntityUrlStream;
import org.wiztools.restclient.bean.ReqEntityUrlStreamBean;
import org.wiztools.restclient.ui.RESTUserInterface;
import org.wiztools.restclient.ui.RESTView;
import org.wiztools.restclient.ui.UIUtil;
import org.wiztools.restclient.ui.reqbody.ContentTypeCharsetComponent;
import org.wiztools.restclient.ui.reqbody.ReqBodyPanel;

public class ReqBodyPanelUrlStream
extends JPanel
implements ReqBodyPanel {
    @Inject
    RESTView view;
    @Inject
    RESTUserInterface rest_ui;
    @Inject
    ContentTypeCharsetComponent jp_content_type_charset;
    private JTextField jtf_url = new JTextField(26);

    @PostConstruct
    protected void init() {
        this.setLayout(new FlowLayout(0));
        this.jtf_url.setToolTipText("Contents of this URL will be set as request body");
        JPanel jp = new JPanel(new BorderLayout());
        JPanel jp_west = new JPanel(new GridLayout(2, 1));
        jp_west.add(new JLabel(" Content type: "));
        jp_west.add(new JLabel(" URL: "));
        jp.add((Component)jp_west, "West");
        JPanel jp_center = new JPanel(new GridLayout(2, 1));
        jp_center.add(this.jp_content_type_charset.getComponent());
        jp_center.add(UIUtil.getFlowLayoutPanelLeftAligned(this.jtf_url));
        jp.add((Component)jp_center, "Center");
        this.add(jp);
    }

    @Override
    public void enableBody() {
        this.jp_content_type_charset.enableComponent();
        this.jtf_url.setEnabled(true);
    }

    @Override
    public void disableBody() {
        this.jp_content_type_charset.disableComponent();
        this.jtf_url.setEnabled(false);
    }

    @Override
    public void setEntity(ReqEntity entity) {
        if (entity instanceof ReqEntityUrlStream) {
            ReqEntityUrlStream e = (ReqEntityUrlStream)entity;
            URL url = e.getUrl();
            this.jtf_url.setText(url.toString());
        }
    }

    @Override
    public ReqEntity getEntity() {
        try {
            URL url = new URL(this.jtf_url.getText());
            return new ReqEntityUrlStreamBean(this.jp_content_type_charset.getContentType(), url);
        }
        catch (MalformedURLException ex) {
            throw new IllegalStateException("Body Stream URL is malformed!", ex);
        }
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public void clear() {
        this.jp_content_type_charset.clear();
        this.jtf_url.setText("");
    }

    @Override
    public void requestFocus() {
        this.jp_content_type_charset.requestFocus();
    }
}

