# Copyright (C) 2011 Canonical Ltd
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA

"""Tests for saving and restoring recent history of locations"""

import os

from bzrlib.plugins.explorer import tests
from bzrlib.plugins.explorer.lib import history_manager
from bzrlib.plugins.explorer.lib.extensions import accessories


class TestHistoryManager(tests.TestCaseInTempDir):
    """Tests for the HistoryManager class"""

    def setUp(self):
        super(TestHistoryManager, self).setUp()
        directory = accessories.wallet_dir()
        os.makedirs(directory)
        self.history_filename = os.path.join(directory, "history.dat")

    # TODO: add tests for correct basic operation here

    def test_no_history_file(self):
        history = history_manager.HistoryManager()
        self.assertLength(0, history.recent_locations())
        # Not having history.dat yet is normal so there should be no log spam
        self.assertNotContainsRe(self.get_log(), "history.dat")

    def test_broken_history_empty_file(self):
        open(self.history_filename, "wb").close()
        history = history_manager.HistoryManager()
        self.assertLength(0, history.recent_locations())
        self.assertContainsRe(self.get_log(), "explorer history.*history.dat")

    def test_broken_history_zeroed_file(self):
        f = open(self.history_filename, "wb")
        try:
            f.write("\x00" * 100)
        finally:
            f.close()
        history = history_manager.HistoryManager()
        self.assertLength(0, history.recent_locations())
        self.assertContainsRe(self.get_log(), "explorer history.*history.dat")
