/*
 * Decompiled with CFR 0.152.
 */
package free.jin.action.seek;

import free.chess.Player;
import free.chess.WildVariant;
import free.jin.I18n;
import free.jin.Preferences;
import free.jin.SeekConnection;
import free.jin.UserSeek;
import free.jin.action.ActionContext;
import free.jin.action.JinAction;
import free.jin.ui.DialogPanel;
import free.util.AWTUtilities;
import free.util.TableLayout;
import free.util.swing.IntegerStrictPlainDocument;
import free.util.swing.SwingUtils;
import free.workarounds.FixedJComboBox;
import free.workarounds.FixedJTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;

public class SeekAction
extends JinAction {
    public String getId() {
        return "seek";
    }

    public String getName() {
        return this.getI18n().getString("actionName");
    }

    protected boolean isContextSupported(ActionContext actionContext) {
        return actionContext.getConnection() instanceof SeekConnection;
    }

    public void go(Object object) {
        Window window = object instanceof Component ? SwingUtilities.windowForComponent((Component)object) : null;
        UserSeek userSeek = new SeekPanel(window).getSeek();
        if (userSeek != null) {
            ((SeekConnection)this.getConn()).issueSeek(userSeek);
            this.saveSeekOptions(userSeek);
        }
    }

    private void saveSeekOptions(UserSeek userSeek) {
        Preferences preferences = this.getPrefs();
        preferences.setInt("time", userSeek.getTime());
        preferences.setInt("inc", userSeek.getInc());
        preferences.setBool("isRated", userSeek.isRated());
        preferences.setString("variant", userSeek.getVariant().getName());
        Player player = userSeek.getColor();
        preferences.setString("color", player == null ? "auto" : (player.isWhite() ? "white" : "black"));
        int n = userSeek.getMinRating();
        int n2 = userSeek.getMaxRating();
        preferences.setBool("limitRating", n != Integer.MIN_VALUE || n2 != Integer.MAX_VALUE);
        preferences.setInt("minRating", n == Integer.MIN_VALUE ? 0 : n);
        preferences.setInt("maxRating", n2 == Integer.MAX_VALUE ? 9999 : n2);
        preferences.setBool("manualAccept", userSeek.isManualAccept());
        preferences.setBool("useFormula", userSeek.isFormula());
    }

    private class SeekPanel
    extends DialogPanel {
        private final JTextField timeField;
        private final JTextField incField;
        private final JCheckBox isRatedBox;
        private final JComboBox variantChoice;
        private final JRadioButton autoColor;
        private final JRadioButton whiteColor;
        private final JRadioButton blackColor;
        private final JCheckBox limitRatingBox;
        private final JTextField minRatingField;
        private final JTextField maxRatingField;
        private final JCheckBox manualAcceptBox;
        private final JCheckBox useFormulaBox;

        public SeekPanel(Component component) {
            this.setHintParent(component);
            Preferences preferences = SeekAction.this.getPrefs();
            I18n i18n = SeekAction.this.getI18n();
            Object[] objectArray = SeekAction.this.getConn().getSupportedVariants();
            this.timeField = new FixedJTextField((Document)new IntegerStrictPlainDocument(0L, 9999L), "", 3);
            this.incField = new FixedJTextField((Document)new IntegerStrictPlainDocument(0L, 9999L), "", 3);
            this.isRatedBox = i18n.createCheckBox("ratedBox");
            this.variantChoice = new FixedJComboBox(objectArray);
            this.variantChoice.setEditable(false);
            this.autoColor = i18n.createRadioButton("autoColorRadioButton");
            this.whiteColor = i18n.createRadioButton("whiteColorRadioButton");
            this.blackColor = i18n.createRadioButton("blackColorRadioButton");
            this.limitRatingBox = i18n.createCheckBox("limitRatingCheckBox");
            this.minRatingField = new FixedJTextField((Document)new IntegerStrictPlainDocument(0L, 9999L), "", 4);
            this.maxRatingField = new FixedJTextField((Document)new IntegerStrictPlainDocument(0L, 9999L), "", 4);
            this.manualAcceptBox = i18n.createCheckBox("manualAcceptCheckBox");
            this.useFormulaBox = i18n.createCheckBox("useFormulaCheckBox");
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.autoColor);
            buttonGroup.add(this.whiteColor);
            buttonGroup.add(this.blackColor);
            String string = preferences.getString("color", "auto");
            this.timeField.setText(String.valueOf(preferences.getInt("time", 10)));
            this.incField.setText(String.valueOf(preferences.getInt("inc", 0)));
            this.isRatedBox.setSelected(preferences.getBool("isRated", true));
            this.variantChoice.setSelectedIndex(this.findVariantIndex((WildVariant[])objectArray, preferences.getString("variant", "Chess")));
            this.autoColor.setSelected("auto".equals(string));
            this.whiteColor.setSelected("white".equals(string));
            this.blackColor.setSelected("black".equals(string));
            this.limitRatingBox.setSelected(preferences.getBool("limitRating", false));
            this.minRatingField.setText(String.valueOf(preferences.getInt("minRating", 0)));
            this.maxRatingField.setText(String.valueOf(preferences.getInt("maxRating", 9999)));
            this.manualAcceptBox.setSelected(preferences.getBool("manualAccept", false));
            this.useFormulaBox.setSelected(preferences.getBool("useFormula", true));
            if (SeekAction.this.getUser().isGuest()) {
                this.isRatedBox.setSelected(false);
                this.isRatedBox.setEnabled(false);
            }
            this.createUI();
        }

        private void createUI() {
            I18n i18n = SeekAction.this.getI18n();
            JLabel jLabel = i18n.createLabel("timeLabel");
            jLabel.setLabelFor(this.timeField);
            JLabel jLabel2 = i18n.createLabel("incrementLabel");
            jLabel2.setLabelFor(this.incField);
            JLabel jLabel3 = i18n.createLabel("secondsLabel");
            JLabel jLabel4 = i18n.createLabel("minutesLabel");
            this.timeField.setMaximumSize(this.timeField.getPreferredSize());
            this.incField.setMaximumSize(this.incField.getPreferredSize());
            JPanel jPanel = new JPanel((LayoutManager)new TableLayout(5, 4, 2));
            jPanel.add(Box.createHorizontalStrut(0));
            jPanel.add(jLabel);
            jPanel.add(Box.createHorizontalStrut(10));
            jPanel.add(this.timeField);
            jPanel.add(jLabel4);
            jPanel.add(Box.createHorizontalStrut(0));
            jPanel.add(jLabel2);
            jPanel.add(Box.createHorizontalStrut(10));
            jPanel.add(this.incField);
            jPanel.add(jLabel3);
            JLabel jLabel5 = i18n.createLabel("variantLabel");
            jLabel5.setLabelFor(this.variantChoice);
            this.variantChoice.setMaximumSize(this.variantChoice.getPreferredSize());
            JPanel jPanel2 = SwingUtils.createHorizontalBox();
            jPanel2.add(Box.createHorizontalStrut(4));
            jPanel2.add(jLabel5);
            jPanel2.add(Box.createHorizontalStrut(10));
            jPanel2.add(this.variantChoice);
            jPanel2.add(Box.createHorizontalGlue());
            JLabel jLabel6 = i18n.createLabel("colorLabel");
            JPanel jPanel3 = SwingUtils.createHorizontalBox();
            jPanel3.add(Box.createHorizontalStrut(4));
            jPanel3.add(jLabel6);
            jPanel3.add(Box.createHorizontalStrut(15));
            jPanel3.add(this.autoColor);
            jPanel3.add(Box.createHorizontalStrut(10));
            jPanel3.add(this.whiteColor);
            jPanel3.add(Box.createHorizontalStrut(10));
            jPanel3.add(this.blackColor);
            jPanel3.add(Box.createHorizontalGlue());
            JLabel jLabel7 = i18n.createLabel("minRatingLabel");
            jLabel7.setLabelFor(this.minRatingField);
            JLabel jLabel8 = i18n.createLabel("maxRatingLabel");
            jLabel8.setLabelFor(this.maxRatingField);
            this.minRatingField.setMaximumSize(this.minRatingField.getPreferredSize());
            this.maxRatingField.setMaximumSize(this.minRatingField.getPreferredSize());
            JPanel jPanel4 = SwingUtils.createHorizontalBox();
            jPanel4.add(this.limitRatingBox);
            jPanel4.add(Box.createHorizontalGlue());
            final JPanel jPanel5 = SwingUtils.createHorizontalBox();
            jPanel5.add(Box.createHorizontalStrut(40));
            jPanel5.add(jLabel7);
            jPanel5.add(Box.createHorizontalStrut(10));
            jPanel5.add(this.minRatingField);
            jPanel5.add(Box.createHorizontalStrut(20));
            jPanel5.add(jLabel8);
            jPanel5.add(Box.createHorizontalStrut(10));
            jPanel5.add(this.maxRatingField);
            jPanel5.add(Box.createHorizontalGlue());
            JPanel jPanel6 = SwingUtils.createVerticalBox();
            jPanel6.add(jPanel4);
            jPanel6.add(Box.createVerticalStrut(3));
            jPanel6.add(jPanel5);
            JPanel jPanel7 = new JPanel(new FlowLayout(2));
            JButton jButton = i18n.createButton("issueSeekButton");
            JButton jButton2 = i18n.createButton("cancelButton");
            this.setDefaultButton(jButton);
            jButton2.setDefaultCapable(false);
            jPanel7.add(jButton);
            jPanel7.add(jButton2);
            JButton jButton3 = i18n.createButton("moreOptionsButton");
            jButton3.setDefaultCapable(false);
            jButton3.setActionCommand("more");
            JPanel jPanel8 = new JPanel(new FlowLayout(2));
            jPanel8.add(jButton3);
            final JPanel jPanel9 = new JPanel(new BorderLayout());
            this.setLayout(new BoxLayout((Container)((Object)this), 1));
            jPanel.setAlignmentX(0.0f);
            this.add(jPanel);
            this.add(Box.createVerticalStrut(2));
            this.isRatedBox.setAlignmentX(0.0f);
            this.add(this.isRatedBox);
            jPanel9.setAlignmentX(0.0f);
            this.add(jPanel9);
            this.add(Box.createVerticalStrut(5));
            jPanel8.setAlignmentX(0.0f);
            this.add(jPanel8);
            this.add(Box.createVerticalStrut(10));
            jPanel7.setAlignmentX(0.0f);
            this.add(jPanel7);
            final JPanel jPanel10 = SwingUtils.createVerticalBox();
            jPanel10.add(Box.createVerticalStrut(4));
            jPanel2.setAlignmentX(0.0f);
            jPanel10.add(jPanel2);
            jPanel10.add(Box.createVerticalStrut(4));
            jPanel3.setAlignmentX(0.0f);
            jPanel10.add(jPanel3);
            jPanel10.add(Box.createVerticalStrut(2));
            jPanel6.setAlignmentX(0.0f);
            jPanel10.add(jPanel6);
            jPanel10.add(Box.createVerticalStrut(2));
            this.manualAcceptBox.setAlignmentX(0.0f);
            jPanel10.add(this.manualAcceptBox);
            jPanel10.add(Box.createVerticalStrut(2));
            this.useFormulaBox.setAlignmentX(0.0f);
            jPanel10.add(this.useFormulaBox);
            AWTUtilities.setContainerEnabled((Container)jPanel5, (boolean)this.limitRatingBox.isSelected());
            this.limitRatingBox.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    AWTUtilities.setContainerEnabled((Container)jPanel5, (boolean)SeekPanel.this.limitRatingBox.isSelected());
                }
            });
            jButton3.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (actionEvent.getActionCommand().equals("more")) {
                        JButton jButton = (JButton)actionEvent.getSource();
                        jButton.setText(SeekAction.this.getI18n().getString("lessOptionsButton.text"));
                        jButton.setActionCommand("less");
                        jPanel9.add((Component)jPanel10, "Center");
                        SeekPanel.this.resizeContainerToFit();
                    } else {
                        JButton jButton = (JButton)actionEvent.getSource();
                        jButton.setText(SeekAction.this.getI18n().getString("moreOptionsButton.text"));
                        jButton.setActionCommand("more");
                        jPanel9.remove(jPanel10);
                        SeekPanel.this.resizeContainerToFit();
                    }
                }
            });
            jButton2.addActionListener((ActionListener)new DialogPanel.ClosingListener((DialogPanel)this, null));
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    int n;
                    int n2;
                    Player player;
                    int n3;
                    int n4;
                    try {
                        n4 = Integer.parseInt(SeekPanel.this.timeField.getText());
                    }
                    catch (NumberFormatException numberFormatException) {
                        SeekAction.this.getI18n().error("timeError");
                        return;
                    }
                    try {
                        n3 = Integer.parseInt(SeekPanel.this.incField.getText());
                    }
                    catch (NumberFormatException numberFormatException) {
                        SeekAction.this.getI18n().error("incError");
                        return;
                    }
                    boolean bl = SeekPanel.this.isRatedBox.isSelected();
                    WildVariant wildVariant = (WildVariant)SeekPanel.this.variantChoice.getSelectedItem();
                    Player player2 = SeekPanel.this.autoColor.isSelected() ? null : (player = SeekPanel.this.whiteColor.isSelected() ? Player.WHITE_PLAYER : Player.BLACK_PLAYER);
                    if (SeekPanel.this.limitRatingBox.isSelected()) {
                        try {
                            n2 = Integer.parseInt(SeekPanel.this.minRatingField.getText());
                        }
                        catch (NumberFormatException numberFormatException) {
                            SeekAction.this.getI18n().error("minRatingError");
                            return;
                        }
                        try {
                            n = Integer.parseInt(SeekPanel.this.maxRatingField.getText());
                        }
                        catch (NumberFormatException numberFormatException) {
                            SeekAction.this.getI18n().error("maxRatingError");
                            return;
                        }
                    }
                    n2 = Integer.MIN_VALUE;
                    n = Integer.MAX_VALUE;
                    boolean bl2 = SeekPanel.this.manualAcceptBox.isSelected();
                    boolean bl3 = SeekPanel.this.useFormulaBox.isSelected();
                    SeekPanel.this.close(new UserSeek(n4, n3, bl, wildVariant, player, n2, n, bl2, bl3));
                }
            });
        }

        private int findVariantIndex(WildVariant[] wildVariantArray, String string) {
            for (int i = 0; i < wildVariantArray.length; ++i) {
                if (!wildVariantArray[i].getName().equals(string)) continue;
                return i;
            }
            return -1;
        }

        public String getTitle() {
            return SeekAction.this.getI18n().getString("dialogTitle");
        }

        public UserSeek getSeek() {
            return (UserSeek)this.askResult();
        }
    }
}

