/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __SG_PLOT_WINDOW_H__
#define __SG_PLOT_WINDOW_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include <gtk/gtk.h>
#include <gtkextra/gtkextra.h>

#include "sg_widgets_enums.h"
#include "sg_plot.h"
#include "sg_layer.h"

#define GTK_TYPE_SG_PLOT_WINDOW                  (sg_plot_window_get_type ())
#define SG_PLOT_WINDOW(obj)                  (GTK_CHECK_CAST ((obj), GTK_TYPE_SG_PLOT_WINDOW, SGplotWindow))
#define SG_PLOT_WINDOW_CLASS(klass)          (GTK_CHECK_CLASS_CAST ((klass), GTK_TYPE_SG_PLOT_WINDOW, SGplotWindowClass))
#define GTK_IS_SG_PLOT_WINDOW(obj)               (GTK_CHECK_TYPE ((obj), GTK_TYPE_SG_PLOT_WINDOW))
#define GTK_IS_SG_PLOT_WINDOW_CLASS(klass)       (GTK_CHECK_CLASS_TYPE ((klass), GTK_TYPE_SG_PLOT_WINDOW))


typedef struct _SGplotWindowClass SGplotWindowClass;

struct _SGplotWindowClass
{
  GtkWindowClass parent_class;
};

typedef struct _SGplotWindow SGplotWindow;
struct _SGplotWindow 
{
  GtkWindow window;

  gint x, y, width, height;
  
  gboolean is_mapped;

  SGplot *plot;

  GtkWidget *sw;
  GtkWidget *canvas_box;
  GtkWidget *toolbox;
  GtkWidget *layer_toolbar;
  GtkWidget *layer_buttons;
  GtkWidget *layer_bbox;
  GtkWidget *datasets_combo;
  GtkWidget *label;
  GtkWidget *hruler;
  GtkWidget *vruler;

  GtkWidget *menu;

  gboolean show_menubar;
  gboolean show_toolbar;
};

GtkType         sg_plot_window_get_type                 (void);
SGplotWindow   *sg_plot_window_new                     (SGplot *plot);
void            sg_plot_window_remove                   (SGplotWindow *window,
							 SGplot *plot); 
void            sg_plot_window_add                      (SGplotWindow *window,
							 SGplot *plot); 
void            sg_plot_window_set_toolbar_visible      (SGplotWindow *window,
							 gboolean visible); 
void            sg_plot_window_set_menubar_visible      (SGplotWindow *window,
							 gboolean visible); 
void            sg_plot_window_update_rulers            (SGplotWindow *window);
void            sg_plot_window_fit_page                 (SGplotWindow *window);
void            sg_plot_window_fit_page_h               (SGplotWindow *window);
void            sg_plot_window_fit_page_v               (SGplotWindow *window);
void            sg_plot_window_show_top_toolbar		(SGplotWindow *window);
#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __SG_PLOT_WINDOW_H__ */

