/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ic.doc.scenebeans.bounds;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import uk.ac.ic.doc.scenebeans.CompositeNode;
import uk.ac.ic.doc.scenebeans.Input;
import uk.ac.ic.doc.scenebeans.Primitive;
import uk.ac.ic.doc.scenebeans.SceneGraph;
import uk.ac.ic.doc.scenebeans.SceneGraphProcessor;
import uk.ac.ic.doc.scenebeans.Style;
import uk.ac.ic.doc.scenebeans.Transform;

public class Bounds
implements SceneGraphProcessor {
    private Rectangle2D _bounds = null;
    private Graphics2D _graphics;
    private AffineTransform _transform;

    public static Rectangle2D getBounds(SceneGraph sceneGraph, Graphics2D graphics2D) {
        Bounds bounds = new Bounds(graphics2D);
        sceneGraph.accept(bounds);
        return bounds.getBounds();
    }

    public Bounds(Graphics2D graphics2D) {
        this._graphics = graphics2D;
        this._transform = new AffineTransform();
    }

    public Bounds(Graphics2D graphics2D, AffineTransform affineTransform) {
        this._graphics = graphics2D;
        this._transform = new AffineTransform(affineTransform);
    }

    public Rectangle2D getBounds() {
        return this._bounds;
    }

    public Graphics2D getGraphics() {
        return this._graphics;
    }

    public AffineTransform getTransform() {
        return new AffineTransform(this._transform);
    }

    public void process(Primitive primitive) {
        GeneralPath generalPath = new GeneralPath(primitive.getShape(this._graphics));
        generalPath.transform(this._transform);
        this.addBounds(generalPath.getBounds2D());
    }

    public void process(Transform transform) {
        AffineTransform affineTransform = new AffineTransform(this._transform);
        this._transform.concatenate(transform.getTransform());
        transform.getTransformedGraph().accept(this);
        this._transform = affineTransform;
    }

    public void process(Input input) {
        input.getSensitiveGraph().accept(this);
    }

    public void process(Style style) {
        Style.Change change = style.changeStyle(this._graphics);
        style.getStyledGraph().accept(this);
        change.restoreStyle(this._graphics);
    }

    public void process(CompositeNode compositeNode) {
        int n = 0;
        while (n < compositeNode.getVisibleSubgraphCount()) {
            compositeNode.getVisibleSubgraph(n).accept(this);
            ++n;
        }
    }

    protected void addBounds(Rectangle2D rectangle2D) {
        if (rectangle2D != null) {
            if (this._bounds == null) {
                this._bounds = rectangle2D;
            } else {
                this._bounds.add(rectangle2D);
            }
        }
    }
}

