define("core/moodlenet/send_resource",["exports","core/config","core/notification","core/str","core/prefetch","core/templates","core/pubsub","core/moodlenet/service","core/moodlenet/send_activity_modal","core/moodlenet/authorize","core/moodlenet/events"],(function(_exports,_config,_notification,_str,_prefetch,Templates,_pubsub,MoodleNetService,_send_activity_modal,MoodleNetAuthorize,_events){function _getRequireWildcardCache(nodeInterop){if("function"!=typeof WeakMap)return null;var cacheBabelInterop=new WeakMap,cacheNodeInterop=new WeakMap;return(_getRequireWildcardCache=function(nodeInterop){return nodeInterop?cacheNodeInterop:cacheBabelInterop})(nodeInterop)}function _interopRequireWildcard(obj,nodeInterop){if(!nodeInterop&&obj&&obj.__esModule)return obj;if(null===obj||"object"!=typeof obj&&"function"!=typeof obj)return{default:obj};var cache=_getRequireWildcardCache(nodeInterop);if(cache&&cache.has(obj))return cache.get(obj);var newObj={},hasPropertyDescriptor=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var key in obj)if("default"!==key&&Object.prototype.hasOwnProperty.call(obj,key)){var desc=hasPropertyDescriptor?Object.getOwnPropertyDescriptor(obj,key):null;desc&&(desc.get||desc.set)?Object.defineProperty(newObj,key,desc):newObj[key]=obj[key]}return newObj.default=obj,cache&&cache.set(obj,newObj),newObj}function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/**
   * A module to handle Share operations of the MoodleNet.
   *
   * @module     core/moodlenet/send_resource
   * @copyright  2023 Huong Nguyen <huongnv13@gmail.com>
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   * @since      4.2
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.sendToMoodleNet=_exports.init=_exports.handleModal=void 0,_config=_interopRequireDefault(_config),_prefetch=_interopRequireDefault(_prefetch),Templates=_interopRequireWildcard(Templates),MoodleNetService=_interopRequireWildcard(MoodleNetService),_send_activity_modal=_interopRequireDefault(_send_activity_modal),MoodleNetAuthorize=_interopRequireWildcard(MoodleNetAuthorize),_events=_interopRequireDefault(_events);let currentModal,siteSupportUrl,issuerId,courseId,resourceId,shareFormat,type,selectedCmIds,listenersRegistered=!1;_exports.sendToMoodleNet=(issuerId,resourceId,shareFormat)=>{const modal=currentModal.getModal()[0];let infoPromise;modal.querySelector(".modal-header").classList.remove("no-border"),modal.querySelector(".modal-header").classList.add("no-header-text"),currentModal.setBody(Templates.render("core/moodlenet/send_activity_modal_packaging",{})),currentModal.hideFooter(),"activity"===type?infoPromise=MoodleNetService.sendActivity(issuerId,resourceId,shareFormat):"course"===type?infoPromise=MoodleNetService.sendCourse(issuerId,resourceId,shareFormat):"partial"===type&&(infoPromise=selectedCmIds.length>1?MoodleNetService.sendPartialCourse(issuerId,resourceId,selectedCmIds,shareFormat):MoodleNetService.sendActivity(issuerId,selectedCmIds[0],shareFormat)),infoPromise.then((async data=>{const status=data.status,resourceUrl=data.resourceurl;return responseFromMoodleNet(status,resourceUrl)})).catch(_notification.exception)};const responseFromMoodleNet=function(status){let resourceUrl=arguments.length>1&&void 0!==arguments[1]?arguments[1]:"";const $modal=currentModal.getModal(),modal=$modal[0];modal.querySelector(".modal-header").classList.add("no-border"),currentModal.setBody(Templates.render("core/moodlenet/send_activity_modal_done",{success:status,sitesupporturl:siteSupportUrl})),status&&(currentModal.setFooter(Templates.render("core/moodlenet/send_activity_modal_footer_view",{resourceurl:resourceUrl})),currentModal.showFooter())},renderModal=async(data,selectedActivities)=>{if(data.status){siteSupportUrl=data.supportpageurl,issuerId=data.issuerid;let modalConfig={templateContext:{activitytype:data.type,activityname:data.name,server:data.server}};return selectedActivities.length>0&&(selectedCmIds=selectedActivities),selectedActivities.length>1?(modalConfig.templateContext.fullsharing=!1,modalConfig.templateContext.selectedactivitiesnotice=await(0,_str.getString)("moodlenet:sharenoticepartialactivitynumber","moodle",selectedActivities.length),modalConfig.templateContext.sharenotice=await(0,_str.getString)("moodlenet:sharenoticepartial","moodle")):(modalConfig.templateContext.fullsharing=!0,"activity"===type||"partial"===type&&1==selectedActivities.length?modalConfig.templateContext.sharenotice=await(0,_str.getString)("moodlenet:sharenoticeactivity","moodle"):modalConfig.templateContext.sharenotice=await(0,_str.getString)("moodlenet:sharenoticecourse","moodle")),_send_activity_modal.default.create(modalConfig)}return(0,_notification.addNotification)({message:data.warnings[0].message,type:"error"})},handleModal=function(shareActionType){let selectedActivities=arguments.length>1&&void 0!==arguments[1]?arguments[1]:[];const resourceId=_config.default.contextInstanceId;type=shareActionType,Promise.resolve(type).then((type=>{if("activity"===type)return MoodleNetService.getActivityInformation(resourceId);if("course"===type)return MoodleNetService.getCourseInformation(resourceId);if("partial"===type)return selectedActivities.length>1?MoodleNetService.getCourseInformation(resourceId):MoodleNetService.getActivityInformation(selectedActivities[0]);throw new Error("Unknown type ".concat(type))})).then((data=>renderModal(data,selectedActivities))).then((modal=>(currentModal=modal,currentModal))).catch(_notification.exception)};_exports.handleModal=handleModal;_exports.init=()=>{listenersRegistered||(_prefetch.default.prefetchTemplates(["core/moodlenet/send_activity_modal_base","core/moodlenet/send_activity_modal_packaging","core/moodlenet/send_activity_modal_done","core/moodlenet/send_activity_modal_footer_view","core/moodlenet/send_activity_modal_footer_share"]),document.addEventListener("click",(e=>{const shareAction=e.target.closest('[data-action="sendtomoodlenet"]'),sendAction=e.target.closest('.moodlenet-action-buttons [data-action="share"]');shareAction&&(e.preventDefault(),type=shareAction.getAttribute("data-type"),handleModal(shareAction.getAttribute("data-type"))),sendAction&&(e.preventDefault(),(0,_pubsub.publish)(_events.default.MOODLENET_SHARE_STARTED,{}),courseId=_config.default.courseId,resourceId=_config.default.contextInstanceId,shareFormat=0,MoodleNetAuthorize.handleAuthorization(issuerId,courseId,resourceId,0))})),listenersRegistered=!0)}}));

//# sourceMappingURL=send_resource.min.js.map