/*
 * This file is part of the TYPO3 CMS project.
 *
 * It is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, either version 2
 * of the License, or any later version.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * The TYPO3 project - inspiring people to share!
 */
import"bootstrap";import{AbstractInteractableModule}from"@typo3/install/module/abstract-interactable-module.js";import AjaxRequest from"@typo3/core/ajax/ajax-request.js";import{FlashMessage}from"@typo3/install/renderable/flash-message.js";import{InfoBox}from"@typo3/install/renderable/info-box.js";import"@typo3/install/renderable/language-packs.js";import Severity from"@typo3/install/renderable/severity.js";import Router from"@typo3/install/router.js";var Identifiers;!function(t){t.outputContainer=".t3js-languagePacks-output",t.contentContainer=".t3js-languagePacks-mainContent",t.notifications=".t3js-languagePacks-notifications"}(Identifiers||(Identifiers={}));class LanguagePacks extends AbstractInteractableModule{constructor(){super(...arguments),this.activeLanguages=[],this.activeExtensions=[],this.packsUpdateDetails={toHandle:0,handled:0,updated:0,new:0,failed:0,skipped:0},this.notifications=[]}static pluralize(t,e="pack",a="s",i=0){return 1!==t&&1!==i?e+a:e}initialize(t){super.initialize(t),Promise.all([this.loadModuleFrameAgnostic("@typo3/install/renderable/info-box.js"),this.loadModuleFrameAgnostic("@typo3/install/renderable/flash-message.js"),this.loadModuleFrameAgnostic("@typo3/install/renderable/language-packs.js")]).then((()=>{this.getData()}))}getData(){const t=this.getModalBody();new AjaxRequest(Router.getUrl("languagePacksGetData")).get({cache:"no-cache"}).then((async e=>{const a=await e.resolve(),{success:i,html:s,...n}=a;if(!0===i){this.activeLanguages=a.activeLanguages,this.activeExtensions=a.activeExtensions,t.innerHTML=s;const e=t.parentElement.querySelector(Identifiers.contentContainer);e.innerHTML="";const i=window.location!==window.parent.location?parent.document:document,o=i.createElement("typo3-install-language-matrix");o.data=n,"true"===this.getModuleContent().dataset.configurationIsWritable&&o.setAttribute("configurationIsWritable",""),o.addEventListener("activate-language",(t=>{this.activateLanguage(t.detail.iso)})),o.addEventListener("deactivate-language",(t=>{this.deactivateLanguage(t.detail.iso)})),o.addEventListener("download-packs",(t=>{this.updatePacks(t.detail?.iso||void 0,void 0)}));const d=i.createElement("typo3-install-extension-matrix");d.data=n,d.addEventListener("download-packs",(t=>{this.updatePacks(t.detail?.iso||void 0,t.detail?.extension||void 0)})),e.append(o,d)}else this.addNotification(InfoBox.create(Severity.error,"Something went wrong"));this.renderNotifications()}),(e=>{Router.handleAjaxError(e,t)}))}activateLanguage(t){const e=this.getModalBody(),a=this.findInModal(Identifiers.outputContainer);this.renderProgressBar(a),this.getNotificationBox().innerHTML="",new AjaxRequest(Router.getUrl()).post({install:{action:"languagePacksActivateLanguage",token:this.getModuleContent().dataset.languagePacksActivateLanguageToken,iso:t}}).then((async t=>{const e=await t.resolve();a.innerHTML="",!0===e.success&&Array.isArray(e.status)?e.status.forEach((t=>{this.addNotification(InfoBox.create(t.severity,t.title,t.message))})):this.addNotification(InfoBox.create(Severity.error,"Something went wrong")),this.getData()}),(t=>{Router.handleAjaxError(t,e)}))}deactivateLanguage(t){const e=this.getModalBody(),a=this.findInModal(Identifiers.outputContainer);this.renderProgressBar(a),this.getNotificationBox().innerHTML="",new AjaxRequest(Router.getUrl()).post({install:{action:"languagePacksDeactivateLanguage",token:this.getModuleContent().dataset.languagePacksDeactivateLanguageToken,iso:t}}).then((async t=>{const e=await t.resolve();a.innerHTML="",!0===e.success&&Array.isArray(e.status)?e.status.forEach((t=>{this.addNotification(InfoBox.create(t.severity,t.title,t.message))})):this.addNotification(InfoBox.create(Severity.error,"Something went wrong")),this.getData()}),(t=>{Router.handleAjaxError(t,e)}))}updatePacks(t,e){const a=this.findInModal(Identifiers.outputContainer),i=this.findInModal(Identifiers.contentContainer),s=void 0===t?this.activeLanguages:[t];let n=!0,o=this.activeExtensions;void 0!==e&&(o=[e],n=!1),this.packsUpdateDetails={toHandle:s.length*o.length,handled:0,updated:0,new:0,failed:0,skipped:0};const d=this.renderProgressBar(a,1===this.packsUpdateDetails.toHandle?void 0:{value:0,max:this.packsUpdateDetails.toHandle,label:"0 of "+this.packsUpdateDetails.toHandle+" language "+LanguagePacks.pluralize(this.packsUpdateDetails.toHandle)+" updated"});i.innerHTML="",s.forEach((t=>{o.forEach((e=>{this.getNotificationBox().innerHTML="",new AjaxRequest(Router.getUrl()).post({install:{action:"languagePacksUpdatePack",token:this.getModuleContent().dataset.languagePacksUpdatePackToken,iso:t,extension:e}}).then((async t=>{const e=await t.resolve();!0===e.success?(this.packsUpdateDetails.handled++,"new"===e.packResult?this.packsUpdateDetails.new++:"update"===e.packResult?this.packsUpdateDetails.updated++:"skipped"===e.packResult?this.packsUpdateDetails.skipped++:this.packsUpdateDetails.failed++,this.packUpdateDone(n,s,d)):(this.packsUpdateDetails.handled++,this.packsUpdateDetails.failed++,this.packUpdateDone(n,s,d))}),(()=>{this.packsUpdateDetails.handled++,this.packsUpdateDetails.failed++,this.packUpdateDone(n,s,d)}))}))}))}packUpdateDone(t,e,a){const i=this.getModalBody();this.packsUpdateDetails.handled===this.packsUpdateDetails.toHandle?(this.addNotification(InfoBox.create(Severity.ok,"Language packs updated",this.packsUpdateDetails.new+" new language "+LanguagePacks.pluralize(this.packsUpdateDetails.new)+" downloaded, "+this.packsUpdateDetails.updated+" language "+LanguagePacks.pluralize(this.packsUpdateDetails.updated)+" updated, "+this.packsUpdateDetails.skipped+" language "+LanguagePacks.pluralize(this.packsUpdateDetails.skipped)+" skipped, "+this.packsUpdateDetails.failed+" language "+LanguagePacks.pluralize(this.packsUpdateDetails.failed)+" not available")),!0===t?new AjaxRequest(Router.getUrl()).post({install:{action:"languagePacksUpdateIsoTimes",token:this.getModuleContent().dataset.languagePacksUpdateIsoTimesToken,isos:e}}).then((async t=>{!0===(await t.resolve()).success?this.getData():this.addNotification(FlashMessage.create(Severity.error,"Something went wrong"))}),(t=>{Router.handleAjaxError(t,i)})):this.getData()):(a.value=this.packsUpdateDetails.handled,a.label=this.packsUpdateDetails.handled+" of "+this.packsUpdateDetails.toHandle+" language "+LanguagePacks.pluralize(this.packsUpdateDetails.handled,"pack","s",this.packsUpdateDetails.toHandle)+" updated")}getNotificationBox(){return this.findInModal(Identifiers.notifications)}addNotification(t){this.notifications.push(t)}renderNotifications(){const t=this.getNotificationBox();for(const e of this.notifications)t.appendChild(e);this.notifications=[]}}export default new LanguagePacks;