/*
 * This file is part of the TYPO3 CMS project.
 *
 * It is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, either version 2
 * of the License, or any later version.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * The TYPO3 project - inspiring people to share!
 */
import"bootstrap";import AjaxRequest from"@typo3/core/ajax/ajax-request.js";import{AbstractInteractableModule}from"@typo3/install/module/abstract-interactable-module.js";import Modal from"@typo3/backend/modal.js";import Notification from"@typo3/backend/notification.js";import AjaxQueue from"@typo3/install/ajax/ajax-queue.js";import Router from"@typo3/install/router.js";import RegularEvent from"@typo3/core/event/regular-event.js";var Identifiers;!function(e){e.extensionContainer=".t3js-extensionScanner-extension",e.numberOfFiles=".t3js-extensionScanner-number-of-files",e.scanSingleTrigger=".t3js-extensionScanner-scan-single",e.extensionScanButton=".t3js-extensionScanner-scan-all"}(Identifiers||(Identifiers={}));class ExtensionScanner extends AbstractInteractableModule{constructor(){super(...arguments),this.listOfAffectedRestFileHashes=[]}initialize(e){super.initialize(e),Promise.all([this.loadModuleFrameAgnostic("@typo3/backend/element/progress-bar-element.js")]).then((()=>{this.getData()})),new RegularEvent("typo3-modal-hide",(()=>{AjaxQueue.flush()})).bindTo(e),new RegularEvent("click",((e,n)=>{e.preventDefault();const t=n.closest(Identifiers.extensionContainer).dataset.extension;this.scanSingleExtension(t)})).delegateTo(e,Identifiers.scanSingleTrigger),new RegularEvent("click",(n=>{n.preventDefault(),this.setModalButtonsState(!1);const t=e.querySelectorAll(Identifiers.extensionContainer);this.scanAll(t)})).delegateTo(e,Identifiers.extensionScanButton)}getData(){const e=this.getModalBody();new AjaxRequest(Router.getUrl("extensionScannerGetData")).get().then((async n=>{const t=await n.resolve();!0===t.success?(e.innerHTML=t.html,Modal.setButtons(t.buttons),this.setupEventListeners()):Notification.error("Something went wrong","The request was not processed successfully. Please check the browser's console and TYPO3's log.")}),(n=>{Router.handleAjaxError(n,e)}))}setupEventListeners(){this.currentModal.querySelectorAll(Identifiers.extensionContainer).forEach((e=>{new RegularEvent("show.bs.collapse",(e=>{const n=e.currentTarget;if(void 0===n.dataset.scanned){const e=n.dataset.extension;this.scanSingleExtension(e),n.dataset.scanned=String(!0)}})).bindTo(e)}))}getExtensionSelector(e){return Identifiers.extensionContainer+"-"+e}async scanAll(e){e.forEach((e=>{e.classList.remove("panel-danger","panel-warning","panel-success");const n=e.querySelector(".panel-progress-bar");n.style.width=String(0),n.setAttribute("aria-valuenow",String(0)),n.querySelector("span").innerText="0%"})),this.setProgressForAll();const n=[...e].map((async e=>{const n=e.dataset.extension;try{await this.scanSingleExtension(n)}finally{e.dataset.scanned=String(!0)}}));try{await Promise.allSettled(n)}finally{this.setModalButtonsState(!0),Notification.success("Scan finished","All extensions have been scanned.");try{const e=await new AjaxRequest(Router.getUrl()).post({install:{action:"extensionScannerMarkFullyScannedRestFiles",token:this.getModuleContent().dataset.extensionScannerMarkFullyScannedRestFilesToken,hashes:Array.from(new Set(this.listOfAffectedRestFileHashes))}}),n=await e.resolve();!0===n.success&&Notification.success("Marked not affected files","Marked "+n.markedAsNotAffected+" ReST files as not affected.")}catch(e){Router.handleAjaxError(e,this.getModalBody())}}}setStatusMessageForScan(e,n,t){this.findInModal(this.getExtensionSelector(e)).querySelector(Identifiers.numberOfFiles).innerText="Checked "+n+" of "+t+" files"}setProgressForScan(e,n,t){const s=n/t*100,a=this.findInModal(this.getExtensionSelector(e)).querySelector(".panel-progress-bar");a.style.width=s+"%",a.setAttribute("aria-valuenow",String(s)),a.querySelector("span").innerText=s+"%"}setProgressForAll(){const e=this.currentModal.querySelectorAll(Identifiers.extensionContainer).length,n=this.currentModal.querySelectorAll(Identifiers.extensionContainer+".t3js-extensionscan-finished").length,t=`Scanning extensions (${n} of ${e} done)…`,s=this.findInModal(".t3js-extensionScanner-progress-all-extension");s.removeAttribute("hidden"),s.max=e,s.value=n,s.label=t}async scanSingleExtension(e){const n=this.getModuleContent().dataset.extensionScannerFilesToken,t=this.getModalBody(),s=this.findInModal(this.getExtensionSelector(e));let a=!1;s.classList.add("panel-default"),s.classList.remove("panel-danger","panel-warning","panel-success","t3js-extensionscan-finished"),s.dataset.hasRun=String("true");const i=s.querySelector(".t3js-extensionScanner-scan-single");i.innerText="Scanning...",i.disabled=!0,s.querySelector(".t3js-extensionScanner-extension-body-loc").innerText="0",s.querySelector(".t3js-extensionScanner-extension-body-ignored-files").innerText="0",s.querySelector(".t3js-extensionScanner-extension-body-ignored-lines").innerText="0",this.setProgressForAll();try{const i=await new AjaxRequest(Router.getUrl()).post({install:{action:"extensionScannerFiles",token:n,extension:e}}),r=await i.resolve();if(!0===r.success&&Array.isArray(r.files)){const n=r.files.length;if(n<=0)return void Notification.warning("No files found","The extension "+e+" contains no scannable files");this.setStatusMessageForScan(e,0,n),s.querySelector(".t3js-extensionScanner-extension-body").innerText="",s.classList.add("panel-has-progress");let i=0;const o=r.files.map((r=>new Promise(((o,l)=>{AjaxQueue.add({method:"POST",data:{install:{action:"extensionScannerScanFile",token:this.getModuleContent().dataset.extensionScannerScanFileToken,extension:e,file:r}},url:Router.getUrl(),onfulfilled:async l=>{const c=await l.resolve();if(i++,this.setStatusMessageForScan(e,i,n),this.setProgressForScan(e,i,n),c.success&&Array.isArray(c.matches)&&c.matches.forEach((e=>{a=!0;const n=t.querySelector("#t3js-extensionScanner-file-hit-template .panel").cloneNode(!0);n.querySelector(".t3js-extensionScanner-hit-file-panel-head").setAttribute("data-bs-target","#collapse"+e.uniqueId),n.querySelector(".t3js-extensionScanner-hit-file-panel-head").setAttribute("aria-controls","collapse"+e.uniqueId),n.querySelector(".t3js-extensionScanner-hit-file-panel-body").setAttribute("id","collapse"+e.uniqueId),n.querySelector(".t3js-extensionScanner-hit-filename").innerText=r,n.querySelector(".t3js-extensionScanner-hit-message").innerText=e.message,"strong"===e.indicator?n.querySelector(".t3js-extensionScanner-hit-file-panel-head .t3js-extensionScanner-hit-badges").innerHTML+='<span class="badge badge-danger" title="Reliable match, false positive unlikely">strong</span>':n.querySelector(".t3js-extensionScanner-hit-file-panel-head .t3js-extensionScanner-hit-badges").innerHTML+='<span class="badge badge-warning" title="Probable match, but can be a false positive">weak</span>',!0===e.silenced&&(n.querySelector(".t3js-extensionScanner-hit-file-panel-head .t3js-extensionScanner-hit-badges").innerHTML+='<span class="badge badge-info" title="Match has been annotated by extension author as false positive match">silenced</span>'),n.querySelector(".t3js-extensionScanner-hit-file-lineContent").innerText=e.lineContent,n.querySelector(".t3js-extensionScanner-hit-file-line").innerText=e.line+": ",Array.isArray(e.restFiles)&&e.restFiles.forEach((e=>{const s=t.querySelector("#t3js-extensionScanner-file-hit-rest-template .panel").cloneNode(!0);s.querySelector(".t3js-extensionScanner-hit-rest-panel-head").setAttribute("data-bs-target","#collapse"+e.uniqueId),s.querySelector(".t3js-extensionScanner-hit-rest-panel-head").setAttribute("aria-controls","collapse"+e.uniqueId),s.querySelector(".t3js-extensionScanner-hit-rest-panel-head .t3js-extensionScanner-hit-rest-badge").innerText=e.version,s.querySelector(".t3js-extensionScanner-hit-rest-panel-body").setAttribute("id","collapse"+e.uniqueId),s.querySelector(".t3js-extensionScanner-hit-rest-headline").innerText=e.headline,s.querySelector(".t3js-extensionScanner-hit-rest-body").innerText=e.content,s.classList.add("panel-"+e.class),n.querySelector(".t3js-extensionScanner-hit-file-rest-container").append(s),this.listOfAffectedRestFileHashes.push(e.file_hash)}));const i=n.querySelectorAll(".panel-breaking, .t3js-extensionScanner-hit-file-rest-container").length>0?"panel-danger":"panel-warning";n.classList.add(i),n.classList.remove("panel-default");const o=s.querySelector(".t3js-extensionScanner-extension-body");o.classList.remove("hide"),o.append(n),s.classList.remove("panel-default"),"panel-danger"===i&&(s.classList.remove("panel-warning"),s.classList.add(i)),"panel-warning"!==i||s.classList.contains("panel-danger")||s.classList.add(i)})),c.success){const e=parseInt(s.querySelector(".t3js-extensionScanner-extension-body-loc").innerText,10);if(s.querySelector(".t3js-extensionScanner-extension-body-loc").innerText=String(e+c.effectiveCodeLines),c.isFileIgnored){const e=parseInt(s.querySelector(".t3js-extensionScanner-extension-body-ignored-files").innerText,10);s.querySelector(".t3js-extensionScanner-extension-body-ignored-files").innerText=String(e+1)}const n=parseInt(s.querySelector(".t3js-extensionScanner-extension-body-ignored-lines").innerText,10);s.querySelector(".t3js-extensionScanner-extension-body-ignored-lines").innerText=String(n+c.ignoredLines)}o()},onrejected:t=>{l(),i+=1,this.setStatusMessageForScan(e,i,n),this.setProgressForScan(e,i,n),s.classList.remove("panel-has-progress"),this.setProgressForAll(),console.error(t)}})}))));await Promise.allSettled(o),a||(s.classList.remove("panel-default"),s.classList.add("panel-success")),s.classList.add("t3js-extensionscan-finished"),s.classList.remove("panel-has-progress"),this.setProgressForAll();const l=s.querySelector(".t3js-extensionScanner-scan-single");l.innerText="Rescan",l.disabled=!1}else Notification.error("Oops, an error occurred","Please look at the browser console output for details"),console.error(r)}catch(e){Router.handleAjaxError(e,t)}}}export default new ExtensionScanner;