/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.presenter;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Area;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.diylc.appframework.miscutils.ConfigurationManager;
import org.diylc.appframework.simplemq.MessageDispatcher;
import org.diylc.common.DrawOption;
import org.diylc.common.EventType;
import org.diylc.common.GridType;
import org.diylc.common.IComponentFiler;
import org.diylc.common.ObjectCache;
import org.diylc.core.ComponentState;
import org.diylc.core.IDIYComponent;
import org.diylc.core.Project;
import org.diylc.core.Theme;
import org.diylc.core.VisibilityPolicy;
import org.diylc.presenter.G2DWrapper;
import org.diylc.utils.Constants;

public class DrawingManager {
    private static final Logger LOG = Logger.getLogger(DrawingManager.class);
    public static int CONTROL_POINT_SIZE = 7;
    public static final String ZOOM_KEY = "zoom";
    public static String DEBUG_COMPONENT_AREAS = "org.diylc.debugComponentAreas";
    public static Color CONTROL_POINT_COLOR = Color.blue;
    public static Color SELECTED_CONTROL_POINT_COLOR = Color.green;
    private Theme theme = (Theme)ConfigurationManager.getInstance().readObject("theme", (Object)Constants.DEFAULT_THEME);
    private Map<IDIYComponent<?>, Area> componentAreaMap;
    private Map<IDIYComponent<?>, ComponentState> lastDrawnStateMap;
    private Composite slotComposite = AlphaComposite.getInstance(3, 0.3f);
    private Composite lockedComposite = AlphaComposite.getInstance(3, 0.3f);
    private List<IDIYComponent<?>> failedComponents = new ArrayList();
    private double zoomLevel = 1.0;
    private MessageDispatcher<EventType> messageDispatcher;
    private boolean debugComponentAreas;

    public DrawingManager(MessageDispatcher<EventType> messageDispatcher) {
        this.messageDispatcher = messageDispatcher;
        this.componentAreaMap = new HashMap();
        this.lastDrawnStateMap = new HashMap();
        String string = System.getProperty(DEBUG_COMPONENT_AREAS);
        this.debugComponentAreas = string != null && string.equalsIgnoreCase("true");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IDIYComponent<?>> drawProject(Graphics2D graphics2D, Project project, Set<DrawOption> set, IComponentFiler iComponentFiler, Rectangle rectangle, List<IDIYComponent<?>> list, Set<IDIYComponent<?>> set2, Set<IDIYComponent<?>> set3, List<Point> list2, List<IDIYComponent<?>> list3, boolean bl) {
        Object object;
        this.failedComponents.clear();
        if (project == null) {
            return this.failedComponents;
        }
        G2DWrapper g2DWrapper = new G2DWrapper(graphics2D);
        if (set.contains((Object)DrawOption.ANTIALIASING)) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        } else {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        }
        if (ConfigurationManager.getInstance().readBoolean("hiQualityRender", false)) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
            graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
            graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            graphics2D.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        } else {
            graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
            graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
            graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            graphics2D.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        }
        double d = 1.0;
        d = set.contains((Object)DrawOption.ZOOM) ? this.zoomLevel : 1.0 / Constants.PIXEL_SIZE;
        Dimension dimension = this.getCanvasDimensions(project, d, true);
        g2DWrapper.setColor(this.theme.getBgColor());
        g2DWrapper.fillRect(0, 0, dimension.width, dimension.height);
        graphics2D.clip(new Rectangle(new Point(0, 0), dimension));
        GridType gridType = GridType.LINES;
        if (set.contains((Object)DrawOption.GRID) && gridType != GridType.NONE) {
            double d2;
            double d3 = project.getGridSpacing().convertToPixels() * d;
            if (gridType == GridType.CROSSHAIR) {
                graphics2D.setStroke(new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{(float)d3 / 2.0f, (float)d3 / 2.0f}, (float)d3 / 4.0f));
            } else if (gridType == GridType.DOT) {
                graphics2D.setStroke(new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{1.0f, (float)d3 - 1.0f}, 0.0f));
            }
            g2DWrapper.setColor(this.theme.getGridColor());
            for (d2 = d3; d2 < (double)dimension.width; d2 += d3) {
                g2DWrapper.drawLine((int)d2, 0, (int)d2, dimension.height - 1);
            }
            for (d2 = d3; d2 < (double)dimension.height; d2 += d3) {
                g2DWrapper.drawLine(0, (int)d2, dimension.width - 1, (int)d2);
            }
        }
        if (Math.abs(1.0 - d) > 1.0E-4) {
            g2DWrapper.scale(d, d);
        }
        for (IDIYComponent<?> object2 : project.getComponents()) {
            if (iComponentFiler != null && !iComponentFiler.testComponent(object2)) continue;
            ComponentState componentState = ComponentState.NORMAL;
            if (set.contains((Object)DrawOption.SELECTION) && list.contains(object2)) {
                componentState = bl ? ComponentState.DRAGGING : ComponentState.SELECTED;
            }
            boolean bl2 = this.lastDrawnStateMap.get(object2) != componentState;
            object = graphics2D;
            synchronized (object) {
                g2DWrapper.startedDrawingComponent();
                if (!bl2) {
                    g2DWrapper.stopTracking();
                }
                if (set2.contains(object2)) {
                    graphics2D.setComposite(this.lockedComposite);
                }
                try {
                    object2.draw(g2DWrapper, componentState, set.contains((Object)DrawOption.OUTLINE_MODE), project, g2DWrapper);
                }
                catch (Exception exception) {
                    LOG.error((Object)("Error drawing " + object2.getName()), (Throwable)exception);
                    this.failedComponents.add(object2);
                }
                Area area = g2DWrapper.finishedDrawingComponent();
                if (bl2 && area != null && !area.isEmpty()) {
                    this.componentAreaMap.put(object2, area);
                    this.lastDrawnStateMap.put(object2, componentState);
                }
            }
        }
        if (set.contains((Object)DrawOption.CONTROL_POINTS)) {
            if (bl || set.contains((Object)DrawOption.OUTLINE_MODE)) {
                for (IDIYComponent iDIYComponent : project.getComponents()) {
                    for (int i = 0; i < iDIYComponent.getControlPointCount(); ++i) {
                        VisibilityPolicy visibilityPolicy = iDIYComponent.getControlPointVisibilityPolicy(i);
                        if ((!set3.contains(iDIYComponent) || visibilityPolicy != VisibilityPolicy.ALWAYS && (!list.contains(iDIYComponent) || visibilityPolicy != VisibilityPolicy.WHEN_SELECTED)) && (set3.contains(iDIYComponent) || list.contains(iDIYComponent) || iDIYComponent.getControlPointVisibilityPolicy(i) != VisibilityPolicy.ALWAYS)) continue;
                        g2DWrapper.setColor(CONTROL_POINT_COLOR);
                        object = iDIYComponent.getControlPoint(i);
                        int n = CONTROL_POINT_SIZE - 2;
                        g2DWrapper.fillOval(((Point)object).x - n / 2, ((Point)object).y - n / 2, n, n);
                    }
                }
            }
            for (IDIYComponent iDIYComponent : list) {
                for (int i = 0; i < iDIYComponent.getControlPointCount(); ++i) {
                    if (set3.contains(iDIYComponent) || iDIYComponent.getControlPointVisibilityPolicy(i) != VisibilityPolicy.WHEN_SELECTED && iDIYComponent.getControlPointVisibilityPolicy(i) != VisibilityPolicy.ALWAYS) continue;
                    Point point = iDIYComponent.getControlPoint(i);
                    int n = CONTROL_POINT_SIZE;
                    g2DWrapper.setColor(SELECTED_CONTROL_POINT_COLOR.darker());
                    g2DWrapper.fillOval(point.x - n / 2, point.y - n / 2, n, n);
                    g2DWrapper.setColor(SELECTED_CONTROL_POINT_COLOR);
                    g2DWrapper.fillOval(point.x - CONTROL_POINT_SIZE / 2 + 1, point.y - CONTROL_POINT_SIZE / 2 + 1, CONTROL_POINT_SIZE - 2, CONTROL_POINT_SIZE - 2);
                }
            }
        }
        if (list3 != null) {
            g2DWrapper.startedDrawingComponent();
            g2DWrapper.setComposite(this.slotComposite);
            for (IDIYComponent iDIYComponent : list3) {
                try {
                    iDIYComponent.draw(g2DWrapper, ComponentState.NORMAL, set.contains((Object)DrawOption.OUTLINE_MODE), project, g2DWrapper);
                }
                catch (Exception exception) {
                    LOG.error((Object)("Error drawing " + iDIYComponent.getName()), (Throwable)exception);
                    this.failedComponents.add(iDIYComponent);
                }
            }
            g2DWrapper.finishedDrawingComponent();
        }
        if (list2 != null) {
            for (Point point : list2) {
                if (point == null) continue;
                g2DWrapper.setColor(SELECTED_CONTROL_POINT_COLOR.darker());
                g2DWrapper.fillOval(point.x - CONTROL_POINT_SIZE / 2, point.y - CONTROL_POINT_SIZE / 2, CONTROL_POINT_SIZE, CONTROL_POINT_SIZE);
                g2DWrapper.setColor(SELECTED_CONTROL_POINT_COLOR);
                g2DWrapper.fillOval(point.x - CONTROL_POINT_SIZE / 2 + 1, point.y - CONTROL_POINT_SIZE / 2 + 1, CONTROL_POINT_SIZE - 2, CONTROL_POINT_SIZE - 2);
            }
        }
        if (set.contains((Object)DrawOption.SELECTION) && rectangle != null) {
            graphics2D.setColor(Color.white);
            graphics2D.draw(rectangle);
            graphics2D.setColor(Color.black);
            graphics2D.setStroke(Constants.DASHED_STROKE);
            graphics2D.draw(rectangle);
        }
        if (this.debugComponentAreas) {
            graphics2D.setStroke(ObjectCache.getInstance().fetchBasicStroke(1));
            graphics2D.setColor(Color.red);
            for (Area area : this.componentAreaMap.values()) {
                graphics2D.draw(area);
            }
        }
        return this.failedComponents;
    }

    public double getZoomLevel() {
        return this.zoomLevel;
    }

    public void setZoomLevel(double d) {
        this.zoomLevel = d;
        this.fireZoomChanged();
    }

    public void invalidateComponent(IDIYComponent<?> iDIYComponent) {
        this.componentAreaMap.remove(iDIYComponent);
        this.lastDrawnStateMap.remove(iDIYComponent);
    }

    public Area getComponentArea(IDIYComponent<?> iDIYComponent) {
        return this.componentAreaMap.get(iDIYComponent);
    }

    public void clearComponentAreaMap() {
        this.componentAreaMap.clear();
        this.lastDrawnStateMap.clear();
    }

    public List<IDIYComponent<?>> findComponentsAt(Point point, Project project) {
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < project.getComponents().size(); ++i) {
            Area area = this.componentAreaMap.get(project.getComponents().get(i));
            if (area == null || !area.contains(point)) continue;
            arrayList.add(0, project.getComponents().get(i));
        }
        return arrayList;
    }

    public Dimension getCanvasDimensions(Project project, Double d, boolean bl) {
        double d2 = project.getWidth().convertToPixels();
        double d3 = project.getHeight().convertToPixels();
        if (bl) {
            d2 *= d.doubleValue();
            d3 *= d.doubleValue();
        } else {
            d2 /= Constants.PIXEL_SIZE;
            d3 /= Constants.PIXEL_SIZE;
        }
        return new Dimension((int)d2, (int)d3);
    }

    public void fireZoomChanged() {
        this.messageDispatcher.dispatchMessage((Enum)EventType.ZOOM_CHANGED, new Object[]{this.zoomLevel});
        this.messageDispatcher.dispatchMessage((Enum)EventType.REPAINT, new Object[0]);
    }

    public Theme getTheme() {
        return this.theme;
    }

    public void setTheme(Theme theme) {
        this.theme = theme;
        ConfigurationManager.getInstance().writeValue("theme", (Object)theme);
        this.messageDispatcher.dispatchMessage((Enum)EventType.REPAINT, new Object[0]);
    }
}

