
// ==== Standard POV-Ray Includes ====
#include "colors.inc"	  // Standard Color definitions
#include "textures.inc"	  // Standard Texture definitions
#include "functions.inc"  // internal functions usable in user defined functions


//light_source {<-2,-10,-10>,  White*.8}
//light_source { <2,35,-10>,  White*.8}
light_source { <0,10,-50>,  White}

//background { Blue}



plane { z,  100  pigment{ rgb <2,0,2>}}
plane { z,  -100  pigment{ Blue}}


 // +a0.3 +ua +w320 +h144  

  
camera { orthographic  location <0,1.5,-40>  look_at  <0,1.5,0> right 14*x  up 6.3*y }



intersection {
union{

// core
cylinder { <-10,0,0> <10,0,0> .9 pigment{ Gray50}}

difference{
cylinder { <-10,0,0> <10,0,0> 1 pigment{ Gray90}}



box {
  <-1.6, -1.6, -1.6>
  < 1.6, 1.6,  1.6>
rotate z*45 translate <-1.9,0,0>}


difference{
box {
  <-1, -1, -1>
  < 1,  1,  1>
rotate z*45 }
box {
  <-1, -1, -1>
  < 1,  1,  1>
rotate z*45 translate <-.3,0,0>}
translate <1.75,0,0>}



difference{
box {
  <-1, -1, -1>
  < 1,  1,  1>
rotate z*45 }
box {
  <-1, -1, -1>
  < 1,  1,  1>
rotate z*45 translate <-.3,0,0>}
translate <5.7,0,0>}

box {
  <3,.1,1.5>
  < 10,  -.1,  -1.5>}
}



box { // stop -red
  <-.5, -.5, -1>
  < .5,  .5,  .1>
translate <-4.9,0,0> pigment{ Red *2}}



//play button
//cone { <0,0,-1>,  .5, <1.25,0,-1>, 0 pigment{ Green *2} translate x*.75}


// or pause button
cone { <0,0,-1>,  .5, <0.25,0,-1>, .5 pigment{ Green *2} translate x*1}
cone { <.50,0,-1>,  .5, <0.75,0,-1>, .5 pigment{ Green *2} translate x*1}


// rewind and fast forward
union{
cone { <0,0,-1>,  0, <.5,0,-1>, .2 pigment{ Green *2} translate x*3.15}
cone { <0,0,-1>,  0, <.5,0,-1>, .2 pigment{ Green *2} translate x*3.75}

cone { <0,0,-1>,  .2, <.5,0,-1>, 0 pigment{ Green *2} translate x*4.85}
cone { <0,0,-1>,  .2, <.5,0,-1>, 0 pigment{ Green *2} translate x*5.45}
translate <0,.5,.1>}

// next and previous track
union{
box { <0,.2,-1.1>, <.2,-.2,1> pigment{ Green *2} translate x*3.35}
cone { <0,0,-1>,  0, <.5,0,-1>, .2 pigment{ Green *2} translate x*3.75}

cone { <0,0,-1>,  .2, <.5,0,-1>, 0 pigment{ Green *2} translate x*4.85}
box { <0,.2,-1.1>,  <.2,-.2,1> pigment{ Green *2} translate x*5.5}
translate <0,-.5,.1>}

//volune control


cylinder { <-1.9,0,1> <-1.9,0,-2>1.4 pigment{ Gray90}}
sphere {  <-1.9,0,0>1.6 pigment{ Gray90}}

//difference {
sphere {  <-1.9,0,-3>1 pigment{ Gray90} scale z*.7 no_shadow}
//box{<-.1,1,-3><.1,.3,3> rotate <0,0,-clock*270+135> translate x*-1.9}
//}

}
box { <-4.8,-4.8,-4.8> <4.8,4.8,4.8> rotate z*45 }  //no_shadow
}


//progress angle meter
difference{
cylinder { <-2.5,0,0> <1.3,5,0>1.1 pigment{ Gray90} }
box{ <-10,4,-2><10,10,2>}

        difference { 
        cylinder { <-2.5,0,-1> <1.3,5,-1>.7 pigment{ Gray90} }
        box{ <-10,3.8,-2><10,10,2>}
        box{ <-10,1.5,-2><10,0,2>} } 
}


// text area extension
//cylinder{ <.5,3.2,0><6,3.2,0> .8 pigment{ Gray70} }


//hardest part - grip

difference {
blob {
  threshold 0.6
 cylinder { <-.5,3.2,0> <5,3.2,0>  2, 1}
 cylinder { <-.35,3.9,-1> <5,3.9,-1> .5, 1}
 cylinder { <-.35,3.2,1> <5,3.2,1>  .5, 1}
  sphere { <6,  3.8, 0>, 2, .5 }
 sphere { <10,  2.6, 0>, 1, .6  scale x*.5}
 sphere { <8,  2.6, 0>, 1, .6 scale x*.5}
 sphere { <6,  2.6, 0>, 1, .6 scale x*.5}

  sphere { <6.5,  2.3, 0>, 1.2, .7 }
  sphere { <6.1,  3.1, 0>, 1, .7 }
  pigment{ Gray50}

}
        difference {
        cylinder { <-2.5,0,-1> <1.3,5,-1>.8 pigment{ Gray90} }
        box{ <-10,3.85,-2><10,10,2>}
        box{ <-10,1.45,-2><10,0,2>} }
}


// extrude a closed 2-D shape along an axis
prism {                                
  linear_sweep  // or conic_sweep for tapering to a point
  linear_spline // linear_spline | quadratic_spline | cubic_spline | bezier_spline 
  -3.5,         // height 1
   3.5,         // height 2
  5,           // number of points
  // (--- the <u,v> points ---)
  < .9, 3.1>, < 5.2,  3.1>, < 5.8, 3.9>, < 1.5,  3.9>, < .9, 3.1>
 pigment{ Gray90} no_shadow rotate x*270
}




        difference { 
        cylinder { <-2.5,0,.1> <1.3,5,.1>.7


pigment{ 

  gradient y  
color_map {

//  [ 0.0  color Green*2]
  [ clock-.2  color Green*2]
  [ clock+.2  color Black]
//  [ 1.0  color Black]
} // color_map
scale y*2.3 translate y*1.5

//Green*2
}
 }


        box{ <-10,3.8,-2><10,10,2>}
        box{ <-10,1.5,-2><10,0,2>} 

        box{ <-10,1.4,-2><10,1.7,2>} 
        box{ <-10,1.8,-2><10,1.9,2>} 
        box{ <-10,2.0,-2><10,2.1,2>} 
        box{ <-10,2.2,-2><10,2.3,2>} 
        box{ <-10,2.4,-2><10,2.5,2>} 
        box{ <-10,2.6,-2><10,2.7,2>} 
        box{ <-10,2.8,-2><10,2.9,2>} 
        box{ <-10,3.0,-2><10,3.1,2>} 
        box{ <-10,3.2,-2><10,3.3,2>} 
        box{ <-10,3.4,-2><10,3.5,2>} 
        box{ <-10,3.6,-2><10,3.8,2>} 
        } 


union { // close
box { <-1, -.2, -1>, <1, .2, 1> pigment{ Gray90} rotate z*45}
box { <-1, -.2, -1>, <1, .2, 1> pigment{ Gray90} rotate z*-45}
scale .3
translate <5,2.6,-1>
}

union {  // file
box { <-.25, .5, .5>, <-1, 1, -1> pigment{ Gray90}}
box { <-1, -.75, -1>, <1, .5, 1> pigment{ Gray90}}
scale.3
translate <4,2.6,-1>
}


// create a TrueType text shape
text {
  ttf             // font type (only TrueType format for now)
  "cyrvetic.ttf",  // Microsoft Windows-format TrueType font file name
  "MPlayer",      // the string to create
  1,              // the extrusion depth
  0               // inter-character spacing
  scale <.45,.6,1> translate <.8,2.4,-1.1>  pigment{ Gray90} 
}




