/*
 * Copyright 2014 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA:
//  cldrVersion=25
//  date=$Date: 2014-03-01 06:57:43 +0100 (Sat, 01 Mar 2014) $
//  number=$Revision: 9852 $
//  type=MX

/**
 * Localized names for the "es_MX" locale.
 */
public class LocalizedNamesImpl_es_MX extends LocalizedNamesImpl_es {

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AF",
        "AL",
        "DE",
        "AD",
        "AO",
        "AI",
        "AQ",
        "AG",
        "AN",
        "SA",
        "DZ",
        "AR",
        "AM",
        "AW",
        "AU",
        "AT",
        "AZ",
        "BS",
        "BD",
        "BB",
        "BH",
        "BE",
        "BZ",
        "BJ",
        "BM",
        "BY",
        "BO",
        "BA",
        "BW",
        "BR",
        "BN",
        "BG",
        "BF",
        "BI",
        "BT",
        "CV",
        "KH",
        "CM",
        "CA",
        "BQ",
        "EA",
        "TD",
        "CL",
        "CN",
        "CY",
        "VA",
        "CO",
        "KM",
        "CG",
        "KP",
        "KR",
        "CI",
        "CR",
        "HR",
        "CU",
        "CW",
        "DG",
        "DK",
        "DM",
        "EC",
        "EG",
        "SV",
        "AE",
        "ER",
        "SK",
        "SI",
        "ES",
        "US",
        "EE",
        "ET",
        "PH",
        "FI",
        "FJ",
        "FR",
        "GA",
        "GM",
        "GE",
        "GH",
        "GI",
        "GD",
        "GR",
        "GL",
        "GP",
        "GU",
        "GT",
        "GF",
        "GG",
        "GN",
        "GW",
        "GQ",
        "GY",
        "HT",
        "HN",
        "HU",
        "IN",
        "ID",
        "IQ",
        "IR",
        "IE",
        "AC",
        "BV",
        "CP",
        "IM",
        "CX",
        "IS",
        "NF",
        "AX",
        "KY",
        "IC",
        "CC",
        "CK",
        "FO",
        "GS",
        "HM",
        "FK",
        "MP",
        "MH",
        "PN",
        "SB",
        "TC",
        "QO",
        "UM",
        "VG",
        "VI",
        "IL",
        "IT",
        "JM",
        "JP",
        "JE",
        "JO",
        "KZ",
        "KE",
        "KG",
        "KI",
        "XK",
        "KW",
        "LA",
        "LS",
        "LV",
        "LB",
        "LR",
        "LY",
        "LI",
        "LT",
        "LU",
        "MK",
        "MG",
        "MY",
        "MW",
        "MV",
        "ML",
        "MT",
        "MA",
        "MQ",
        "MU",
        "MR",
        "YT",
        "MX",
        "FM",
        "MD",
        "MC",
        "MN",
        "ME",
        "MS",
        "MZ",
        "MM",
        "NA",
        "NR",
        "NP",
        "NI",
        "NE",
        "NG",
        "NU",
        "NO",
        "NC",
        "NZ",
        "OM",
        "NL",
        "PK",
        "PW",
        "PA",
        "PG",
        "PY",
        "PE",
        "PF",
        "PL",
        "PT",
        "PR",
        "QA",
        "HK",
        "MO",
        "GB",
        "CF",
        "CZ",
        "CD",
        "DO",
        "RE",
        "RW",
        "RO",
        "RU",
        "EH",
        "WS",
        "AS",
        "BL",
        "KN",
        "SM",
        "MF",
        "PM",
        "SH",
        "LC",
        "ST",
        "VC",
        "SN",
        "RS",
        "SC",
        "SL",
        "SG",
        "SX",
        "SY",
        "SO",
        "LK",
        "SZ",
        "ZA",
        "SD",
        "SS",
        "SE",
        "CH",
        "SR",
        "SJ",
        "TH",
        "TW",
        "TZ",
        "TJ",
        "IO",
        "TF",
        "PS",
        "TL",
        "TG",
        "TK",
        "TO",
        "TT",
        "TA",
        "TN",
        "TM",
        "TR",
        "TV",
        "UA",
        "UG",
        "EU",
        "UY",
        "UZ",
        "VU",
        "VE",
        "VN",
        "WF",
        "YE",
        "DJ",
        "ZM",
        "ZW",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("005", "Sudamérica");
    namesMap.put("011", "África Occidental");
    namesMap.put("014", "África Oriental");
    namesMap.put("015", "África del Norte");
    namesMap.put("017", "África Central");
    namesMap.put("018", "África del Sur");
    namesMap.put("019", "Américas");
    namesMap.put("021", "América Septentrional");
    namesMap.put("030", "Asia Oriental");
    namesMap.put("034", "Asia del Sur");
    namesMap.put("035", "Sudeste Asiático");
    namesMap.put("039", "Europa del Sur");
    namesMap.put("143", "Asia Central");
    namesMap.put("145", "Asia Occidental");
    namesMap.put("151", "Europa Oriental");
    namesMap.put("154", "Europa del Norte");
    namesMap.put("155", "Europa Occidental");
    namesMap.put("AC", "Isla Ascensión");
    namesMap.put("BA", "Bosnia-Herzegovina");
    namesMap.put("BD", "Bangladesh");
    namesMap.put("CC", "Islas Cocos (Keeling)");
    namesMap.put("CG", "Congo Brazzaville");
    namesMap.put("CX", "Isla de Navidad");
    namesMap.put("GG", "Guernsey");
    namesMap.put("GS", "Islas Georgias del Sur y Sandwich del Sur");
    namesMap.put("GW", "Guinea-Bissau");
    namesMap.put("HK", "Región Administrativa Especial de Hong Kong de la República Popular China");
    namesMap.put("IC", "Islas Canarias");
    namesMap.put("IQ", "Irak");
    namesMap.put("MO", "Región Administrativa Especial de Macao de la República Popular China");
    namesMap.put("NU", "Niue");
    namesMap.put("PW", "Palaos");
    namesMap.put("QA", "Qatar");
    namesMap.put("QO", "Islas Ultramarinas");
    namesMap.put("TA", "Tristán de Acuña");
    namesMap.put("UM", "Islas UltramarinasMenores de Estados Unidos");
    namesMap.put("VI", "Islas Vírgenes de los Estados Unidos");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "005": "Sudamérica",
        "011": "África Occidental",
        "014": "África Oriental",
        "015": "África del Norte",
        "017": "África Central",
        "018": "África del Sur",
        "019": "Américas",
        "021": "América Septentrional",
        "030": "Asia Oriental",
        "034": "Asia del Sur",
        "035": "Sudeste Asiático",
        "039": "Europa del Sur",
        "143": "Asia Central",
        "145": "Asia Occidental",
        "151": "Europa Oriental",
        "154": "Europa del Norte",
        "155": "Europa Occidental",
        "AC": "Isla Ascensión",
        "BA": "Bosnia-Herzegovina",
        "BD": "Bangladesh",
        "CC": "Islas Cocos (Keeling)",
        "CG": "Congo Brazzaville",
        "CX": "Isla de Navidad",
        "GG": "Guernsey",
        "GS": "Islas Georgias del Sur y Sandwich del Sur",
        "GW": "Guinea-Bissau",
        "HK": "Región Administrativa Especial de Hong Kong de la República Popular China",
        "IC": "Islas Canarias",
        "IQ": "Irak",
        "MO": "Región Administrativa Especial de Macao de la República Popular China",
        "NU": "Niue",
        "PW": "Palaos",
        "QA": "Qatar",
        "QO": "Islas Ultramarinas",
        "TA": "Tristán de Acuña",
        "UM": "Islas UltramarinasMenores de Estados Unidos",
        "VI": "Islas Vírgenes de los Estados Unidos"
    };
  }-*/;
}
