/*
 * Decompiled with CFR 0.152.
 */
package br.arca.morcego.component;

import br.arca.morcego.Config;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.TextArea;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;

public class DescriptionBox
extends Component {
    private static final long serialVersionUID = -2915228971002451019L;
    private String text;
    private int originX;
    private int originY;

    public DescriptionBox(String text) {
        this.text = text;
        this.originX = 0;
        this.originY = 0;
    }

    public void setPosition(int x, int y) {
        this.originX = x;
        this.originY = y;
    }

    public void paint(Graphics g) {
        Graphics2D graphic = (Graphics2D)g;
        TextArea textArea = new TextArea(this.text);
        textArea.setLocation(0, 0);
        textArea.setVisible(true);
        Font font = new Font(null, 0, 10);
        FontRenderContext frc = new FontRenderContext(null, false, false);
        TextLayout l = new TextLayout(this.text, font, frc);
        Rectangle2D textBounds = l.getBounds();
        int margin = Config.getInteger("morcego.descriptionMargin");
        int border = 1;
        int distX = 5;
        int distY = 5;
        int width = (int)textBounds.getWidth() + 2 * margin + 2 * border;
        int height = (int)textBounds.getHeight() + 2 * margin + 2 * border;
        int cornerX = this.originX - width - distX;
        int cornerY = this.originY - height - distY;
        if (cornerX < 0) {
            cornerX = 0;
        }
        if (cornerY < 0) {
            cornerY = 0;
        }
        graphic.setColor(Config.getColor("morcego.descriptionBorder"));
        graphic.fillRect(cornerX - margin - border, cornerY - margin - border, (int)textBounds.getWidth() + 2 * margin + 2 * border, (int)textBounds.getHeight() + 2 * margin + 2 * border);
        graphic.setColor(Config.getColor("morcego.descriptionBackground"));
        graphic.fillRect(cornerX - margin, cornerY - margin, (int)textBounds.getWidth() + 2 * margin, (int)textBounds.getHeight() + 2 * margin);
        graphic.setColor(Config.getColor("morcego.descriptionColor"));
        textArea.paint(g);
        l.draw(graphic, cornerX, cornerY + (int)textBounds.getHeight());
    }
}

