/*
 * This file is part of the TYPO3 CMS project.
 *
 * It is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, either version 2
 * of the License, or any later version.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * The TYPO3 project - inspiring people to share!
 */
import{lll as i}from"@typo3/core/lit-helper.js";import{SeverityEnum as p}from"@typo3/backend/enum/severity.js";import c from"@typo3/core/ajax/ajax-request.js";import s from"@typo3/backend/notification.js";import f from"@typo3/backend/modal.js";import m from"@typo3/backend/hashing/md5.js";import{fileListOpenElementBrowser as b}from"@typo3/filelist/file-list.js";import{FileListActionUtility as g,FileListActionEvent as U}from"@typo3/filelist/file-list-actions.js";class l{static getReturnUrl(){return encodeURIComponent(top.list_frame.document.location.pathname+top.list_frame.document.location.search)}static triggerFileDownload(o,t,e=!1){const n=document.createElement("a");n.href=o,n.download=t,document.body.appendChild(n),n.click(),e&&URL.revokeObjectURL(o),document.body.removeChild(n),s.success(i("file_download.success"),"",2)}static renameFile(o,t,e){(async()=>{await import("@typo3/filelist/file-list-rename-handler.js");const n=g.createResourceFromContextDataset(e),r={event:null,trigger:null,action:U.rename,resources:[n],url:null,originalAction:null};document.dispatchEvent(new CustomEvent(U.rename,{detail:r}))})()}static editFile(o,t,e){const n=e.actionUrl;top.TYPO3.Backend.ContentContainer.setUrl(n+"&target="+encodeURIComponent(t)+"&returnUrl="+l.getReturnUrl())}static editMetadata(o,t,e){const n=g.createResourceFromContextDataset(e);n.metaUid&&top.TYPO3.Backend.ContentContainer.setUrl(top.TYPO3.settings.FormEngine.moduleUrl+"&edit[sys_file_metadata]["+n.metaUid+"]=edit&returnUrl="+l.getReturnUrl())}static openInfoPopUp(o,t){o==="sys_file_storage"?top.TYPO3.InfoWindow.showItem(o,t):top.TYPO3.InfoWindow.showItem("_FILE",t)}static uploadFile(o,t,e){const n=e.actionUrl;top.TYPO3.Backend.ContentContainer.setUrl(n+"&target="+encodeURIComponent(t)+"&returnUrl="+l.getReturnUrl())}static createFolder(o,t,e){top.TYPO3.Backend.ContentContainer.get().document.dispatchEvent(new CustomEvent(b,{detail:{actionUrl:e.actionUrl,identifier:e.identifier,mode:e.mode}}))}static createFile(o,t,e){const n=e.actionUrl;top.TYPO3.Backend.ContentContainer.setUrl(n+"&target="+encodeURIComponent(t)+"&returnUrl="+l.getReturnUrl())}static downloadFile(o,t,e){l.triggerFileDownload(e.url,e.name)}static downloadFolder(o,t,e){s.info(i("file_download.prepare"),"",2);const n=e.actionUrl;new c(n).post({items:[t]}).then(async r=>{let a=r.response.headers.get("Content-Disposition");if(!a){const d=await r.resolve();d.success===!1&&d.status?s.warning(i("file_download."+d.status),i("file_download."+d.status+".message"),10):s.error(i("file_download.error"));return}a=a.substring(a.indexOf(" filename=")+10);const u=await r.raw().arrayBuffer(),C=new Blob([u],{type:r.raw().headers.get("Content-Type")});l.triggerFileDownload(URL.createObjectURL(C),a,!0)}).catch(()=>{s.error(i("file_download.error"))})}static createFilemount(o,t){t.split(":").length===2&&top.TYPO3.Backend.ContentContainer.setUrl(top.TYPO3.settings.FormEngine.moduleUrl+"&edit[sys_filemounts][0]=new&defVals[sys_filemounts][identifier]="+encodeURIComponent(t)+"&returnUrl="+l.getReturnUrl())}static deleteFile(o,t,e){const n=()=>{top.TYPO3.Backend.ContentContainer.setUrl(top.TYPO3.settings.FileCommit.moduleUrl+"&data[delete][0][data]="+encodeURIComponent(t)+"&data[delete][0][redirect]="+l.getReturnUrl())};if(!e.title){n();return}const r=f.confirm(e.title,e.message,p.warning,[{text:e.buttonCloseText||TYPO3.lang["button.cancel"]||"Cancel",active:!0,btnClass:"btn-default",name:"cancel"},{text:e.buttonOkText||TYPO3.lang["button.delete"]||"Delete",btnClass:"btn-warning",name:"delete"}]);r.addEventListener("button.clicked",a=>{a.target.name==="delete"&&n(),r.hideModal()})}static copyFile(o,t){const e=m.hash(t),n=TYPO3.settings.ajaxUrls.contextmenu_clipboard,r={CB:{el:{["_FILE%7C"+e]:t},setCopyMode:"1"}};new c(n).withQueryArguments(r).get().finally(()=>{top.TYPO3.Backend.ContentContainer.refresh()})}static copyReleaseFile(o,t){const e=m.hash(t),n=TYPO3.settings.ajaxUrls.contextmenu_clipboard,r={CB:{el:{["_FILE%7C"+e]:"0"},setCopyMode:"1"}};new c(n).withQueryArguments(r).get().finally(()=>{top.TYPO3.Backend.ContentContainer.refresh()})}static cutFile(o,t){const e=m.hash(t),n=TYPO3.settings.ajaxUrls.contextmenu_clipboard,r={CB:{el:{["_FILE%7C"+e]:t}}};new c(n).withQueryArguments(r).get().finally(()=>{top.TYPO3.Backend.ContentContainer.refresh()})}static cutReleaseFile(o,t){const e=m.hash(t),n=TYPO3.settings.ajaxUrls.contextmenu_clipboard,r={CB:{el:{["_FILE%7C"+e]:"0"}}};new c(n).withQueryArguments(r).get().finally(()=>{top.TYPO3.Backend.ContentContainer.refresh()})}static pasteFileInto(o,t,e){const n=()=>{top.TYPO3.Backend.ContentContainer.setUrl(top.TYPO3.settings.FileCommit.moduleUrl+"&CB[paste]=FILE|"+encodeURIComponent(t)+"&CB[pad]=normal&redirect="+l.getReturnUrl())};if(!e.title){n();return}const r=f.confirm(e.title,e.message,p.warning,[{text:e.buttonCloseText||TYPO3.lang["button.cancel"]||"Cancel",active:!0,btnClass:"btn-default",name:"cancel"},{text:e.buttonOkText||TYPO3.lang["button.ok"]||"OK",btnClass:"btn-warning",name:"ok"}]);r.addEventListener("button.clicked",a=>{a.target.name==="ok"&&n(),r.hideModal()})}static updateOnlineMedia(o,t,e){if(!e.actionUrl||!e.filecontextUid||e.filecontextType!=="file")return;const n={resource:{type:e.filecontextType,uid:e.filecontextUid}};new c(e.actionUrl).post(n).then(()=>{s.success(i("online_media.update.success"))}).catch(()=>{s.error(i("online_media.update.error"))}).finally(()=>{window.location.reload()})}}export{l as default};
