/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.alignments;

import it.unimi.dsi.fastutil.AbstractPriorityQueue;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.objects.ObjectArrayPriorityQueue;
import it.unimi.dsi.fastutil.objects.ObjectHeapPriorityQueue;
import java.io.IOException;
import java.util.Comparator;
import java.util.NoSuchElementException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.campagnelab.goby.alignments.AlignmentPositionComparator;
import org.campagnelab.goby.alignments.AlignmentReader;
import org.campagnelab.goby.alignments.AlignmentReaderFactory;
import org.campagnelab.goby.alignments.Alignments;
import org.campagnelab.goby.alignments.ConcatAlignmentReader;
import org.campagnelab.goby.alignments.DefaultAlignmentReaderFactory;
import org.campagnelab.goby.alignments.GenomicRange;
import org.campagnelab.goby.alignments.NonAmbiguousAlignmentReaderFactory;

public class ConcatSortedAlignmentReader
extends ConcatAlignmentReader {
    AbstractPriorityQueue<Bucket> entryHeap;
    private static AlignmentPositionComparator comparator = new AlignmentPositionComparator();
    private boolean[] nextLoadedForReader;
    private Bucket[] buckets;
    private GenomicRange genomicRange;
    private static final Log LOG = LogFactory.getLog(ConcatSortedAlignmentReader.class);
    int minReaderIndex;
    boolean hasNext;

    public ConcatSortedAlignmentReader(String ... basenames) throws IOException {
        this(new DefaultAlignmentReaderFactory(), basenames);
    }

    public ConcatSortedAlignmentReader(AlignmentReaderFactory factory, boolean adjustQueryIndices, String[] basenames, int startReferenceIndex, int startPosition, int endReferenceIndex, int endPosition) throws IOException {
        super(factory, adjustQueryIndices, startReferenceIndex, startPosition, endReferenceIndex, endPosition, basenames);
        this.init(basenames);
    }

    public ConcatSortedAlignmentReader(String[] basenames, int startReferenceIndex, int startPosition, int endReferenceIndex, int endPosition) throws IOException {
        super((AlignmentReaderFactory)new DefaultAlignmentReaderFactory(), true, startReferenceIndex, startPosition, endReferenceIndex, endPosition, basenames);
        this.init(basenames);
    }

    public ConcatSortedAlignmentReader(AlignmentReaderFactory alignmentReaderFactory, String[] basenames) throws IOException {
        super(alignmentReaderFactory, true, basenames);
        this.init(basenames);
    }

    public ConcatSortedAlignmentReader(AlignmentReaderFactory alignmentReaderFactory, boolean adjustQueryIndices, String[] basenames) throws IOException {
        super(alignmentReaderFactory, adjustQueryIndices, basenames);
        this.init(basenames);
    }

    public ConcatSortedAlignmentReader(boolean adjustQueryIndices, String ... basenames) throws IOException {
        super((AlignmentReaderFactory)new DefaultAlignmentReaderFactory(), adjustQueryIndices, basenames);
        this.init(basenames);
    }

    public ConcatSortedAlignmentReader(NonAmbiguousAlignmentReaderFactory alignmentReaderFactory, boolean adjustQueryIndices, String ... basenames) throws IOException {
        super((AlignmentReaderFactory)alignmentReaderFactory, adjustQueryIndices, basenames);
        this.init(basenames);
    }

    private void init(String ... basenames) {
        this.nextLoadedForReader = new boolean[basenames.length];
        Comparator<Bucket> bucketComparator = new Comparator<Bucket>(){

            @Override
            public int compare(Bucket bucket, Bucket bucket1) {
                return comparator.compare(bucket.entry, bucket1.entry);
            }
        };
        this.entryHeap = basenames.length < 10 ? new ObjectArrayPriorityQueue((Comparator)bucketComparator) : new ObjectHeapPriorityQueue((Comparator)bucketComparator);
        this.buckets = new Bucket[basenames.length];
        for (int i = 0; i < this.buckets.length; ++i) {
            this.buckets[i] = new Bucket(null, i);
        }
    }

    public final Alignments.AlignmentEntry skipTo(int targetIndex, int position) throws IOException {
        while (!this.entryHeap.isEmpty()) {
            Bucket bucket = (Bucket)this.entryHeap.first();
            int bucketTargetIndex = bucket.entry.getTargetIndex();
            if (bucketTargetIndex >= targetIndex && (bucketTargetIndex != targetIndex || bucket.entry.getPosition() >= position)) break;
            Bucket removed = (Bucket)this.entryHeap.dequeue();
            this.nextLoadedForReader[removed.readerIndex] = false;
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)String.format("Cleaning the heap: removing %d:%d from reader=%d", bucket.entry.getTargetIndex(), bucket.entry.getPosition(), this.activeIndex));
        }
        for (int readerIndex : this.readersWithMoreEntries.toIntArray()) {
            Alignments.AlignmentEntry alignmentEntry;
            if (this.nextLoadedForReader[readerIndex]) continue;
            this.activeIndex = readerIndex;
            AlignmentReader reader = this.readers[this.activeIndex];
            while ((alignmentEntry = reader.skipTo(targetIndex, position)) != null && this.genomicRange != null && this.genomicRange.positionIsStrictlyBeforeStart(alignmentEntry.getTargetIndex(), alignmentEntry.getPosition())) {
            }
            if (alignmentEntry == null) {
                this.readersWithMoreEntries.remove(this.activeIndex);
                continue;
            }
            if (this.genomicRange != null && this.genomicRange.positionIsPastEnd(alignmentEntry.getTargetIndex(), alignmentEntry.getPosition())) {
                this.readersWithMoreEntries.remove(this.activeIndex);
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace((Object)String.format("Reached the end of slice for reader %d with entry %d:%d", this.activeIndex, alignmentEntry.getTargetIndex(), alignmentEntry.getPosition()));
                continue;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)String.format("Adding to the heap: %d:%d from reader=%d", alignmentEntry.getTargetIndex(), alignmentEntry.getPosition(), this.activeIndex));
            }
            this.nextLoadedForReader[readerIndex] = true;
            Bucket bucket2 = this.buckets[readerIndex];
            bucket2.entry = alignmentEntry;
            bucket2.readerIndex = readerIndex;
            this.entryHeap.enqueue((Object)bucket2);
        }
        if (this.entryHeap.isEmpty()) {
            return null;
        }
        Bucket bucket = (Bucket)this.entryHeap.dequeue();
        this.nextLoadedForReader[bucket.readerIndex] = false;
        this.hasNext = false;
        Alignments.AlignmentEntry alignmentEntry = bucket.entry;
        this.activeIndex = bucket.readerIndex;
        int newQueryIndex = this.mergedQueryIndex(this.activeIndex, alignmentEntry.getQueryIndex());
        int queryIndex = alignmentEntry.getQueryIndex();
        Alignments.AlignmentEntry.Builder builder = alignmentEntry.newBuilderForType().mergeFrom(alignmentEntry);
        if (this.adjustQueryIndices && newQueryIndex != queryIndex) {
            builder = builder.setQueryIndex(newQueryIndex);
        }
        if (this.adjustSampleIndices) {
            builder = builder.setSampleIndex(this.activeIndex);
        }
        builder = this.processReadGroups(alignmentEntry, builder, this.activeIndex);
        return builder.build();
    }

    @Override
    public boolean hasNext() {
        if (this.hasNext) {
            return true;
        }
        IntIterator intIterator = this.readersWithMoreEntries.iterator();
        while (intIterator.hasNext()) {
            int readerIndex = (Integer)intIterator.next();
            if (this.nextLoadedForReader[readerIndex]) continue;
            this.activeIndex = readerIndex;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)String.format("Obtaining entry from reader=%d", this.activeIndex));
            }
            AlignmentReader reader = this.readers[this.activeIndex];
            try {
                boolean hasNext;
                Alignments.AlignmentEntry alignmentEntry = this.genomicRange != null ? reader.skipTo(this.genomicRange.startReferenceIndex, this.genomicRange.startPosition) : (reader.hasNext() ? reader.next() : null);
                boolean bl = hasNext = alignmentEntry != null;
                if (!hasNext) {
                    this.readersWithMoreEntries.remove(this.activeIndex);
                    continue;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)String.format("Considering %d:%d", alignmentEntry.getTargetIndex(), alignmentEntry.getPosition()));
                }
                if (this.genomicRange != null && this.genomicRange.positionIsPastEnd(alignmentEntry.getTargetIndex(), alignmentEntry.getPosition())) {
                    this.readersWithMoreEntries.remove(this.activeIndex);
                    if (!LOG.isTraceEnabled()) continue;
                    LOG.trace((Object)("Reached the end of slice for reader # " + this.activeIndex));
                    continue;
                }
                this.nextLoadedForReader[readerIndex] = true;
                Bucket bucket = this.buckets[readerIndex];
                bucket.readerIndex = readerIndex;
                bucket.entry = alignmentEntry;
                this.entryHeap.enqueue((Object)bucket);
            }
            catch (IOException e) {
                LOG.error((Object)"Could not read headers for sorted alignments.");
            }
        }
        this.hasNext = !this.entryHeap.isEmpty();
        return this.hasNext;
    }

    public int getReaderIndex() {
        return this.activeIndex;
    }

    @Override
    public Alignments.AlignmentEntry next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Bucket bucket = (Bucket)this.entryHeap.dequeue();
        int readerIndex = bucket.readerIndex;
        this.nextLoadedForReader[readerIndex] = false;
        this.hasNext = false;
        Alignments.AlignmentEntry alignmentEntry = bucket.entry;
        int newQueryIndex = this.mergedQueryIndex(readerIndex, alignmentEntry.getQueryIndex());
        int queryIndex = alignmentEntry.getQueryIndex();
        Alignments.AlignmentEntry.Builder builder = alignmentEntry.newBuilderForType().mergeFrom(alignmentEntry);
        if (this.adjustQueryIndices && newQueryIndex != queryIndex) {
            builder = builder.setQueryIndex(newQueryIndex);
        }
        if (this.adjustSampleIndices) {
            builder = builder.setSampleIndex(this.activeIndex);
        }
        builder = this.processReadGroups(alignmentEntry, builder, readerIndex);
        return builder.build();
    }

    public void setGenomicRange(GenomicRange genomicRange) throws IOException {
        this.genomicRange = genomicRange;
        Alignments.AlignmentEntry entry = this.skipTo(genomicRange.startReferenceIndex, genomicRange.startPosition);
        if (entry != null) {
            this.hasNext = true;
            this.entryHeap.enqueue((Object)new Bucket(entry, this.activeIndex));
        }
    }

    class Bucket {
        Alignments.AlignmentEntry entry;
        int readerIndex;

        public Bucket(Alignments.AlignmentEntry alignmentEntry, int index) {
            this.entry = alignmentEntry;
            this.readerIndex = index;
        }
    }
}

