/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.tools.sort;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.util.CloserUtil;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import org.apache.log4j.Logger;
import org.broad.igv.tools.sort.SortableRecord;
import org.broad.igv.tools.sort.Sorter;

public class BAMSorter
implements Sorter {
    private static Logger log = Logger.getLogger(BAMSorter.class);
    File inputFile;
    File outputFile;
    private File tmpDir;
    private int maxRecords = -1;

    public BAMSorter(File inputFile, File outputFile) {
        this.inputFile = inputFile;
        this.outputFile = outputFile;
    }

    @Override
    public void run() throws IOException {
        SamReaderFactory.setDefaultValidationStringency((ValidationStringency)ValidationStringency.SILENT);
        SamReader reader = SamReaderFactory.makeDefault().open(this.inputFile);
        reader.getFileHeader().setSortOrder(SAMFileHeader.SortOrder.coordinate);
        SAMFileWriterFactory samFileWriterFactory = new SAMFileWriterFactory();
        if (this.tmpDir != null) {
            samFileWriterFactory.setTempDirectory(this.tmpDir);
        }
        if (this.maxRecords > 0) {
            samFileWriterFactory.setMaxRecordsInRam(this.maxRecords);
        }
        SAMFileWriter writer = samFileWriterFactory.makeSAMOrBAMWriter(reader.getFileHeader(), false, this.outputFile);
        int count = 0;
        for (SAMRecord rec : reader) {
            if (++count % 100000 == 0) {
                System.out.println(count + " records processed");
            }
            writer.addAlignment(rec);
        }
        CloserUtil.close((Object)reader);
        writer.close();
    }

    @Override
    public void setTmpDir(File tmpDir) {
        this.tmpDir = tmpDir;
    }

    @Override
    public void setMaxRecords(int maxRecords) {
        this.maxRecords = maxRecords;
    }

    @Override
    public void setComparator(Comparator<SortableRecord> comparator) {
        throw new RuntimeException("Not implemented");
    }
}

