/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.SwingUtilities;

public class BasicGraphicsUtils {
    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void drawEtchedRect(Graphics g, int x, int y, int width, int height, Color shadow, Color darkShadow, Color highlight, Color lightHighlight) {
        Color oldColor = g.getColor();
        int x2 = x + width - 1;
        int y2 = y + height - 1;
        try {
            g.setColor(shadow);
            g.drawLine(x, y, x2 - 1, y);
            g.drawLine(x, y + 1, x, y2 - 1);
            g.setColor(darkShadow);
            g.drawLine(x + 1, y + 1, x2 - 2, y + 1);
            g.drawLine(x + 1, y + 2, x + 1, y2 - 2);
            g.setColor(highlight);
            g.drawLine(x + 1, y2 - 1, x2 - 1, y2 - 1);
            g.drawLine(x2 - 1, y + 1, x2 - 1, y2 - 2);
            g.setColor(lightHighlight);
            g.drawLine(x, y2, x2, y2);
            g.drawLine(x2, y, x2, y2 - 1);
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            g.setColor(oldColor);
            throw throwable;
        }
        {
            Object var13_14 = null;
            g.setColor(oldColor);
            return;
        }
    }

    public static Insets getEtchedInsets() {
        return new Insets(2, 2, 2, 2);
    }

    public static void drawGroove(Graphics g, int x, int y, int width, int height, Color shadow, Color highlight) {
        BasicGraphicsUtils.drawEtchedRect(g, x, y, width, height, shadow, highlight, shadow, highlight);
    }

    public static Insets getGrooveInsets() {
        return new Insets(2, 2, 2, 2);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void drawBezel(Graphics g, int x, int y, int width, int height, boolean isPressed, boolean isDefault, Color shadow, Color darkShadow, Color highlight, Color lightHighlight) {
        Color oldColor = g.getColor();
        try {
            if (!isPressed && !isDefault) {
                BasicGraphicsUtils.drawEtchedRect(g, x, y, width, height, lightHighlight, highlight, shadow, darkShadow);
            }
            if (isPressed && !isDefault) {
                g.setColor(shadow);
                g.drawRect(x + 1, y + 1, width - 2, height - 2);
            }
            if (!isPressed && isDefault) {
                g.setColor(darkShadow);
                g.drawRect(x, y, width - 1, height - 1);
                BasicGraphicsUtils.drawEtchedRect(g, x + 1, y + 1, width - 2, height - 2, lightHighlight, highlight, shadow, darkShadow);
            }
            if (isPressed && isDefault) {
                g.setColor(darkShadow);
                g.drawRect(x, y, width - 1, height - 1);
                g.setColor(shadow);
                g.drawRect(x + 1, y + 1, width - 3, height - 3);
            }
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            g.setColor(oldColor);
            throw throwable;
        }
        {
            Object var13_14 = null;
            g.setColor(oldColor);
            return;
        }
    }

    public static void drawLoweredBezel(Graphics g, int x, int y, int width, int height, Color shadow, Color darkShadow, Color highlight, Color lightHighlight) {
        BasicGraphicsUtils.drawEtchedRect(g, x, y, width, height, darkShadow, shadow, highlight, lightHighlight);
    }

    public static void drawString(Graphics g, String text, int underlinedChar, int x, int y) {
        int index = -1;
        if (underlinedChar >= 0 || underlinedChar <= (char)-1) {
            index = text.toLowerCase().indexOf(Character.toLowerCase((char)underlinedChar));
        }
        BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, index, x, y);
    }

    public static void drawStringUnderlineCharAt(Graphics g, String text, int underlinedIndex, int x, int y) {
        int textLength = text.length();
        if (textLength == 0) {
            return;
        }
        boolean bl = false;
        if (underlinedIndex >= 0 && underlinedIndex < textLength) {
            bl = true;
        }
        boolean drawUnderline = bl;
        g.drawString(text, x, y);
        if (drawUnderline) {
            FontMetrics fmet = g.getFontMetrics();
            g.fillRect(x + fmet.stringWidth(text.substring(0, underlinedIndex)), y + fmet.getDescent() - 1, fmet.charWidth(text.charAt(underlinedIndex)), 1);
        }
    }

    public static void drawDashedRect(Graphics g, int x, int y, int width, int height) {
        int right = x + width - 1;
        int bottom = y + height - 1;
        int i = x;
        while (i <= right) {
            g.drawLine(i, y, i, y);
            g.drawLine(i, bottom, i, bottom);
            i += 2;
        }
        i = y;
        while (i <= bottom) {
            g.drawLine(x, i, x, i);
            g.drawLine(right, i, right, i);
            i += 2;
        }
    }

    public static Dimension getPreferredButtonSize(AbstractButton b, int textIconGap) {
        Rectangle iconRect = new Rectangle();
        Rectangle textRect = new Rectangle();
        Insets insets = b.getInsets();
        Rectangle viewRect = new Rectangle();
        SwingUtilities.layoutCompoundLabel(b, b.getToolkit().getFontMetrics(b.getFont()), b.getText(), b.getIcon(), b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, textIconGap);
        Rectangle contentRect = textRect.union(iconRect);
        return new Dimension(insets.left + contentRect.width + insets.right + b.getHorizontalAlignment(), insets.top + contentRect.height + insets.bottom);
    }
}

