/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import netrexx.lang.Rexx;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.EnumeratedAttribute;

public class NetRexxC
extends MatchingTask {
    private boolean binary;
    private String classpath;
    private boolean comments;
    private boolean compact = true;
    private boolean compile = true;
    private boolean console;
    private boolean crossref;
    private boolean decimal = true;
    private File destDir;
    private boolean diag;
    private boolean explicit;
    private boolean format;
    private boolean java;
    private boolean keep;
    private boolean logo = true;
    private boolean replace;
    private boolean savelog;
    private File srcDir;
    private boolean sourcedir = true;
    private boolean strictargs;
    private boolean strictassign;
    private boolean strictcase;
    private boolean strictimport;
    private boolean strictprops;
    private boolean strictsignal;
    private boolean symbols;
    private boolean time;
    private String trace = "trace2";
    private boolean utf8;
    private String verbose = "verbose3";
    private boolean suppressMethodArgumentNotUsed = false;
    private boolean suppressPrivatePropertyNotUsed = false;
    private boolean suppressVariableNotUsed = false;
    private boolean suppressExceptionNotSignalled = false;
    private boolean suppressDeprecation = false;
    static final String MSG_METHOD_ARGUMENT_NOT_USED = "Warning: Method argument is not used";
    static final String MSG_PRIVATE_PROPERTY_NOT_USED = "Warning: Private property is defined but not used";
    static final String MSG_VARIABLE_NOT_USED = "Warning: Variable is set but not used";
    static final String MSG_EXCEPTION_NOT_SIGNALLED = "is in SIGNALS list but is not signalled within the method";
    static final String MSG_DEPRECATION = "has been deprecated";
    private Vector compileList = new Vector();
    private Hashtable filecopyList = new Hashtable();
    private String oldClasspath = System.getProperty("java.class.path");

    public void setBinary(boolean binary) {
        this.binary = binary;
    }

    public void setClasspath(String classpath) {
        this.classpath = classpath;
    }

    public void setComments(boolean comments) {
        this.comments = comments;
    }

    public void setCompact(boolean compact) {
        this.compact = compact;
    }

    public void setCompile(boolean compile) {
        this.compile = compile;
        if (!this.compile && !this.keep) {
            this.keep = true;
        }
    }

    public void setConsole(boolean console) {
        this.console = console;
    }

    public void setCrossref(boolean crossref) {
        this.crossref = crossref;
    }

    public void setDecimal(boolean decimal) {
        this.decimal = decimal;
    }

    public void setDestDir(File destDirName) {
        this.destDir = destDirName;
    }

    public void setDiag(boolean diag) {
        this.diag = diag;
    }

    public void setExplicit(boolean explicit) {
        this.explicit = explicit;
    }

    public void setFormat(boolean format) {
        this.format = format;
    }

    public void setJava(boolean java) {
        this.java = java;
    }

    public void setKeep(boolean keep) {
        this.keep = keep;
    }

    public void setLogo(boolean logo) {
        this.logo = logo;
    }

    public void setReplace(boolean replace) {
        this.replace = replace;
    }

    public void setSavelog(boolean savelog) {
        this.savelog = savelog;
    }

    public void setSourcedir(boolean sourcedir) {
        this.sourcedir = sourcedir;
    }

    public void setSrcDir(File srcDirName) {
        this.srcDir = srcDirName;
    }

    public void setStrictargs(boolean strictargs) {
        this.strictargs = strictargs;
    }

    public void setStrictassign(boolean strictassign) {
        this.strictassign = strictassign;
    }

    public void setStrictcase(boolean strictcase) {
        this.strictcase = strictcase;
    }

    public void setStrictimport(boolean strictimport) {
        this.strictimport = strictimport;
    }

    public void setStrictprops(boolean strictprops) {
        this.strictprops = strictprops;
    }

    public void setStrictsignal(boolean strictsignal) {
        this.strictsignal = strictsignal;
    }

    public void setSymbols(boolean symbols) {
        this.symbols = symbols;
    }

    public void setTime(boolean time) {
        this.time = time;
    }

    public void setTrace(TraceAttr trace) {
        this.trace = trace.getValue();
    }

    public void setTrace(String trace) {
        TraceAttr t = new TraceAttr();
        t.setValue(trace);
        this.setTrace(t);
    }

    public void setUtf8(boolean utf8) {
        this.utf8 = utf8;
    }

    public void setVerbose(VerboseAttr verbose) {
        this.verbose = verbose.getValue();
    }

    public void setVerbose(String verbose) {
        VerboseAttr v = new VerboseAttr();
        v.setValue(verbose);
        this.setVerbose(v);
    }

    public void setSuppressMethodArgumentNotUsed(boolean suppressMethodArgumentNotUsed) {
        this.suppressMethodArgumentNotUsed = suppressMethodArgumentNotUsed;
    }

    public void setSuppressPrivatePropertyNotUsed(boolean suppressPrivatePropertyNotUsed) {
        this.suppressPrivatePropertyNotUsed = suppressPrivatePropertyNotUsed;
    }

    public void setSuppressVariableNotUsed(boolean suppressVariableNotUsed) {
        this.suppressVariableNotUsed = suppressVariableNotUsed;
    }

    public void setSuppressExceptionNotSignalled(boolean suppressExceptionNotSignalled) {
        this.suppressExceptionNotSignalled = suppressExceptionNotSignalled;
    }

    public void setSuppressDeprecation(boolean suppressDeprecation) {
        this.suppressDeprecation = suppressDeprecation;
    }

    public void init() {
        String p = ((ProjectComponent)this).project.getProperty("ant.netrexxc.binary");
        if (p != null) {
            this.binary = Project.toBoolean((String)p);
        }
        if ((p = ((ProjectComponent)this).project.getProperty("ant.netrexxc.comments")) != null) {
            this.comments = Project.toBoolean((String)p);
        }
        if ((p = ((ProjectComponent)this).project.getProperty("ant.netrexxc.compact")) != null) {
            this.compact = Project.toBoolean((String)p);
        }
        if ((p = ((ProjectComponent)this).project.getProperty("ant.netrexxc.compile")) != null) {
            this.compile = Project.toBoolean((String)p);
        }
        if ((p = ((ProjectComponent)this).project.getProperty("ant.netrexxc.console")) != null) {
            this.console = Project.toBoolean((String)p);
        }
        if ((p = ((ProjectComponent)this).project.getProperty("ant.netrexxc.crossref")) != null) {
            this.crossref = Project.toBoolean((String)p);
        }
        if ((p = ((ProjectComponent)this).project.getProperty("ant.netrexxc.decimal")) != null) {
            this.decimal = Project.toBoolean((String)p);
        }
        if ((p = ((ProjectComponent)this).project.getProperty("ant.netrexxc.diag")) != null) {
            this.diag = Project.toBoolean((String)p);
        }
        if ((p = ((ProjectComponent)this).project.getProperty("ant.netrexxc.explicit")) != null) {
            this.explicit = Project.toBoolean((String)p);
        }
        if ((p = ((ProjectComponent)this).project.getProperty("ant.netrexxc.format")) != null) {
            this.format = Project.toBoolean((String)p);
        }
        if ((p = ((ProjectComponent)this).project.getProperty("ant.netrexxc.java")) != null) {
            this.java = Project.toBoolean((String)p);
        }
        if ((p = ((ProjectComponent)this).project.getProperty("ant.netrexxc.keep")) != null) {
            this.keep = Project.toBoolean((String)p);
        }
        if ((p = ((ProjectComponent)this).project.getProperty("ant.netrexxc.logo")) != null) {
            this.logo = Project.toBoolean((String)p);
        }
        if ((p = ((ProjectComponent)this).project.getProperty("ant.netrexxc.replace")) != null) {
            this.replace = Project.toBoolean((String)p);
        }
        if ((p = ((ProjectComponent)this).project.getProperty("ant.netrexxc.savelog")) != null) {
            this.savelog = Project.toBoolean((String)p);
        }
        if ((p = ((ProjectComponent)this).project.getProperty("ant.netrexxc.sourcedir")) != null) {
            this.sourcedir = Project.toBoolean((String)p);
        }
        if ((p = ((ProjectComponent)this).project.getProperty("ant.netrexxc.strictargs")) != null) {
            this.strictargs = Project.toBoolean((String)p);
        }
        if ((p = ((ProjectComponent)this).project.getProperty("ant.netrexxc.strictassign")) != null) {
            this.strictassign = Project.toBoolean((String)p);
        }
        if ((p = ((ProjectComponent)this).project.getProperty("ant.netrexxc.strictcase")) != null) {
            this.strictcase = Project.toBoolean((String)p);
        }
        if ((p = ((ProjectComponent)this).project.getProperty("ant.netrexxc.strictimport")) != null) {
            this.strictimport = Project.toBoolean((String)p);
        }
        if ((p = ((ProjectComponent)this).project.getProperty("ant.netrexxc.strictprops")) != null) {
            this.strictprops = Project.toBoolean((String)p);
        }
        if ((p = ((ProjectComponent)this).project.getProperty("ant.netrexxc.strictsignal")) != null) {
            this.strictsignal = Project.toBoolean((String)p);
        }
        if ((p = ((ProjectComponent)this).project.getProperty("ant.netrexxc.symbols")) != null) {
            this.symbols = Project.toBoolean((String)p);
        }
        if ((p = ((ProjectComponent)this).project.getProperty("ant.netrexxc.time")) != null) {
            this.time = Project.toBoolean((String)p);
        }
        if ((p = ((ProjectComponent)this).project.getProperty("ant.netrexxc.trace")) != null) {
            this.setTrace(p);
        }
        if ((p = ((ProjectComponent)this).project.getProperty("ant.netrexxc.utf8")) != null) {
            this.utf8 = Project.toBoolean((String)p);
        }
        if ((p = ((ProjectComponent)this).project.getProperty("ant.netrexxc.verbose")) != null) {
            this.setVerbose(p);
        }
        if ((p = ((ProjectComponent)this).project.getProperty("ant.netrexxc.suppressMethodArgumentNotUsed")) != null) {
            this.suppressMethodArgumentNotUsed = Project.toBoolean((String)p);
        }
        if ((p = ((ProjectComponent)this).project.getProperty("ant.netrexxc.suppressPrivatePropertyNotUsed")) != null) {
            this.suppressPrivatePropertyNotUsed = Project.toBoolean((String)p);
        }
        if ((p = ((ProjectComponent)this).project.getProperty("ant.netrexxc.suppressVariableNotUsed")) != null) {
            this.suppressVariableNotUsed = Project.toBoolean((String)p);
        }
        if ((p = ((ProjectComponent)this).project.getProperty("ant.netrexxc.suppressExceptionNotSignalled")) != null) {
            this.suppressExceptionNotSignalled = Project.toBoolean((String)p);
        }
        if ((p = ((ProjectComponent)this).project.getProperty("ant.netrexxc.suppressDeprecation")) != null) {
            this.suppressDeprecation = Project.toBoolean((String)p);
        }
    }

    public void execute() throws BuildException {
        if (this.srcDir == null || this.destDir == null) {
            throw new BuildException("srcDir and destDir attributes must be set!");
        }
        DirectoryScanner ds = this.getDirectoryScanner(this.srcDir);
        String[] files = ds.getIncludedFiles();
        this.scanDir(this.srcDir, this.destDir, files);
        this.copyFilesToDestination();
        if (this.compileList.size() > 0) {
            this.log("Compiling " + this.compileList.size() + " source file" + (this.compileList.size() == 1 ? "" : "s") + " to " + this.destDir);
            this.doNetRexxCompile();
        }
    }

    private void scanDir(File srcDir, File destDir, String[] files) {
        for (int i = 0; i < files.length; ++i) {
            File srcFile = new File(srcDir, files[i]);
            File destFile = new File(destDir, files[i]);
            String filename = files[i];
            if (filename.toLowerCase().endsWith(".nrx")) {
                File classFile = new File(destDir, filename.substring(0, filename.lastIndexOf(46)) + ".class");
                if (this.compile && srcFile.lastModified() <= classFile.lastModified()) continue;
                this.filecopyList.put(srcFile.getAbsolutePath(), destFile.getAbsolutePath());
                this.compileList.addElement(destFile.getAbsolutePath());
                continue;
            }
            if (srcFile.lastModified() <= destFile.lastModified()) continue;
            this.filecopyList.put(srcFile.getAbsolutePath(), destFile.getAbsolutePath());
        }
    }

    private void copyFilesToDestination() {
        if (this.filecopyList.size() > 0) {
            this.log("Copying " + this.filecopyList.size() + " file" + (this.filecopyList.size() == 1 ? "" : "s") + " to " + this.destDir.getAbsolutePath());
            Enumeration enumeration = this.filecopyList.keys();
            while (enumeration.hasMoreElements()) {
                String fromFile = (String)enumeration.nextElement();
                String toFile = (String)this.filecopyList.get(fromFile);
                try {
                    ((ProjectComponent)this).project.copyFile(fromFile, toFile);
                }
                catch (IOException ioe) {
                    String msg = "Failed to copy " + fromFile + " to " + toFile + " due to " + ioe.getMessage();
                    throw new BuildException(msg, (Throwable)ioe);
                }
            }
        }
    }

    private void doNetRexxCompile() throws BuildException {
        int i;
        this.log("Using NetRexx compiler", 3);
        String classpath = this.getCompileClasspath();
        StringBuffer compileOptions = new StringBuffer();
        StringBuffer fileList = new StringBuffer();
        String[] compileOptionsArray = this.getCompileOptionsAsArray();
        String[] fileListArray = new String[this.compileList.size()];
        Enumeration e = this.compileList.elements();
        int j = 0;
        while (e.hasMoreElements()) {
            fileListArray[j] = (String)e.nextElement();
            ++j;
        }
        String[] compileArgs = new String[compileOptionsArray.length + fileListArray.length];
        for (i = 0; i < compileOptionsArray.length; ++i) {
            compileArgs[i] = compileOptionsArray[i];
        }
        for (i = 0; i < fileListArray.length; ++i) {
            compileArgs[i + compileOptionsArray.length] = fileListArray[i];
        }
        compileOptions.append("Compilation args: ");
        for (i = 0; i < compileOptionsArray.length; ++i) {
            compileOptions.append(compileOptionsArray[i]);
            compileOptions.append(" ");
        }
        this.log(compileOptions.toString(), 3);
        String eol = System.getProperty("line.separator");
        StringBuffer niceSourceList = new StringBuffer("Files to be compiled:" + eol);
        for (int i2 = 0; i2 < this.compileList.size(); ++i2) {
            niceSourceList.append("    ");
            niceSourceList.append(this.compileList.elementAt(i2).toString());
            niceSourceList.append(eol);
        }
        this.log(niceSourceList.toString(), 3);
        String currentClassPath = System.getProperty("java.class.path");
        Properties currentProperties = System.getProperties();
        ((Hashtable)currentProperties).put("java.class.path", classpath);
        try {
            String l;
            StringWriter out = new StringWriter();
            int rc = COM.ibm.netrexx.process.NetRexxC.main((Rexx)new Rexx(compileArgs), (PrintWriter)new PrintWriter(out));
            String sdir = this.srcDir.getAbsolutePath();
            String ddir = this.destDir.getAbsolutePath();
            boolean doReplace = !sdir.equals(ddir);
            int dlen = ddir.length();
            BufferedReader in = new BufferedReader(new StringReader(out.toString()));
            this.log("replacing destdir '" + ddir + "' through sourcedir '" + sdir + "'", 3);
            while ((l = in.readLine()) != null) {
                int idx;
                while (doReplace && (idx = l.indexOf(ddir)) != -1) {
                    l = new StringBuffer(l).replace(idx, idx + dlen, sdir).toString();
                }
                if (this.suppressMethodArgumentNotUsed && l.indexOf(MSG_METHOD_ARGUMENT_NOT_USED) != -1) {
                    this.log(l, 3);
                    continue;
                }
                if (this.suppressPrivatePropertyNotUsed && l.indexOf(MSG_PRIVATE_PROPERTY_NOT_USED) != -1) {
                    this.log(l, 3);
                    continue;
                }
                if (this.suppressVariableNotUsed && l.indexOf(MSG_VARIABLE_NOT_USED) != -1) {
                    this.log(l, 3);
                    continue;
                }
                if (this.suppressExceptionNotSignalled && l.indexOf(MSG_EXCEPTION_NOT_SIGNALLED) != -1) {
                    this.log(l, 3);
                    continue;
                }
                if (this.suppressDeprecation && l.indexOf(MSG_DEPRECATION) != -1) {
                    this.log(l, 3);
                    continue;
                }
                if (l.indexOf("Error:") != -1) {
                    this.log(l, 0);
                    continue;
                }
                if (l.indexOf("Warning:") != -1) {
                    this.log(l, 1);
                    continue;
                }
                this.log(l, 2);
            }
            if (rc > 1) {
                throw new BuildException("Compile failed, messages should have been provided.");
            }
        }
        catch (IOException ioe) {
            throw new BuildException("Unexpected IOException while playing with Strings", (Throwable)ioe);
        }
        finally {
            currentProperties = System.getProperties();
            ((Hashtable)currentProperties).put("java.class.path", currentClassPath);
        }
    }

    private String getCompileClasspath() {
        StringBuffer classpath = new StringBuffer();
        classpath.append(this.destDir.getAbsolutePath());
        if (this.classpath != null) {
            this.addExistingToClasspath(classpath, this.classpath);
        }
        return classpath.toString();
    }

    private String[] getCompileOptionsAsArray() {
        Vector<String> options = new Vector<String>();
        options.addElement(this.binary ? "-binary" : "-nobinary");
        options.addElement(this.comments ? "-comments" : "-nocomments");
        options.addElement(this.compile ? "-compile" : "-nocompile");
        options.addElement(this.compact ? "-compact" : "-nocompact");
        options.addElement(this.console ? "-console" : "-noconsole");
        options.addElement(this.crossref ? "-crossref" : "-nocrossref");
        options.addElement(this.decimal ? "-decimal" : "-nodecimal");
        options.addElement(this.diag ? "-diag" : "-nodiag");
        options.addElement(this.explicit ? "-explicit" : "-noexplicit");
        options.addElement(this.format ? "-format" : "-noformat");
        options.addElement(this.keep ? "-keep" : "-nokeep");
        options.addElement(this.logo ? "-logo" : "-nologo");
        options.addElement(this.replace ? "-replace" : "-noreplace");
        options.addElement(this.savelog ? "-savelog" : "-nosavelog");
        options.addElement(this.sourcedir ? "-sourcedir" : "-nosourcedir");
        options.addElement(this.strictargs ? "-strictargs" : "-nostrictargs");
        options.addElement(this.strictassign ? "-strictassign" : "-nostrictassign");
        options.addElement(this.strictcase ? "-strictcase" : "-nostrictcase");
        options.addElement(this.strictimport ? "-strictimport" : "-nostrictimport");
        options.addElement(this.strictprops ? "-strictprops" : "-nostrictprops");
        options.addElement(this.strictsignal ? "-strictsignal" : "-nostrictsignal");
        options.addElement(this.symbols ? "-symbols" : "-nosymbols");
        options.addElement(this.time ? "-time" : "-notime");
        options.addElement("-" + this.trace);
        options.addElement(this.utf8 ? "-utf8" : "-noutf8");
        options.addElement("-" + this.verbose);
        Object[] results = new String[options.size()];
        options.copyInto(results);
        return results;
    }

    private void addExistingToClasspath(StringBuffer target, String source) {
        StringTokenizer tok = new StringTokenizer(source, System.getProperty("path.separator"), false);
        while (tok.hasMoreTokens()) {
            File f = ((ProjectComponent)this).project.resolveFile(tok.nextToken());
            if (f.exists()) {
                target.append(File.pathSeparator);
                target.append(f.getAbsolutePath());
                continue;
            }
            this.log("Dropping from classpath: " + f.getAbsolutePath(), 3);
        }
    }

    public static class VerboseAttr
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"verbose", "verbose0", "verbose1", "verbose2", "verbose3", "verbose4", "verbose5", "noverbose"};
        }
    }

    public static class TraceAttr
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"trace", "trace1", "trace2", "notrace"};
        }
    }
}

