/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.java.security.hash.HashFactory;
import gnu.java.security.hash.IMessageDigest;
import gnu.java.security.sig.ISignature;
import gnu.java.security.sig.rsa.RSA;
import gnu.javax.net.ssl.provider.Util;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;
import java.util.Map;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
final class SSLRSASignature
implements ISignature {
    private RSAPublicKey pubkey;
    private RSAPrivateKey privkey;
    private final IMessageDigest md5;
    private final IMessageDigest sha;
    private boolean initVerify;
    private boolean initSign;

    public final String name() {
        return "RSA/SSL";
    }

    public final void setupVerify(Map map) {
        PublicKey publicKey = (PublicKey)map.get("gnu.crypto.sig.public.key");
        if (publicKey == null) {
            if (this.initSign) {
                return;
            }
            throw new IllegalArgumentException("no key supplied");
        }
        if (!(publicKey instanceof RSAPublicKey)) {
            throw new IllegalArgumentException("not an RSA key");
        }
        this.pubkey = (RSAPublicKey)publicKey;
        this.privkey = null;
        this.initSign = false;
        this.initVerify = true;
    }

    public final void setupSign(Map map) {
        PrivateKey privateKey = (PrivateKey)map.get("gnu.crypto.sig.private.key");
        if (privateKey == null) {
            if (this.initVerify) {
                return;
            }
            throw new IllegalArgumentException("no key supplied");
        }
        if (!(privateKey instanceof RSAPrivateKey)) {
            throw new IllegalArgumentException("not an RSA key");
        }
        this.privkey = (RSAPrivateKey)privateKey;
        this.pubkey = null;
        this.initVerify = false;
        this.initSign = true;
    }

    public final void update(byte by) {
        if (!this.initVerify && !this.initSign) {
            throw new IllegalStateException();
        }
        this.md5.update(by);
        this.sha.update(by);
    }

    public final void update(byte[] byArray, int n, int n2) {
        if (!this.initVerify && !this.initSign) {
            throw new IllegalStateException();
        }
        this.md5.update(byArray, n, n2);
        this.sha.update(byArray, n, n2);
    }

    public final Object sign() {
        byte[] byArray;
        if (!this.initSign) {
            throw new IllegalStateException();
        }
        int n = this.privkey.getModulus().bitLength() + 7 >>> 3;
        if (n - 11 < (byArray = Util.concat(this.md5.digest(), this.sha.digest())).length) {
            throw new IllegalArgumentException("message too long");
        }
        byte[] byArray2 = new byte[n];
        byArray2[0] = 0;
        byArray2[1] = 1;
        int n2 = 2;
        while (n2 < n - byArray.length - 1) {
            byArray2[n2] = -1;
            ++n2;
        }
        System.arraycopy(byArray, 0, byArray2, n - byArray.length, byArray.length);
        BigInteger bigInteger = new BigInteger(byArray2);
        BigInteger bigInteger2 = RSA.sign(this.privkey, bigInteger);
        return Util.trim(bigInteger2);
    }

    public final boolean verify(Object object) {
        if (!this.initVerify) {
            throw new IllegalStateException();
        }
        BigInteger bigInteger = new BigInteger(1, (byte[])object);
        BigInteger bigInteger2 = RSA.verify(this.pubkey, bigInteger);
        int n = 0;
        byte[] byArray = bigInteger2.toByteArray();
        if (byArray[0] == 0) {
            n = 0;
            while (n < byArray.length && byArray[n] == 0) {
                ++n;
            }
        } else if (byArray[0] == 1) {
            n = 1;
            while (n < byArray.length && byArray[n] != 0) {
                if (byArray[n] != -1) {
                    throw new IllegalArgumentException("bad padding");
                }
                ++n;
            }
            ++n;
        } else {
            throw new IllegalArgumentException("decryption failed");
        }
        byte[] byArray2 = Util.trim(byArray, n, byArray.length - n);
        byte[] byArray3 = Util.concat(this.md5.digest(), this.sha.digest());
        return Arrays.equals(byArray2, byArray3);
    }

    public final Object clone() {
        throw new UnsupportedOperationException();
    }

    private final /* synthetic */ void this() {
        this.initVerify = false;
        this.initSign = false;
    }

    SSLRSASignature() {
        this(HashFactory.getInstance("MD5"), HashFactory.getInstance("SHA-1"));
    }

    SSLRSASignature(IMessageDigest iMessageDigest, IMessageDigest iMessageDigest2) {
        this.this();
        this.md5 = iMessageDigest;
        this.sha = iMessageDigest2;
    }
}

