/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AttributeValue;

public final class JobAttributes
implements Cloneable {
    private int copies;
    private DefaultSelectionType selection;
    private DestinationType destination;
    private DialogType dialog;
    private String filename;
    private int maxPage;
    private int minPage;
    private MultipleDocumentHandlingType multiple;
    private int[][] pageRanges;
    private int fromPage;
    private int toPage;
    private String printer;
    private SidesType sides;

    public final Object clone() {
        return new JobAttributes(this);
    }

    public final void set(JobAttributes jobAttributes) {
        this.copies = jobAttributes.copies;
        this.selection = jobAttributes.selection;
        this.destination = jobAttributes.destination;
        this.dialog = jobAttributes.dialog;
        this.filename = jobAttributes.filename;
        this.maxPage = jobAttributes.maxPage;
        this.minPage = jobAttributes.minPage;
        this.multiple = jobAttributes.multiple;
        this.pageRanges = (int[][])jobAttributes.pageRanges.clone();
        this.printer = jobAttributes.printer;
        this.sides = jobAttributes.sides;
        this.fromPage = jobAttributes.fromPage;
        this.toPage = jobAttributes.toPage;
    }

    public final int getCopies() {
        return this.copies;
    }

    public final void setCopies(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        this.copies = n;
    }

    public final void setCopiesToDefault() {
        this.copies = 1;
    }

    public final DefaultSelectionType getDefaultSelection() {
        return this.selection;
    }

    public final void setDefaultSelection(DefaultSelectionType defaultSelectionType) {
        if (defaultSelectionType == null) {
            throw new IllegalArgumentException();
        }
        this.selection = defaultSelectionType;
    }

    public final DestinationType getDestination() {
        return this.destination;
    }

    public final void setDestination(DestinationType destinationType) {
        if (destinationType == null) {
            throw new IllegalArgumentException();
        }
        this.destination = destinationType;
    }

    public final DialogType getDialog() {
        return this.dialog;
    }

    public final void setDialog(DialogType dialogType) {
        if (dialogType == null) {
            throw new IllegalArgumentException();
        }
        this.dialog = dialogType;
    }

    public final String getFileName() {
        return this.filename;
    }

    public final void setFileName(String string) {
        this.filename = string;
    }

    public final int getFromPage() {
        return this.fromPage != 0 ? this.fromPage : (this.pageRanges != null ? this.pageRanges[0][0] : (this.toPage != 0 ? this.toPage : this.minPage));
    }

    public final void setFromPage(int n) {
        if (n < this.minPage || n > this.toPage && this.toPage != 0 || n > this.maxPage) {
            throw new IllegalArgumentException();
        }
        if (this.pageRanges == null) {
            this.fromPage = n;
        }
    }

    public final int getMaxPage() {
        return this.maxPage;
    }

    public final void setMaxPage(int n) {
        if (n < this.minPage) {
            throw new IllegalArgumentException();
        }
        this.maxPage = n;
        if (n < this.fromPage) {
            this.fromPage = n;
        }
        if (n < this.toPage) {
            this.toPage = n;
        }
        if (this.pageRanges != null) {
            int n2 = this.pageRanges.length - 1;
            while (n2 >= 0 && n < this.pageRanges[n2][1]) {
                --n2;
            }
            if (n >= this.pageRanges[++n2][0]) {
                this.pageRanges[n2++][1] = n;
            }
            if (n2 == 0) {
                this.pageRanges = null;
            } else if (n2 < this.pageRanges.length) {
                int[][] nArrayArray = new int[n2][];
                System.arraycopy(this.pageRanges, 0, nArrayArray, 0, n2);
                this.pageRanges = nArrayArray;
            }
        }
    }

    public final int getMinPage() {
        return this.minPage;
    }

    public final void setMinPage(int n) {
        if (n <= 0 || n > this.maxPage) {
            throw new IllegalArgumentException();
        }
        this.minPage = n;
        if (n > this.toPage) {
            this.toPage = n;
        }
        if (n > this.fromPage) {
            this.fromPage = n;
        }
        if (this.pageRanges != null) {
            int n2 = this.pageRanges.length;
            int n3 = 0;
            while (n3 < n2 && n > this.pageRanges[n3][0]) {
                ++n3;
            }
            if (n <= this.pageRanges[n3 - 1][1]) {
                this.pageRanges[--n3][0] = n;
            }
            if (n3 == n2) {
                this.pageRanges = null;
            } else if (n3 > 0) {
                int[][] nArrayArray = new int[n2 - n3][];
                System.arraycopy(this.pageRanges, n3, nArrayArray, 0, n2 - n3);
                this.pageRanges = nArrayArray;
            }
        }
    }

    public final MultipleDocumentHandlingType getMultipleDocumentHandling() {
        return this.multiple;
    }

    public final void setMultipleDocumentHandling(MultipleDocumentHandlingType multipleDocumentHandlingType) {
        if (multipleDocumentHandlingType == null) {
            throw new IllegalArgumentException();
        }
        this.multiple = multipleDocumentHandlingType;
    }

    public final void setMultipleDocumentHandlingToDefault() {
        this.multiple = MultipleDocumentHandlingType.SEPARATE_DOCUMENTS_UNCOLLATED_COPIES;
    }

    public final int[][] getPageRanges() {
        if (this.pageRanges == null) {
            return new int[][]{{this.getFromPage(), this.getToPage()}};
        }
        int n = this.pageRanges.length;
        int[][] nArrayArray = new int[n][];
        while (--n >= 0) {
            nArrayArray[n] = (int[])this.pageRanges[n].clone();
        }
        return nArrayArray;
    }

    /*
     * Unable to fully structure code
     */
    public final void setPageRanges(int[][] var1_1) {
        v0 = 0;
        if (var1_1 != null) {
            v0 = var1_1.length;
        }
        if ((var2_2 = v0) != 0) ** GOTO lbl9
        throw new IllegalArgumentException();
lbl-1000:
        // 1 sources

        {
            var3_3 = var1_1[var2_2];
            if (var3_3 != null && var3_3.length == 2 && var3_3[0] >= this.minPage && var3_3[1] >= var3_3[0] && var3_3[1] <= this.maxPage && (var2_2 == 0 || var3_3[0] > var1_1[var2_2 - 1][1])) continue;
            throw new IllegalArgumentException();
lbl9:
            // 2 sources

            ** while (--var2_2 >= 0)
        }
lbl10:
        // 1 sources

        var2_2 = var1_1.length;
        if (this.fromPage > 0 && var1_1[0][0] > this.fromPage) {
            this.fromPage = var1_1[0][0];
        }
        if (this.toPage > 0 && var1_1[var2_2 - 1][1] < this.toPage) {
            this.toPage = var1_1[var2_2 - 1][1];
        }
        this.pageRanges = new int[var2_2][];
        while (--var2_2 >= 0) {
            this.pageRanges[var2_2] = (int[])var1_1[var2_2].clone();
        }
    }

    public final String getPrinter() {
        return this.printer;
    }

    public final void setPrinter(String string) {
        this.printer = string;
    }

    public final SidesType getSides() {
        return this.sides;
    }

    public final void setSides(SidesType sidesType) {
        if (sidesType == null) {
            throw new IllegalArgumentException();
        }
        this.sides = sidesType;
    }

    public final void setSidesToDefault() {
        this.sides = SidesType.ONE_SIDED;
    }

    public final int getToPage() {
        return this.toPage != 0 ? this.toPage : (this.pageRanges != null ? this.pageRanges[this.pageRanges.length - 1][1] : (this.fromPage != 0 ? this.fromPage : this.maxPage));
    }

    public final void setToPage(int n) {
        if (n < this.minPage || this.fromPage > n && this.fromPage != 0 || n > this.maxPage) {
            throw new IllegalArgumentException();
        }
        if (this.pageRanges == null) {
            this.toPage = n;
        }
    }

    public final boolean equals(Object object) {
        JobAttributes jobAttributes;
        block10: {
            block9: {
                if (this == object) {
                    return true;
                }
                if (!(object instanceof JobAttributes)) {
                    return false;
                }
                jobAttributes = (JobAttributes)object;
                if (this.copies != jobAttributes.copies || this.selection != jobAttributes.selection || this.destination != jobAttributes.destination || this.dialog != jobAttributes.dialog || !this.filename.equals(jobAttributes.filename) || this.maxPage != jobAttributes.maxPage || this.minPage != jobAttributes.minPage || this.multiple != jobAttributes.multiple || this.fromPage != jobAttributes.fromPage || this.toPage != jobAttributes.toPage || !this.printer.equals(jobAttributes.printer) || this.sides != jobAttributes.sides) break block9;
                boolean bl = false;
                if (this.pageRanges == null) {
                    bl = true;
                }
                boolean bl2 = false;
                if (jobAttributes.pageRanges == null) {
                    bl2 = true;
                }
                if (bl == bl2) break block10;
            }
            return false;
        }
        if (this.pageRanges != jobAttributes.pageRanges) {
            int n = this.pageRanges.length;
            while (--n >= 0) {
                if (this.pageRanges[n][0] == jobAttributes.pageRanges[n][0] && this.pageRanges[n][1] == jobAttributes.pageRanges[n][1]) continue;
                return false;
            }
        }
        return true;
    }

    public final int hashCode() {
        int n = this.selection.value << 6 ^ this.destination.value << 5 ^ this.dialog.value << 3 ^ this.multiple.value << 2 ^ this.sides.value;
        int n2 = 0;
        if (this.filename != null) {
            n2 = this.filename.hashCode();
        }
        int n3 = n ^ n2;
        int n4 = 0;
        if (this.printer != null) {
            n4 = this.printer.hashCode();
        }
        int n5 = n3 ^ n4;
        n5 ^= this.copies << 27 ^ this.maxPage << 22 ^ this.minPage << 17;
        if (this.pageRanges == null) {
            n5 ^= this.getFromPage() << 13 ^ this.getToPage() << 8;
        } else {
            int n6 = this.pageRanges.length;
            while (--n6 >= 0) {
                n5 ^= this.pageRanges[n6][0] << 13 ^ this.pageRanges[n6][1] << 8;
            }
        }
        return n5;
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer("copies=").append(this.copies).append(",defaultSelection=").append(this.selection).append(",destination=").append(this.destination).append(",dialog=").append(this.dialog).append(",fileName=").append(this.filename).append(",fromPage=").append(this.getFromPage()).append(",maxPage=").append(this.maxPage).append(",minPage=").append(this.minPage).append(",multiple-document-handling=").append(this.multiple).append(",page-ranges=[");
        if (this.pageRanges == null) {
            stringBuffer.append(this.minPage).append(':').append(this.minPage).append(']');
        } else {
            int n = 0;
            while (n < this.pageRanges.length) {
                stringBuffer.append(this.pageRanges[n][0]).append(':').append(this.pageRanges[n][1]).append(',');
                ++n;
            }
        }
        stringBuffer.setLength(stringBuffer.length() - 1);
        return stringBuffer.append("],printer=").append(this.printer).append(",sides=").append(this.sides).append(",toPage=").append(this.getToPage()).toString();
    }

    public JobAttributes() {
        this.copies = 1;
        this.selection = DefaultSelectionType.ALL;
        this.destination = DestinationType.PRINTER;
        this.dialog = DialogType.NATIVE;
        this.maxPage = Integer.MAX_VALUE;
        this.minPage = 1;
        this.multiple = MultipleDocumentHandlingType.SEPARATE_DOCUMENTS_UNCOLLATED_COPIES;
        this.sides = SidesType.ONE_SIDED;
    }

    public JobAttributes(JobAttributes jobAttributes) {
        this.set(jobAttributes);
    }

    public JobAttributes(int n, DefaultSelectionType defaultSelectionType, DestinationType destinationType, DialogType dialogType, String string, int n2, int n3, MultipleDocumentHandlingType multipleDocumentHandlingType, int[][] nArray, String string2, SidesType sidesType) {
        if (n <= 0 || defaultSelectionType == null || destinationType == null || dialogType == null || n2 < n3 || n3 <= 0 || multipleDocumentHandlingType == null || sidesType == null) {
            throw new IllegalArgumentException();
        }
        this.copies = n;
        this.selection = defaultSelectionType;
        this.destination = destinationType;
        this.dialog = dialogType;
        this.filename = string;
        this.maxPage = n2;
        this.minPage = n3;
        this.multiple = multipleDocumentHandlingType;
        this.setPageRanges(nArray);
        this.printer = string2;
        this.sides = sidesType;
    }

    public static final class MultipleDocumentHandlingType
    extends AttributeValue {
        private static final String[] NAMES = new String[]{"separate-documents-collated-copies", "separate-documents-uncollated-copies"};
        public static final MultipleDocumentHandlingType SEPARATE_DOCUMENTS_COLLATED_COPIES = new MultipleDocumentHandlingType(0);
        public static final MultipleDocumentHandlingType SEPARATE_DOCUMENTS_UNCOLLATED_COPIES = new MultipleDocumentHandlingType(1);

        private MultipleDocumentHandlingType(int n) {
            super(n, NAMES);
        }
    }

    public static final class SidesType
    extends AttributeValue {
        private static final String[] NAMES = new String[]{"one-sided", "two-sided-long-edge", "two-sided-short-edge"};
        public static final SidesType ONE_SIDED = new SidesType(0);
        public static final SidesType TWO_SIDED_LONG_EDGE = new SidesType(1);
        public static final SidesType TWO_SIDED_SHORT_EDGE = new SidesType(2);

        private SidesType(int n) {
            super(n, NAMES);
        }
    }

    public static final class DefaultSelectionType
    extends AttributeValue {
        private static final String[] NAMES = new String[]{"all", "range", "selection"};
        public static final DefaultSelectionType ALL = new DefaultSelectionType(0);
        public static final DefaultSelectionType RANGE = new DefaultSelectionType(1);
        public static final DefaultSelectionType SELECTION = new DefaultSelectionType(2);

        private DefaultSelectionType(int n) {
            super(n, NAMES);
        }
    }

    public static final class DestinationType
    extends AttributeValue {
        private static final String[] NAMES = new String[]{"file", "printer"};
        public static final DestinationType FILE = new DestinationType(0);
        public static final DestinationType PRINTER = new DestinationType(1);

        private DestinationType(int n) {
            super(n, NAMES);
        }
    }

    public static final class DialogType
    extends AttributeValue {
        private static final String[] NAMES = new String[]{"common", "native", "none"};
        public static final DialogType COMMON = new DialogType(0);
        public static final DialogType NATIVE = new DialogType(1);
        public static final DialogType NONE = new DialogType(2);

        private DialogType(int n) {
            super(n, NAMES);
        }
    }
}

