/*
 * TabButton.h - declaration of class TabButton
 *
 * Copyright (c) 2005-2007 Tobias Doerffel <tobydox/at/users.sourceforge.net>
 *
 * This file is part of LMMS - https://lmms.io
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program (see COPYING); if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA.
 *
 */


#ifndef TAB_BUTTON_H
#define TAB_BUTTON_H

#include <QPushButton>


class TabButton : public QPushButton
{
	Q_OBJECT
public:
	TabButton( const QString & _text, int _id, QWidget * _parent ) :
		QPushButton( _text, _parent ),
		m_id( _id )
	{
		setCheckable( true );
		connect( this, SIGNAL( clicked() ), this,
						SLOT( slotClicked() ) );
	}

	~TabButton()
	{
	}


signals:
	void clicked( int );


protected slots:
	void slotClicked()
	{
		emit clicked( m_id );
	}


private:
	int m_id;

} ;

#endif
