/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.x509;

import gnu.java.security.x509.X500DistinguishedName;
import java.io.IOException;
import java.security.Principal;
import java.security.cert.CRL;
import java.security.cert.CRLSelector;
import java.security.cert.X509CRL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

public class X509CRLSelectorImpl
implements CRLSelector {
    private Set issuerNames = new HashSet();

    public void addIssuerName(byte[] byArray) throws IOException {
        this.issuerNames.add(new X500DistinguishedName(byArray));
    }

    public void addIssuerName(String string) {
        this.issuerNames.add(new X500DistinguishedName(string));
    }

    public void addIssuerName(Principal principal) throws IOException {
        if (principal instanceof X500DistinguishedName) {
            this.issuerNames.add(principal);
        } else if (principal instanceof X500Principal) {
            this.issuerNames.add(new X500DistinguishedName(((X500Principal)principal).getEncoded()));
        } else {
            this.issuerNames.add(new X500DistinguishedName(principal.getName()));
        }
    }

    public Collection getIssuerNames() {
        return Collections.unmodifiableSet(this.issuerNames);
    }

    public Object clone() {
        X509CRLSelectorImpl x509CRLSelectorImpl = new X509CRLSelectorImpl();
        x509CRLSelectorImpl.issuerNames.addAll(this.issuerNames);
        return x509CRLSelectorImpl;
    }

    public boolean match(CRL cRL) {
        if (!(cRL instanceof X509CRL)) {
            return false;
        }
        try {
            Principal principal = ((X509CRL)cRL).getIssuerDN();
            X500DistinguishedName x500DistinguishedName = null;
            x500DistinguishedName = principal instanceof X500DistinguishedName ? (X500DistinguishedName)principal : (principal instanceof X500Principal ? new X500DistinguishedName(((X500Principal)principal).getEncoded()) : new X500DistinguishedName(principal.getName()));
            Iterator iterator = this.issuerNames.iterator();
            while (iterator.hasNext()) {
                X500DistinguishedName x500DistinguishedName2 = (X500DistinguishedName)iterator.next();
                if (!x500DistinguishedName.equals(x500DistinguishedName2)) continue;
                return true;
            }
        }
        catch (Exception exception) {}
        return false;
    }
}

